/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.platform.services;

import java.nio.file.Path;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import xaero.common.misc.IObfuscatedReflection;
import xaero.common.misc.ObfuscatedReflectionForge;
import xaero.common.platform.services.IPlatformHelper;
import xaero.hud.controls.key.IKeyBindingHelper;
import xaero.hud.controls.key.KeyBindingHelperForge;
import xaero.hud.render.util.ForgeRenderUtil;
import xaero.hud.render.util.IPlatformRenderUtil;

public class ForgePlatformHelper
implements IPlatformHelper {
    private final ObfuscatedReflectionForge obfuscatedReflectionForge = new ObfuscatedReflectionForge();
    private final KeyBindingHelperForge keyBindingHelperForge = new KeyBindingHelperForge();
    private final ForgeRenderUtil forgeRenderUtil = new ForgeRenderUtil();

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean checkModForMixin(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public IObfuscatedReflection getObfuscatedReflection() {
        return this.obfuscatedReflectionForge;
    }

    @Override
    public IKeyBindingHelper getKeyBindingHelper() {
        return this.keyBindingHelperForge;
    }

    @Override
    public IPlatformRenderUtil getPlatformRenderUtil() {
        return this.forgeRenderUtil;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Path getModFile(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId).getFile().getFilePath();
    }
}

