/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import xaero.common.graphics.ImprovedCompositeRenderType;
import xaero.common.graphics.shader.BuiltInCustomUniforms;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.misc.Misc;
import xaero.hud.render.TextureLocations;

public class CustomRenderTypes
extends RenderType {
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    protected static final BlendFunction TRANSLUCENT_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction LINES_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction PREMULTIPLIED_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction NEGATIVE_TRANSPARENCY = new BlendFunction(SourceFactor.ONE_MINUS_DST_COLOR, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction REPLACE_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
    protected static final BlendFunction ADD_ALPHA_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE);
    public static final RenderPipeline RP_POSITION_TEX_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_REPLACE;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_CULL;
    public static final RenderPipeline RP_POSITION;
    public static final RenderPipeline RP_POSITION_NO_DEPTH;
    public static final RenderPipeline RP_NEGATIVE_COLOR;
    public static final RenderPipeline RP_ICON_OUTLINE;
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_BILINEAR_PREMULTIPLIED;
    public static final RenderType GUI_BILINEAR_NO_DEPTH;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;
    public static final RenderType DEPTH_CLEAR;
    private static final Method compositeStateBuilderMethod;
    private static final Method compositeStateBuilderCreateCompositeStateMethod;
    private static final Method compositeStateBuilderSetTextureStateMethod;
    private static final Method compositeStateBuilderSetLightmapStateMethod;
    private static final Method compositeStateBuilderSetOverlayStateMethod;
    private static final Method compositeStateBuilderSetLayeringStateMethod;
    private static final Method compositeStateBuilderSetOutputStateMethod;
    private static final Method compositeStateBuilderSetTexturingStateMethod;
    private static final Method compositeStateBuilderSetLineStateMethod;
    private static final Method renderTypeCreateMethod;

    public static RenderType entityIconRenderType(ResourceLocation texture, RenderPipeline renderPipeline) {
        return CustomRenderTypes.createRenderType("xaero_entity_icon", 1536, true, true, renderPipeline, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, TriState.FALSE, false)).setOverlayState(RenderStateShard.OVERLAY).setLightmapState(RenderStateShard.NO_LIGHTMAP).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
    }

    private CustomRenderTypes(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable startAction, Runnable endAction) {
        super(name, bufferSize, affectsCrumbling, sortOnUpload, startAction, endAction);
    }

    public void draw(MeshData var1) {
        throw new IllegalAccessError();
    }

    public RenderTarget getRenderTarget() {
        throw new IllegalAccessError();
    }

    public RenderPipeline getRenderPipeline() {
        throw new IllegalAccessError();
    }

    public VertexFormat format() {
        throw new IllegalAccessError();
    }

    public VertexFormat.Mode mode() {
        throw new IllegalAccessError();
    }

    public static RenderPipeline getBasicRenderPipeline() {
        return RenderPipelines.ENTITY_TRANSLUCENT;
    }

    private static CustomStateBuilder getStateBuilder() {
        return new CustomStateBuilder((RenderType.CompositeState.CompositeStateBuilder)Misc.getReflectMethodValue(null, compositeStateBuilderMethod, new Object[0]));
    }

    private static RenderType createRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, CustomStateBuilder stateBuilder, RenderType.OutlineProperty outlineProperty) {
        RenderType.CompositeState compositeState = stateBuilder.createCompositeState(outlineProperty);
        RenderType normalRenderType = (RenderType)Misc.getReflectMethodValue(null, renderTypeCreateMethod, name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, compositeState);
        return new ImprovedCompositeRenderType(name, bufferSize, affectsCrumbling, sortOnUpload, normalRenderType);
    }

    static {
        try {
            Class<?> compositeStateClass = Misc.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            compositeStateBuilderMethod = Misc.getMethodReflection(compositeStateClass, "builder", "method_23598", "()Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110628_", new Class[0]);
            compositeStateBuilderCreateCompositeStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "createCompositeState", "method_24297", "(Lnet/minecraft/class_1921$class_4750;)Lnet/minecraft/class_1921$class_4688;", "m_110689_", RenderType.OutlineProperty.class);
            compositeStateBuilderSetTextureStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setTextureState", "method_34577", "(Lnet/minecraft/class_4668$class_5939;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_173290_", RenderStateShard.EmptyTextureStateShard.class);
            compositeStateBuilderSetLightmapStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLightmapState", "method_23608", "(Lnet/minecraft/class_4668$class_4676;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110671_", RenderStateShard.LightmapStateShard.class);
            compositeStateBuilderSetOverlayStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setOverlayState", "method_23611", "(Lnet/minecraft/class_4668$class_4679;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110677_", RenderStateShard.OverlayStateShard.class);
            compositeStateBuilderSetLayeringStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLayeringState", "method_23607", "(Lnet/minecraft/class_4668$class_4675;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110669_", RenderStateShard.LayeringStateShard.class);
            compositeStateBuilderSetOutputStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setOutputState", "method_23610", "(Lnet/minecraft/class_4668$class_4678;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110675_", RenderStateShard.OutputStateShard.class);
            compositeStateBuilderSetTexturingStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setTexturingState", "method_23614", "(Lnet/minecraft/class_4668$class_4684;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110683_", RenderStateShard.TexturingStateShard.class);
            compositeStateBuilderSetLineStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLineState", "method_23609", "(Lnet/minecraft/class_4668$class_4677;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110673_", RenderStateShard.LineStateShard.class);
            renderTypeCreateMethod = Misc.getMethodReflection(RenderType.class, "create", "method_24049", "(Ljava/lang/String;IZZLcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/class_1921$class_4688;)Lnet/minecraft/class_1921$class_4687;", "m_173215_", String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, RenderPipeline.class, RenderType.CompositeState.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        RenderPipeline.Snippet MATRICES_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withUniform("ModelViewMat", UniformType.MATRIX4X4).withUniform("ProjMat", UniformType.MATRIX4X4).buildSnippet();
        RenderPipeline.Snippet MATRICES_COLOR_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withUniform("ColorModulator", UniformType.VEC4).buildSnippet();
        RenderPipeline.Snippet MATRICES_FOG_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withUniform("FogStart", UniformType.FLOAT).withUniform("FogEnd", UniformType.FLOAT).withUniform("FogShape", UniformType.INT).withUniform("FogColor", UniformType.VEC4).buildSnippet();
        RenderPipeline.Snippet POSITION_TEX_NO_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withVertexShader(MinimapShaders.POSITION_TEX_NO_ALPHA_TEST).withFragmentShader(MinimapShaders.POSITION_TEX_NO_ALPHA_TEST).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_NO_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_no_alpha")).withBlend(TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_TEX_NO_ALPHA_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_no_alpha")).withBlend(TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_TEX_NO_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_no_alpha_no_blend")).withoutBlend().build();
        RenderPipeline.Snippet RP_POSITION_TEX_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withVertexShader(MinimapShaders.POSITION_TEX_ALPHA_TEST).withFragmentShader(MinimapShaders.POSITION_TEX_ALPHA_TEST).withUniform(BuiltInCustomUniforms.DISCARD_ALPHA.name(), BuiltInCustomUniforms.DISCARD_ALPHA.type()).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_alpha")).withBlend(TRANSLUCENT_TRANSPARENCY).build();
        RP_ICON_OUTLINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/icon_outline")).withBlend(ADD_ALPHA_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_alpha_no_blend")).withoutBlend().build();
        RP_POSITION_TEX_ALPHA_REPLACE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_alpha_replace")).withBlend(REPLACE_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_tex_alpha_no_cull")).withBlend(TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_no_depth")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_NEGATIVE_COLOR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_negative_color")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(NEGATIVE_TRANSPARENCY).build();
        RenderPipeline.Snippet POSITION_COLOR_TEX_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withVertexShader(MinimapShaders.POSITION_COLOR_TEX).withFragmentShader(MinimapShaders.POSITION_COLOR_TEX).withVertexFormat(POSITION_COLOR_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withVertexShader(MinimapShaders.POSITION_COLOR).withFragmentShader(MinimapShaders.POSITION_COLOR).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withVertexShader(MinimapShaders.POSITION_COLOR_NO_ALPHA_TEST).withFragmentShader(MinimapShaders.POSITION_COLOR_NO_ALPHA_TEST).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RenderPipeline POSITION_COLOR_TEX_TRANSLUCENT_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_col_text_translucent")).withBlend(TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        GUI_NEAREST = CustomRenderTypes.createRenderType("xaero_gui_nearest", 786432, false, false, POSITION_COLOR_TEX_TRANSLUCENT_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.FALSE, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        GUI_BILINEAR = CustomRenderTypes.createRenderType("xaero_gui_bilinear", 786432, false, false, POSITION_COLOR_TEX_TRANSLUCENT_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.TRUE, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_col_text_translucent")).withBlend(TRANSLUCENT_TRANSPARENCY).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        GUI_BILINEAR_NO_DEPTH = CustomRenderTypes.createRenderType("xaero_gui_bilinear_no_depth", 786432, false, false, POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.TRUE, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline POSITION_COLOR_TEX_PREMULTIPLIED_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_col_text_premultiplied")).withBlend(PREMULTIPLIED_TRANSPARENCY).withCull(false).build();
        GUI_BILINEAR_PREMULTIPLIED = CustomRenderTypes.createRenderType("xaero_gui_bilinear_pre", 786432, false, false, POSITION_COLOR_TEX_PREMULTIPLIED_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureLocations.GUI_TEXTURES, TriState.TRUE, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline POSITION_COLOR_TRANSLUCENT_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/pos_col_translucent")).withBlend(TRANSLUCENT_TRANSPARENCY).build();
        COLORED_WAYPOINTS_BGS = CustomRenderTypes.createRenderType("xaero_colored_waypoints", 786432, false, false, POSITION_COLOR_TRANSLUCENT_PL, CustomRenderTypes.getStateBuilder().setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING_FORWARD).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RADAR_NAME_BGS = CustomRenderTypes.createRenderType("xaero_radar_name_bg", 786432, false, false, POSITION_COLOR_TRANSLUCENT_PL, CustomRenderTypes.getStateBuilder().setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING_FORWARD).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        MAP_CHUNK_OVERLAY = CustomRenderTypes.createRenderType("xaero_chunk_overlay", 786432, false, false, POSITION_COLOR_TRANSLUCENT_PL, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline LINES_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/lines")).withVertexShader(MinimapShaders.FRAMEBUFFER_LINES).withFragmentShader(MinimapShaders.FRAMEBUFFER_LINES).withUniform("LineWidth", UniformType.FLOAT).withUniform(BuiltInCustomUniforms.FRAME_SIZE.name(), BuiltInCustomUniforms.FRAME_SIZE.type()).withVertexFormat(DefaultVertexFormat.POSITION_COLOR_NORMAL, VertexFormat.Mode.LINES).withBlend(LINES_TRANSPARENCY).build();
        MAP_LINES = CustomRenderTypes.createRenderType("xaero_lines", 1536, false, false, LINES_PL, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline DEPTH_CLEAR_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_NO_ALPHA_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaerominimap", (String)"pipeline/depth_clear")).withBlend(TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).withColorWrite(false, false).build();
        DEPTH_CLEAR = CustomRenderTypes.createRenderType("xaero_depth_clear", 1536, false, false, DEPTH_CLEAR_PL, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
    }

    private static final class CustomStateBuilder {
        private final RenderType.CompositeState.CompositeStateBuilder original;

        private CustomStateBuilder(RenderType.CompositeState.CompositeStateBuilder original) {
            this.original = original;
        }

        private CustomStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard textureState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetTextureStateMethod, textureState);
            return this;
        }

        private CustomStateBuilder setLightmapState(RenderStateShard.LightmapStateShard lightmapState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetLightmapStateMethod, lightmapState);
            return this;
        }

        private CustomStateBuilder setOverlayState(RenderStateShard.OverlayStateShard overlayState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetOverlayStateMethod, overlayState);
            return this;
        }

        private CustomStateBuilder setLayeringState(RenderStateShard.LayeringStateShard layeringState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetLayeringStateMethod, layeringState);
            return this;
        }

        private CustomStateBuilder setOutputState(RenderStateShard.OutputStateShard outputState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetOutputStateMethod, outputState);
            return this;
        }

        private CustomStateBuilder setTexturingState(RenderStateShard.TexturingStateShard texturingState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetTexturingStateMethod, texturingState);
            return this;
        }

        private CustomStateBuilder setLineState(RenderStateShard.LineStateShard lineState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetLineStateMethod, lineState);
            return this;
        }

        private RenderType.CompositeState createCompositeState(RenderType.OutlineProperty outlineProperty) {
            return (RenderType.CompositeState)Misc.getReflectMethodValue(this.original, compositeStateBuilderCreateCompositeStateMethod, outlineProperty);
        }
    }
}

