/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.systems.ScissorState;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderPipelines;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.shader.CustomUniforms;
import xaero.common.graphics.shader.PositionTexAlphaTestShaderHelper;
import xaero.common.platform.Services;

public class ImmediateRenderUtil {
    private static Vector4f SHADER_COLOR = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final String RENDER_PASS_NAME = "xaero render pass";

    public static void coloredRectangle(PoseStack matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.last().pose(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrix, x1, y1, x2, y2, color, RenderPipelines.GUI);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color, RenderPipeline renderPipeline) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, renderPipeline.getVertexFormat());
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f).setColor(r, g, b, a);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f).setColor(r, g, b, a);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), renderPipeline);
    }

    public static void gradientRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color1, int color2) {
        float a1 = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(color1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(color1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(color1 & 0xFF) / 255.0f;
        float a2 = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color2 & 0xFF) / 255.0f;
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f).setColor(r2, g2, b2, a2);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f).setColor(r2, g2, b2, a2);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f).setColor(r1, g1, b1, a1);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f).setColor(r1, g1, b1, a1);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), RenderPipelines.GUI);
    }

    public static void negativeColorRectangle(PoseStack matrices, float x1, float y1, float x2, float y2) {
        Matrix4f matrix = matrices.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), CustomRenderTypes.RP_NEGATIVE_COLOR);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        RenderPipeline pipeline;
        if (discardAlpha < 0.0f) {
            pipeline = CustomRenderTypes.RP_POSITION_TEX_NO_ALPHA;
        } else {
            pipeline = CustomRenderTypes.RP_POSITION_TEX_ALPHA;
            PositionTexAlphaTestShaderHelper.setDiscardAlpha(discardAlpha);
        }
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, pipeline);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor, RenderPipeline renderPipeline) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, (float)textureX + width, (float)textureY + textureH, factor, renderPipeline);
    }

    public static void texturedRect(PoseStack matrixStack, float x, float y, float textureX1, float textureY1, float width, float height, float textureX2, float textureY2, float factor, RenderPipeline renderPipeline) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, renderPipeline.getVertexFormat());
        vertexBuffer.addVertex(matrix, x + 0.0f, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(textureX1 * f, textureY1 * f1);
        vertexBuffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(textureX2 * f, textureY1 * f1);
        vertexBuffer.addVertex(matrix, x + width, y + 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(textureX2 * f, textureY2 * f1);
        vertexBuffer.addVertex(matrix, x + 0.0f, y + 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(textureX1 * f, textureY2 * f1);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), renderPipeline);
    }

    public static void drawOutlineLayer(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        RenderPipeline pipeline = CustomRenderTypes.RP_ICON_OUTLINE;
        PositionTexAlphaTestShaderHelper.setDiscardAlpha(discardAlpha);
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, pipeline);
    }

    public static void drawImmediateMeshData(MeshData meshData, RenderPipeline renderPipeline) {
        ImmediateRenderUtil.drawImmediateMeshData(meshData, renderPipeline, Minecraft.getInstance().getMainRenderTarget());
    }

    public static void drawImmediateMeshData(MeshData meshData, RenderPipeline renderPipeline, RenderTarget target) {
        GpuTextureView colorTarget;
        VertexFormat.IndexType gpuIndexType;
        GpuBuffer gpuIndexBuffer;
        ByteBuffer indexBuffer = meshData.indexBuffer();
        if (indexBuffer == null) {
            RenderSystem.AutoStorageIndexBuffer sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)meshData.drawState().mode());
            gpuIndexBuffer = sequentialBuffer.getBuffer(meshData.drawState().indexCount());
            gpuIndexType = sequentialBuffer.type();
        } else {
            gpuIndexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(indexBuffer);
            gpuIndexType = meshData.drawState().indexType();
        }
        GpuBuffer gpuVertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.vertexBuffer());
        GpuTextureView gpuTextureView = colorTarget = RenderSystem.outputColorTextureOverride != null ? RenderSystem.outputColorTextureOverride : target.getColorTextureView();
        GpuTextureView depthTarget = target.useDepth ? (RenderSystem.outputDepthTextureOverride != null ? RenderSystem.outputDepthTextureOverride : target.getDepthTextureView()) : null;
        try (MeshData meshData2 = meshData;
             RenderPass renderPass = ImmediateRenderUtil.createRenderPass(RENDER_PASS_NAME, renderPipeline, colorTarget, depthTarget);){
            renderPass.setIndexBuffer(gpuIndexBuffer, gpuIndexType);
            renderPass.setVertexBuffer(0, gpuVertexBuffer);
            renderPass.drawIndexed(0, 0, meshData.drawState().indexCount(), 1);
        }
    }

    private static GpuBufferSlice getUpdatedDynamicUniforms() {
        return RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)SHADER_COLOR, (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
    }

    private static void prepareRenderPass(RenderPass renderPass, RenderPipeline renderPipeline, GpuBufferSlice dynamicUniformsBuffer) {
        renderPass.setPipeline(renderPipeline);
        ScissorState scissorState = RenderSystem.getScissorStateForRenderTypeDraws();
        if (scissorState.enabled()) {
            renderPass.enableScissor(scissorState.x(), scissorState.y(), scissorState.width(), scissorState.height());
        }
        renderPass.setUniform("DynamicTransforms", dynamicUniformsBuffer);
        RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
        Services.PLATFORM.getPlatformRenderUtil().onPrepareRenderPass(renderPass);
        for (int textureIndex = 0; textureIndex < 12; ++textureIndex) {
            GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)textureIndex);
            if (gpuTexture == null) continue;
            renderPass.bindSampler("Sampler" + textureIndex, gpuTexture);
        }
        ImmediateRenderUtil.updateCustomUniforms(renderPipeline, renderPass);
    }

    private static void updateCustomUniforms(RenderPipeline renderPipeline) {
        ImmediateRenderUtil.updateCustomUniforms(renderPipeline, null);
    }

    private static void updateCustomUniforms(RenderPipeline renderPipeline, RenderPass renderPass) {
        for (RenderPipeline.UniformDescription uniform : renderPipeline.getUniforms()) {
            GpuBufferSlice valueBuffer;
            if (!CustomUniforms.isCustom(uniform) || (valueBuffer = CustomUniforms.getUpdatedUniformBuffer(uniform)) == null || renderPass == null) continue;
            renderPass.setUniform(uniform.name(), valueBuffer);
        }
    }

    public static RenderPass createRenderPass(String name, RenderPipeline renderPipeline, GpuTextureView colorTarget, GpuTextureView depthTarget) {
        GpuBufferSlice dynamicUniforms = ImmediateRenderUtil.getUpdatedDynamicUniforms();
        ImmediateRenderUtil.updateCustomUniforms(renderPipeline);
        RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> name, colorTarget, OptionalInt.empty(), depthTarget, OptionalDouble.empty());
        ImmediateRenderUtil.prepareRenderPass(renderPass, renderPipeline, dynamicUniforms);
        return renderPass;
    }

    public static void setShaderColor(float red, float green, float blue, float alpha) {
        SHADER_COLOR.set(red, green, blue, alpha);
    }
}

