/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.notification;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import xaero.hud.pvp.module.notification.Notification;
import xaero.hud.pvp.module.notification.NotificationSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class NotificationRenderer
implements IModuleRenderer<NotificationSession> {
    @Override
    public void render(NotificationSession session, ModuleRenderContext c, float partialTicks) {
        boolean air;
        if (System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        Minecraft mc = Minecraft.func_71410_x();
        int total = 0;
        boolean lowHunger = session.getNotificationHunger() && (float)mc.field_71439_g.func_71024_bL().func_75116_a() <= 2.0f * (float)session.getLowHunger();
        boolean lowHealth = session.getNotificationHP() && mc.field_71439_g.func_110143_aJ() <= 2.0f * (float)session.getLowHealth();
        boolean tnt = session.getNotificationTNT() && session.getWorldHelper().tntIsAround(mc.field_71439_g);
        boolean arrow = session.getNotificationArrow() && session.getWorldHelper().arrowIsAround(mc.field_71439_g);
        boolean bl = air = session.getNotificationAir() && mc.field_71439_g.func_70086_ai() <= 30 * session.getLowAir();
        if (lowHunger) {
            ++total;
        }
        if (lowHealth) {
            ++total;
        }
        if (tnt) {
            ++total;
        }
        if (arrow) {
            ++total;
        }
        if (air) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        int between = 32 - 4 * total;
        int unitLength = 32 + between;
        int totalLength = total * unitLength;
        int drawY = c.y + (c.h - 32) / 2;
        int drawX = c.x + c.w / 2 - totalLength / 2 + between / 2;
        GlStateManager.func_179141_d();
        if (session.getBlink()) {
            GlStateManager.func_179131_c((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        mc.func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        if (lowHunger) {
            this.renderNotification(mc, Notification.LOW_HUNGER, drawX, drawY);
            drawX += unitLength;
        }
        if (lowHealth) {
            this.renderNotification(mc, Notification.LOW_HEALTH, drawX, drawY);
            drawX += unitLength;
        }
        if (tnt) {
            this.renderNotification(mc, Notification.TNT, drawX, drawY);
            drawX += unitLength;
        }
        if (arrow) {
            this.renderNotification(mc, Notification.ARROW, drawX, drawY);
            drawX += unitLength;
        }
        if (air) {
            this.renderNotification(mc, Notification.AIR, drawX, drawY);
            drawX += unitLength;
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderNotification(Minecraft mc, Notification notification, int drawX, int drawY) {
        mc.field_71456_v.func_73729_b(drawX, drawY, 17, notification.getTextureIndex() * 32, notification.getTextureW(), 32);
    }
}

