/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.tooltip;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import xaero.common.gui.GuiEditMode;
import xaero.hud.pvp.module.tooltip.ItemTooltipSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class ItemTooltipRenderer
implements IModuleRenderer<ItemTooltipSession> {
    @Override
    public void render(ItemTooltipSession session, ModuleRenderContext c, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack currentStack = mc.field_71439_g.field_71071_by.func_70448_g();
        if (currentStack != session.getPreviousStack()) {
            session.setItemSwitchTime(System.currentTimeMillis());
            session.setPreviousStack(currentStack);
        }
        if (currentStack == null) {
            return;
        }
        if (currentStack.func_190926_b()) {
            return;
        }
        if (!(mc.field_71462_r instanceof GuiEditMode) && System.currentTimeMillis() - session.getItemSwitchTime() > (long)((int)(session.getItemTooltipTime() * 1000.0))) {
            return;
        }
        GuiScreen screenInstance = session.getScreenInstance();
        screenInstance.field_146297_k = mc;
        int screenWidth = c.screenWidth;
        int screenHeight = c.screenHeight;
        List<String> textLines = session.getTooltipHelper().getTooltipLines(mc, currentStack, c.screenWidth, c.screenHeight, screenInstance);
        if (textLines.size() >= session.getItemTooltipMinLines()) {
            int border = 5;
            int renderX = c.x + border;
            int renderY = c.y + border;
            int renderW = c.w - 2 * border;
            int renderH = c.h - 2 * border;
            if (session.isCentered() || c.flippedHorizontally) {
                int tooltipTextWidth = 0;
                for (String textLine : textLines) {
                    int textLineWidth = mc.field_71466_p.func_78256_a(textLine);
                    if (textLineWidth <= tooltipTextWidth) continue;
                    tooltipTextWidth = textLineWidth;
                }
                int tooltipWidth = tooltipTextWidth + 8;
                if (session.isCentered()) {
                    renderX += (renderW - tooltipWidth) / 2;
                } else {
                    screenWidth = renderX + renderW;
                    renderX += renderW - tooltipWidth;
                }
            }
            if (c.flippedVertically) {
                int tooltipHeight = 16;
                if (textLines.size() > 1) {
                    tooltipHeight += 2 + (textLines.size() - 1) * 10;
                }
                screenHeight = renderY + renderH;
                renderY += renderH - tooltipHeight;
            }
            screenInstance.field_146294_l = screenWidth;
            screenInstance.field_146295_m = screenHeight;
            GuiUtils.preItemToolTip((ItemStack)currentStack);
            GuiUtils.drawHoveringText(textLines, (int)(renderX - 8), (int)(renderY + 16), (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)mc.field_71466_p);
            GuiUtils.postItemToolTip();
            RenderHelper.func_74518_a();
        }
    }
}

