/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp.gui;

import com.feed_the_beast.ftblib.lib.util.misc.BooleanConsumer;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiReset;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenSwitchSettingEntry;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.pvp.common.config.option.BetterPVPProfiledConfigOptions;
import xaero.hud.pvp.controls.key.BetterPVPKeyMappings;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.GuiConstants;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;
import xaero.pvp.gui.GuiCustomization;

public class GuiPvpSettings
extends EditConfigScreen {
    public GuiPvpSettings(final IXaeroMinimap modMain, final GuiScreen par1GuiScreen, GuiScreen escScreen, final IEditConfigScreenContext context) {
        super((ITextComponent)new TextComponentTranslation("gui.xaero_better_pvp_settings", new Object[0]), par1GuiScreen, escScreen, context, HudMod.INSTANCE.getHudConfigs());
        ScreenSwitchSettingEntry customizationEntry = new ScreenSwitchSettingEntry("gui.xaero_custom_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiCustomization(modMain, current, escape, context);
            }
        }, null, true);
        ScreenSwitchSettingEntry resetEntry = new ScreenSwitchSettingEntry("gui.xaero_reset_config_profile_default", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiReset(new BooleanConsumer(){

                    public void accept(boolean b) {
                        GuiPvpSettings.this.resetConfirmResult(b);
                    }
                }, par1GuiScreen, escape);
            }
        }, null, true, false);
        ScreenSwitchSettingEntry editEntry = new ScreenSwitchSettingEntry("gui.xaero_edit_mode", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiEditMode(modMain, current, escape, true, (ITextComponent)new TextComponentTranslation("gui.xaero_welcome_edit_mode", new Object[0]));
            }
        }, context.isClientSide() ? null : new Tooltip(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT), context.isClientSide());
        ScreenSwitchSettingEntry waypointsEntry = new ScreenSwitchSettingEntry("gui.xaero_waypoints", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                MinimapSession minimapSession2 = BuiltInHudModules.MINIMAP.getCurrentSession();
                if (minimapSession2 != null && modMain.getSettings().waypointsGUI(minimapSession2)) {
                    return new GuiWaypoints((HudMod)modMain, minimapSession2, (GuiScreen)GuiPvpSettings.this, escape);
                }
                return null;
            }
        }, context.isClientSide() ? null : new Tooltip(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT), new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                if (!context.isClientSide()) {
                    return false;
                }
                MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
                return minimapSession != null && modMain.getSettings().waypointsGUI(minimapSession);
            }
        });
        this.entries = new ISettingEntry[]{this.createProfileIDEntry(), this.optionEntry(BuiltInProfiledConfigOptions.PROFILE_NAME), customizationEntry, editEntry, this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_MINIMAP), waypointsEntry, this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.ARMOR_STATUS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.STATUS_EFFECTS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.NOTIFICATIONS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.XP_DROPS), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.BETTER_SPRINT), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.TOGGLED_SNEAK), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.QUICK_USE), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.ENTITY_INFO), this.optionEntry((ConfigOption)BetterPVPProfiledConfigOptions.ITEM_TOOLTIP), resetEntry, this.optionEntry((ConfigOption)BuiltInProfiledConfigOptions.IGNORE_ENFORCEMENT_IF_EDITOR)};
        this.canSearch = false;
        this.canSkipWorldRender = false;
        this.shouldRenderEscapeScreen = false;
    }

    protected void onEditedProfileSwitch() {
        super.onEditedProfileSwitch();
        EntityRadarCategoryManager categoryManager = HudMod.INSTANCE.getEntityRadarCategoryManager();
        categoryManager.forgetEditedCategory();
    }

    private void resetConfirmResult(boolean b) {
        if (b) {
            EntityRadarCategoryManager categoryManager = HudMod.INSTANCE.getEntityRadarCategoryManager();
            if (categoryManager.getEditedCategory() == null) {
                categoryManager.loadEditedCategory((Config)this.context.getCurrentProfile(this.channel), this.context.isClientSide());
            }
            categoryManager.resetRootCategorySettings(this.context);
            this.resetProfileToDefaults();
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    protected void func_73869_a(char typedChar, int key) throws IOException {
        super.func_73869_a(typedChar, key);
        if (this.handledKeyboardInput) {
            return;
        }
        if (this.context.isClientSide() && KeyMappingUtils.inputMatches((boolean)false, (int)key, (KeyBinding)BetterPVPKeyMappings.SETTINGS, (int)0) || !this.context.isClientSide() && KeyMappingUtils.inputMatches((boolean)false, (int)key, (KeyBinding)BetterPVPKeyMappings.SERVER_PROFILES, (int)0)) {
            this.onExit(this.escape);
            this.handledKeyboardInput = true;
            return;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.screenTitle = new TextComponentTranslation("gui.xaero_better_pvp_settings", new Object[0]);
        if (ModSettings.serverSettings != ModSettings.defaultSettings) {
            this.screenTitle = new TextComponentString("\u00a7e" + I18n.func_135052_a((String)"gui.xaero_server_disabled", (Object[])new Object[0]));
        }
    }
}

