/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.compass.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import xaero.common.HudMod;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.compass.render.CardinalDirection;
import xaero.hud.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.render.util.RenderBufferUtil;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;

public class CompassRenderer {
    private final HudMod modMain;
    private final Minecraft mc;
    private double[] partialDest;

    public CompassRenderer(HudMod modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.partialDest = new double[2];
    }

    public void drawCompass(PoseStack matrixStack, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background, MultiBufferSource.BufferSource textRenderTypeBuffer, VertexConsumer nameBgBuilder) {
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        int compassLocationConfig = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_LOCATION);
        if (compassLocationConfig == 0) {
            return;
        }
        int shadowColorConfig = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_SHADOW_COLOR);
        WaypointColor defaultColor = WaypointColor.fromIndex(shadowColorConfig);
        MinimapRendererHelper rendererHelper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
        int northShadowColorConfig = (Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.COMPASS_NORTH_SHADOW_COLOR);
        int effectiveNorthShadowColorConfig = northShadowColorConfig == -1 ? shadowColorConfig : northShadowColorConfig;
        for (int i = 0; i < 4; ++i) {
            WaypointColor effectiveColor;
            double offX = (i & 1) * (i == 1 ? 10000 : -10000);
            double offY = (i + 1 & 1) * (i == 2 ? 10000 : -10000);
            matrixStack.m_85836_();
            MinimapElementOverMapRendererHandler.translatePosition(matrixStack, specW, specH, specW, specH, ps, pc, offX, offY, zoom, circle, this.partialDest);
            matrixStack.m_252880_(-1.0f, -1.0f, 0.0f);
            matrixStack.m_85841_(minimapScale, minimapScale, 1.0f);
            Component initials = CardinalDirection.values()[i].getInitials();
            int halfW = this.mc.f_91062_.m_92852_((FormattedText)initials) / 2 - 1;
            WaypointColor waypointColor = effectiveColor = i == 0 ? WaypointColor.fromIndex(effectiveNorthShadowColorConfig) : defaultColor;
            if (background) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                RenderBufferUtil.addColoredRect(matrixStack.m_85850_().m_252922_(), nameBgBuilder, -4 - addedFrame, -4 - addedFrame, 9 + 2 * addedFrame, 9 + 2 * addedFrame, 0x90000000 | effectiveColor.getHex() & 0xFFFFFF);
                RenderSystem.defaultBlendFunc();
            }
            Misc.drawNormalText(matrixStack, initials, (float)(-halfW + 1), -2.0f, effectiveColor.getHex(), false, textRenderTypeBuffer);
            matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
            Misc.drawNormalText(matrixStack, initials, (float)(-halfW), -3.0f, -1, false, textRenderTypeBuffer);
            matrixStack.m_85849_();
        }
        matrixStack.m_252880_(0.0f, 0.0f, 2.0f);
    }
}

