/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.pvp.module.armor.ArmorStatusCachedComponents;
import xaero.hud.pvp.module.armor.ArmorStatusInventoryHelper;
import xaero.hud.pvp.module.armor.ArmorStatusSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class ArmorStatusRenderer
implements IModuleRenderer<ArmorStatusSession> {
    public static final int LINE_HEIGHT = 19;
    private int restoresLabelIndex;
    private int durabilityLabelIndex;
    private int labelCountLabelIndex;
    private int enchantsLabelIndex;
    private boolean renderedOffhand;
    private final ArmorStatusInventoryHelper inventoryHelper = new ArmorStatusInventoryHelper();

    @Override
    public void render(ArmorStatusSession session, ModuleRenderContext c, class_332 guiGraphics, float partialTicks) {
        RenderSystem.enableDepthTest();
        this.durabilityLabelIndex = 0;
        this.labelCountLabelIndex = 0;
        this.restoresLabelIndex = 0;
        this.enchantsLabelIndex = 0;
        this.renderedOffhand = false;
        if (!session.isCentered()) {
            this.renderClassic(session, guiGraphics, c);
        } else {
            this.renderCentered(session, guiGraphics, c);
        }
        if (this.renderedOffhand) {
            session.onOffhandItemRender();
        }
        RenderSystem.disableDepthTest();
    }

    private void renderClassic(ArmorStatusSession session, class_332 guiGraphics, ModuleRenderContext c) {
        class_310 mc = class_310.method_1551();
        int iconX = c.x + (c.flippedHorizontally ? c.w - 3 : 3);
        int iconY = c.y + 3;
        if (!c.flippedVertically) {
            iconY = this.renderClassicArmor(iconX, iconY, mc.field_1724, session, guiGraphics, c);
        }
        iconY = this.renderClassicHeldItems(iconX, iconY, mc.field_1724, session, guiGraphics, c);
        if (c.flippedVertically) {
            iconY = this.renderClassicArmor(iconX, iconY, mc.field_1724, session, guiGraphics, c);
        }
    }

    private int renderClassicHeldItems(int iconX, int iconY, class_746 player, ArmorStatusSession session, class_332 guiGraphics, ModuleRenderContext c) {
        class_2561 lastLabel;
        class_2561 firstLabel;
        class_1799 main;
        class_1304 bowHand = this.inventoryHelper.getBowHand(player);
        class_1799 arrows = bowHand != null && session.getArchery() ? this.inventoryHelper.getArrowStack((class_1657)player) : null;
        class_1799 off = session.getDisplayOffHand() ? player.method_6118(class_1304.field_6171) : null;
        class_1799 class_17992 = main = session.getDisplayMainHand() ? player.method_31548().method_7391() : null;
        if (off != null) {
            this.renderedOffhand = true;
        }
        if (off == arrows) {
            off = null;
        }
        if (main == arrows) {
            main = null;
        }
        if (c.flippedVertically) {
            int totalHeldItems = 0;
            if (off != null) {
                ++totalHeldItems;
            }
            if (main != null) {
                ++totalHeldItems;
            }
            if (arrows != null) {
                ++totalHeldItems;
            }
            iconY += 19 * (3 - totalHeldItems);
        }
        class_2561 arrowLabel = arrows == null ? null : this.getArrowCountLabel(arrows, player);
        class_1799 first = c.flippedVertically ? arrows : off;
        Object object = firstLabel = c.flippedVertically ? arrowLabel : null;
        if (first != null) {
            this.renderItemWithInfo(session, guiGraphics, first, firstLabel, iconX, iconY, c.flippedHorizontally, !c.flippedVertically, !c.flippedVertically);
            iconY += 19;
        }
        if (main != null) {
            this.renderItemWithInfo(session, guiGraphics, main, null, iconX, iconY, c.flippedHorizontally, true, false);
            iconY += 19;
        }
        class_1799 last = c.flippedVertically ? off : arrows;
        class_2561 class_25612 = lastLabel = c.flippedVertically ? null : arrowLabel;
        if (last != null) {
            this.renderItemWithInfo(session, guiGraphics, last, lastLabel, iconX, iconY, c.flippedHorizontally, c.flippedVertically, c.flippedVertically);
            iconY += 19;
        }
        return iconY;
    }

    private int renderClassicArmor(int iconX, int iconY, class_746 player, ArmorStatusSession session, class_332 guiGraphics, ModuleRenderContext c) {
        for (int i = 3; i >= 0; --i) {
            class_1799 itemStack = (class_1799)player.method_31548().field_7548.get(i);
            if (!itemStack.method_7960()) {
                this.renderItemWithInfo(session, guiGraphics, itemStack, null, iconX, iconY, c.flippedHorizontally, true, false);
            }
            iconY += 19;
        }
        return iconY;
    }

    private void renderCentered(ArmorStatusSession session, class_332 guiGraphics, ModuleRenderContext c) {
        class_1799 main;
        int line;
        int slot;
        class_310 mc = class_310.method_1551();
        class_1661 inventory = mc.field_1724.method_31548();
        int leftArmorSlotStart = c.flippedHorizontally ? 0 : 2;
        int rightArmorSlotStart = c.flippedHorizontally ? 2 : 0;
        int armorStartLine = c.flippedVertically ? 1 : 0;
        int armorStepDirection = c.flippedVertically ? -1 : 1;
        for (slot = leftArmorSlotStart; slot < leftArmorSlotStart + 2; ++slot) {
            line = armorStartLine + armorStepDirection * (slot - leftArmorSlotStart);
            this.renderItemWithInfo(session, guiGraphics, (class_1799)inventory.field_7548.get(slot), null, c.x + c.w / 2 - 94, c.y + 3 + 19 * line, true, true, false);
        }
        for (slot = rightArmorSlotStart; slot < rightArmorSlotStart + 2; ++slot) {
            line = armorStartLine + armorStepDirection * (slot - rightArmorSlotStart);
            this.renderItemWithInfo(session, guiGraphics, (class_1799)inventory.field_7548.get(slot), null, c.x + c.w / 2 + 94, c.y + 3 + 19 * line, false, true, false);
        }
        class_1304 bowHand = this.inventoryHelper.getBowHand(mc.field_1724);
        class_1799 arrows = bowHand != null && session.getArchery() ? this.inventoryHelper.getArrowStack((class_1657)mc.field_1724) : null;
        class_1799 off = session.getDisplayOffHand() ? mc.field_1724.method_6118(class_1304.field_6171) : null;
        class_1799 class_17992 = main = session.getDisplayMainHand() ? inventory.method_7391() : null;
        if (off != null) {
            this.renderedOffhand = true;
        }
        if (off == arrows) {
            off = null;
        }
        if (main == arrows) {
            main = null;
        }
        boolean mainOnLeft = mc.field_1690.method_42552().method_41753() == class_1306.field_6182;
        int iconY = c.y + c.h / 2 > c.screenHeight / 2 ? c.y + 3 - 19 : c.y + c.h;
        int heldItemsCenteredPosition = session.getHeldItemsCenteredPosition();
        if (heldItemsCenteredPosition == 0) {
            if (off != null) {
                this.renderItemWithInfo(session, guiGraphics, off, null, mainOnLeft ? c.screenWidth - 3 : 3, iconY, mainOnLeft, true, true);
            }
            if (main != null) {
                this.renderItemWithInfo(session, guiGraphics, main, null, mainOnLeft ? 3 : c.screenWidth - 3, iconY, !mainOnLeft, true, false);
            }
        } else {
            if (off != null) {
                this.renderItemWithInfo(session, guiGraphics, off, null, c.x + c.w / 2 + (mainOnLeft ? 94 : -94), iconY, !mainOnLeft, true, true);
            }
            if (main != null) {
                this.renderItemWithInfo(session, guiGraphics, main, null, c.x + c.w / 2 + (mainOnLeft ? -94 : 94), iconY, mainOnLeft, true, false);
            }
        }
        if (arrows == null) {
            return;
        }
        int arrowY = c.y + c.h / 2 > c.screenHeight / 2 ? iconY - 19 : iconY + 19;
        boolean onTheRight = bowHand == class_1304.field_6173 && !mainOnLeft || bowHand == class_1304.field_6171 && mainOnLeft;
        class_2561 arrowLabel = this.getArrowCountLabel(arrows, mc.field_1724);
        if (heldItemsCenteredPosition == 0) {
            this.renderItemWithInfo(session, guiGraphics, arrows, arrowLabel, onTheRight ? c.screenWidth - 3 : 3, arrowY, onTheRight, false, false);
        } else {
            this.renderItemWithInfo(session, guiGraphics, arrows, arrowLabel, c.x + c.w / 2 + (onTheRight ? 94 : -94), arrowY, !onTheRight, false, false);
        }
    }

    public void renderItemWithInfo(ArmorStatusSession session, class_332 guiGraphics, class_1799 stack, class_2561 customLabel, int x, int y, boolean flipped, boolean withSize, boolean keepNormalCount) {
        if (stack == null || stack.method_7909() == class_1802.field_8162) {
            return;
        }
        boolean enchanted = stack.method_7942();
        boolean fullCount = session.getShowFullCount();
        boolean enchants = session.getShowEnchants();
        class_2561 label = customLabel;
        if (label == null) {
            label = this.getDamageLabel(stack, session, withSize && fullCount && keepNormalCount && stack.method_7947() > 1, flipped);
        }
        class_2561 enchantsLabel = null;
        if (enchants) {
            enchantsLabel = this.getEnchantsLabel(enchanted ? (class_9304)stack.method_57824(class_9334.field_49633) : null, session.getEnchantsColor());
        }
        this.renderItemWithLabels(guiGraphics, stack, label, enchantsLabel, x, y, flipped, withSize, fullCount);
    }

    public void renderItemWithLabels(class_332 guiGraphics, class_1799 stack, class_2561 label1, class_2561 label2, int x, int y, boolean flipped, boolean withSize, boolean fullCount) {
        class_310 mc = class_310.method_1551();
        if (stack == null || stack.method_7960()) {
            return;
        }
        class_4587 matrixStack = guiGraphics.method_51448();
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int label1X = iconX + (flipped ? -3 - mc.field_1772.method_27525((class_5348)label1) : 19);
        int label1Y = iconY;
        guiGraphics.method_27535(mc.field_1772, label1, label1X, label1Y, 0xFFFFFF);
        if (label2 != null) {
            int label2X = iconX + (flipped ? -3 - mc.field_1772.method_27525((class_5348)label2) : 19);
            int label2Y = iconY + 9;
            guiGraphics.method_27535(mc.field_1772, label2, label2X, label2Y, 0xFFFFFF);
        }
        matrixStack.method_46416(0.0f, 0.0f, -100.0f);
        guiGraphics.method_51427(stack, iconX, iconY);
        matrixStack.method_46416(0.0f, 0.0f, 100.0f);
        int size = 1;
        if (withSize) {
            size = stack.method_7947();
            if (fullCount) {
                size = this.inventoryHelper.getFullItemCount(stack.method_7909(), mc.field_1724);
            }
        }
        Object sizeString = "" + size;
        if (size <= 1) {
            sizeString = "";
        }
        guiGraphics.method_51432(mc.field_1772, stack, iconX, iconY, (String)sizeString);
    }

    public class_2561 getDamageLabel(class_1799 stack, ArmorStatusSession session, boolean includeCount, boolean flipped) {
        class_4174 food;
        class_2561 result = null;
        if (stack.method_57826(class_9334.field_50075) && (food = (class_4174)stack.method_57824(class_9334.field_50075)) != null && food.comp_2491() > 0) {
            result = ArmorStatusCachedComponents.FOOD_RESTORES[this.restoresLabelIndex++].get((double)food.comp_2491() / 2.0);
        }
        if (result == null && stack.method_7936() > 0) {
            result = ArmorStatusCachedComponents.DURABILITY[this.durabilityLabelIndex++].get(session.getDurabilityType(), stack.method_7936(), stack.method_7919());
        }
        if (result == null) {
            result = stack.method_7964();
        }
        if (includeCount) {
            result = ArmorStatusCachedComponents.LABEL_WITH_COUNT[this.labelCountLabelIndex++].get(result, stack.method_7947(), flipped);
        }
        return result;
    }

    private class_2561 getEnchantsLabel(class_9304 enchants, int enchantColor) {
        if (enchants == null) {
            return null;
        }
        int color = MinimapConfigConstants.COLORS[enchantColor];
        return ArmorStatusCachedComponents.ENCHANTS[this.enchantsLabelIndex++].get(enchants, color);
    }

    public class_2561 getArrowCountLabel(class_1799 used, class_746 player) {
        int count = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (!this.inventoryHelper.isArrows(stack)) continue;
            count += stack.method_7947();
        }
        class_1799 offhand = player.method_6118(class_1304.field_6171);
        if (this.inventoryHelper.isArrows(offhand)) {
            count += offhand.method_7947();
        }
        return ArmorStatusCachedComponents.ARROW_COUNT.get(used.method_7947(), count);
    }
}

