/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiChoosePreset;
import xaero.common.gui.GuiInstructions;
import xaero.hud.module.HudModule;
import xaero.hud.module.ModuleManager;
import xaero.hud.module.ModuleSession;
import xaero.hud.module.ModuleTransform;
import xaero.hud.preset.HudPreset;
import xaero.hud.pushbox.PushboxHandler;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.Tooltip;

public class GuiEditMode
extends ScreenBase {
    public static final Component CENTERED_COMPONENT = new TranslatableComponent("gui.xaero_centered");
    public static final Component FLIPPED_COMPONENT = new TranslatableComponent("gui.xaero_flipped");
    public static final Component TRUE_COMPONENT = new TranslatableComponent("gui.yes");
    public static final Component FALSE_COMPONENT = new TranslatableComponent("gui.no");
    public static final Component PRESS_C_COMPONENT = new TranslatableComponent("gui.xaero_press_c");
    public static final Component PRESS_F_COMPONENT = new TranslatableComponent("gui.xaero_press_f");
    public static final Component NOT_INGAME = new TranslatableComponent("gui.xaero_not_ingame");
    private final int NORMAL_COLOR = 1354612157;
    private final int HOVERED_COLOR = 0x64FFFFFF;
    private final int SELECTED_COLOR = -2097152001;
    private final boolean instructions;
    private final Component message;
    private HudModule<?> draggedModule;
    private HudModule<?> selectedModule;
    private HudModule<?> lastFrameHoveredModule;
    private int dragOffsetX;
    private int dragOffsetY;
    private final IXaeroMinimap modMain;

    public GuiEditMode(IXaeroMinimap modMain, Screen parent, Screen escape, boolean instructions, Component message) {
        super(parent, escape, (Component)new TranslatableComponent("gui.xaero_edit_mode"));
        this.modMain = modMain;
        this.instructions = instructions;
        this.message = message;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.draggedModule = null;
        this.selectedModule = null;
        this.m_142416_((GuiEventListener)new MySmallButton(200, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 143, (Component)new TranslatableComponent("gui.xaero_confirm"), b -> this.confirm()));
        this.m_142416_((GuiEventListener)new MySmallButton(202, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 143, (Component)new TranslatableComponent("gui.xaero_choose_a_preset"), b -> this.f_96541_.m_91152_((Screen)new GuiChoosePreset(this.modMain, (Screen)this, this.escape))));
        if (this.instructions) {
            this.m_142416_((GuiEventListener)new MySmallButton(201, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_cancel"), b -> this.cancel()));
            this.m_142416_((GuiEventListener)new MySmallButton(203, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_instructions"), b -> this.f_96541_.m_91152_((Screen)new GuiInstructions(this.modMain, (Screen)this, this.escape))));
            return;
        }
        this.m_142416_((GuiEventListener)new MySmallButton(201, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)new TranslatableComponent("gui.xaero_cancel"), b -> this.cancel()));
    }

    private void confirm() {
        for (HudPreset hudPreset : this.modMain.getHud().getPresetManager().getPresets()) {
            hudPreset.confirm();
        }
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> hudModule : manager.getModules()) {
            hudModule.confirmTransform();
        }
        try {
            this.modMain.getSettings().saveSettings();
        }
        catch (IOException iOException) {
            HudMod.LOGGER.error("suppressed exception", (Throwable)iOException);
        }
        this.f_96541_.m_91152_(this.parent);
    }

    private void cancel() {
        for (HudPreset preset : this.modMain.getHud().getPresetManager().getPresets()) {
            preset.cancel();
        }
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> module : manager.getModules()) {
            module.cancelTransform();
        }
        this.goBack();
    }

    private void applyPushes() {
        double screenScale = this.f_96541_.m_91268_().m_85449_();
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        for (HudModule<?> module : manager.getModules()) {
            Object session = module.getCurrentSession();
            if (!((ModuleSession)session).isActive()) continue;
            PushboxHandler.State pushState = module.getPushState();
            pushState.resetForModule((ModuleSession<?>)session, this.f_96543_, this.f_96544_, screenScale);
            this.modMain.getHudRenderer().getPushboxHandler().applyScreenEdges(pushState, this.f_96543_, this.f_96544_, screenScale);
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_.f_91074_ == null) {
            super.m_7333_(matrixStack);
            GuiEditMode.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)NOT_INGAME, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 6 + 128), (int)0xFFFFFF);
        } else {
            GuiEditMode.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.message, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 6 + 128), (int)0xFFFFFF);
        }
        if (XaeroMinimapSession.getCurrentSession() == null) {
            super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            return;
        }
        double screenScale = this.f_96541_.m_91268_().m_85449_();
        this.handleDraggedModule(mouseX, mouseY, screenScale);
        this.applyPushes();
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        this.lastFrameHoveredModule = this.getHoveredModule(mouseX, mouseY);
        HudModule<?> hoveredModule = this.lastFrameHoveredModule;
        for (HudModule<?> module : manager.getModules()) {
            if (!((ModuleSession)module.getCurrentSession()).isActive()) continue;
            this.renderModuleBox(module, hoveredModule, screenScale, matrixStack);
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (hoveredModule != null && this.draggedModule == null) {
            Tooltip tooltip = new Tooltip(this.getTooltipText(hoveredModule));
            tooltip.setStartWidth(150);
            matrixStack.m_85837_(0.0, 0.0, 1.0);
            tooltip.drawBox(matrixStack, mouseX, mouseY, this.f_96543_, this.f_96544_);
            matrixStack.m_85837_(0.0, 0.0, -1.0);
        }
    }

    private <MS extends ModuleSession<MS>> void renderModuleBox(HudModule<MS> module, HudModule<?> hoveredModule, double screenScale, PoseStack matrixStack) {
        MS session = module.getCurrentSession();
        int moduleW = ((ModuleSession)session).getWidth(screenScale);
        int moduleH = ((ModuleSession)session).getHeight(screenScale);
        boolean hovered = hoveredModule == module;
        PushboxHandler.State pushState = module.getPushState();
        int boxX = pushState.x;
        int boxY = pushState.y;
        GuiEditMode.m_93172_((PoseStack)matrixStack, (int)boxX, (int)boxY, (int)(boxX + moduleW), (int)(boxY + moduleH), (int)(this.selectedModule == module ? -2097152001 : (hovered ? 0x64FFFFFF : 1354612157)));
    }

    private HudModule<?> getHoveredModule(int mouseX, int mouseY) {
        ModuleManager manager = this.modMain.getHud().getModuleManager();
        HudModule<?> result = null;
        int resultSize = 0;
        for (HudModule<?> module : manager.getModules()) {
            if (!((ModuleSession)module.getCurrentSession()).isActive() || !this.isHovered(module, mouseX, mouseY)) continue;
            int moduleW = module.getPushState().w;
            int moduleH = module.getPushState().h;
            if (module != this.selectedModule && result != null && moduleW * moduleH > resultSize) continue;
            result = module;
            resultSize = moduleW * moduleH;
        }
        return result;
    }

    private boolean isHovered(HudModule<?> module, int mouseX, int mouseY) {
        PushboxHandler.State pushState = module.getPushState();
        int boxX = pushState.x;
        int boxY = pushState.y;
        return mouseX >= boxX && mouseX < boxX + pushState.w && mouseY >= boxY && mouseY < boxY + pushState.h;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clickResult = super.m_6375_(mouseX, mouseY, button);
        if (clickResult || XaeroMinimapSession.getCurrentSession() == null) {
            return true;
        }
        this.applyPushes();
        this.draggedModule = this.getHoveredModule((int)mouseX, (int)mouseY);
        this.selectedModule = this.draggedModule;
        if (this.draggedModule != null) {
            this.dragOffsetX = this.draggedModule.getPushState().x - (int)mouseX;
            this.dragOffsetY = this.draggedModule.getPushState().y - (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggedModule = null;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int code, int $$1, int $$2) {
        HudModule<?> affectedModule;
        HudModule<?> hudModule = affectedModule = this.selectedModule != null ? this.selectedModule : this.lastFrameHoveredModule;
        if (affectedModule != null && (code == 67 || code == 70 || code == 83)) {
            ModuleTransform transform = affectedModule.getUnconfirmedTransform();
            switch (code) {
                case 67: {
                    int oldModuleY = ((ModuleSession)affectedModule.getCurrentSession()).getEffectiveY(this.f_96544_, this.f_96541_.m_91268_().m_85449_());
                    boolean bl = transform.centered = !transform.centered;
                    if (this.draggedModule == null) break;
                    int newModuleY = ((ModuleSession)affectedModule.getCurrentSession()).getEffectiveY(this.f_96544_, this.f_96541_.m_91268_().m_85449_());
                    this.dragOffsetY += newModuleY - oldModuleY;
                    break;
                }
                case 70: {
                    boolean curFlippedHor = transform.flippedHor;
                    transform.flippedHor = !transform.flippedVer;
                    transform.flippedVer = curFlippedHor;
                    break;
                }
                case 83: {
                    Screen configScreen = affectedModule.getConfigScreenFactory().apply((Screen)this);
                    if (configScreen == null) break;
                    this.f_96541_.m_91152_(configScreen);
                }
            }
        }
        return super.m_7933_(code, $$1, $$2);
    }

    private void handleDraggedModule(int mouseX, int mouseY, double screenScale) {
        if (this.draggedModule == null) {
            return;
        }
        Object session = this.draggedModule.getCurrentSession();
        if (session == null) {
            return;
        }
        ModuleTransform transform = this.draggedModule.getUnconfirmedTransform();
        transform.y = mouseY + this.dragOffsetY;
        transform.fromBottom = false;
        int moduleH = ((ModuleSession)session).getHeight(screenScale);
        int yFromBottom = this.f_96544_ - transform.y - moduleH;
        if (transform.y > yFromBottom) {
            transform.fromBottom = true;
            transform.y = yFromBottom;
        }
        if (transform.centered) {
            return;
        }
        transform.x = mouseX + this.dragOffsetX;
        transform.fromRight = false;
        int moduleW = ((ModuleSession)session).getWidth(screenScale);
        int xFromRight = this.f_96543_ - transform.x - moduleW;
        if (transform.x > xFromRight) {
            transform.fromRight = true;
            transform.x = xFromRight;
        }
    }

    private Component getTooltipText(HudModule<?> hoveredModule) {
        ModuleTransform transform = hoveredModule.getUnconfirmedTransform();
        TranslatableComponent centeredLine = new TranslatableComponent("%s %s %s", new Object[]{CENTERED_COMPONENT, transform.centered ? TRUE_COMPONENT : FALSE_COMPONENT, PRESS_C_COMPONENT});
        TranslatableComponent flippedLine = new TranslatableComponent("%s %s %s %s", new Object[]{FLIPPED_COMPONENT, transform.flippedHor ? TRUE_COMPONENT : FALSE_COMPONENT, transform.flippedVer ? TRUE_COMPONENT : FALSE_COMPONENT, PRESS_F_COMPONENT});
        return new TranslatableComponent("%s \n %s \n %s", new Object[]{hoveredModule.getDisplayName(), centeredLine, flippedLine});
    }
}

