/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.MultiplayerScreen;
import net.minecraft.client.gui.screen.OptionsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.ToggleableKeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.action.ConnectingToRealmsAction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.misc.Misc;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModSettings;
import xaero.hud.HudSession;
import xaero.hud.controls.key.KeyMappingTickHandler;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.element.render.world.MinimapElementWorldRendererHandler;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointSession;

public class ClientEvents {
    public static final RenderGameOverlayEvent.ElementType[] OVERLAY_LAYERS = new RenderGameOverlayEvent.ElementType[]{RenderGameOverlayEvent.ElementType.ALL, RenderGameOverlayEvent.ElementType.HELMET, RenderGameOverlayEvent.ElementType.HOTBAR, RenderGameOverlayEvent.ElementType.CROSSHAIRS, RenderGameOverlayEvent.ElementType.BOSSHEALTH, RenderGameOverlayEvent.ElementType.TEXT, RenderGameOverlayEvent.ElementType.POTION_ICONS, RenderGameOverlayEvent.ElementType.SUBTITLES, RenderGameOverlayEvent.ElementType.CHAT};
    private final Vector4f REUSABLE_ZERO_VECTOR4 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
    private IXaeroMinimap modMain;
    private Screen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private boolean crosshairDisabledByThisMod = false;
    public RealmsServer latestRealm;

    public ClientEvents(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(GuiOpenEvent event) {
        if (!this.modMain.isFirstStageLoaded()) {
            return;
        }
        if (event.getGui() instanceof OptionsScreen) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setGui((Screen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        if (event.getGui() instanceof MainMenuScreen || event.getGui() instanceof MultiplayerScreen) {
            this.modMain.getSettings().resetServerSettings();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getGui() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                ConnectingToRealmsAction realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, "task", "field_19919", "Lnet/minecraft/class_4358;", "field_224248_l");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(ConnectingToRealmsAction.class, "server", "field_20224", "Lnet/minecraft/class_4877;", "field_238116_c_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getGui())) instanceof ConnectingToRealmsAction && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (ConnectingToRealmsAction)task)) != null && (this.latestRealm == null || realm.field_230582_a_ != this.latestRealm.field_230582_a_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        } else if ((event.getGui() instanceof GuiAddWaypoint || event.getGui() instanceof GuiWaypoints) && (mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS) || mc.field_71439_g.func_70644_a(Effects.NO_WAYPOINTS_HARMFUL))) {
            event.setGui(null);
        }
        this.lastGuiOpen = event.getGui();
    }

    protected void handleRenderModOverlayOverridable(MatrixStack matrixStack, float partialTicks) {
        MultiplyAnimationHelper.tick();
        MainWindow mainwindow = Minecraft.func_71410_x().func_228018_at_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null) {
            this.REUSABLE_ZERO_VECTOR4.func_229372_a_(matrixStack.func_227866_c_().func_227870_a_());
            float currentDepth = this.REUSABLE_ZERO_VECTOR4.func_195914_c();
            this.REUSABLE_ZERO_VECTOR4.func_195911_a(0.0f, 0.0f, 0.0f, 1.0f);
            matrixStack.func_227860_a_();
            matrixStack.func_227866_c_().func_227870_a_().func_226591_a_();
            matrixStack.func_227866_c_().func_227872_b_().func_226119_c_();
            matrixStack.func_227861_a_(0.0, 0.0, (double)currentDepth);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)-1.0);
            this.modMain.getHudRenderer().render(this.modMain.getHud(), matrixStack, partialTicks);
            this.modMain.getMinimap().getWaypointGuiRenderer().drawSetChange(minimapSession, matrixStack, Minecraft.func_71410_x().func_228018_at_());
            RenderSystem.popMatrix();
            matrixStack.func_227865_b_();
            if (ForgeIngameGui.renderCrosshairs && minimapSession.getProcessor().isEnlargedMap() && this.modMain.getSettings().centeredEnlarged) {
                ForgeIngameGui.renderCrosshairs = false;
                this.crosshairDisabledByThisMod = true;
            }
        }
    }

    public void handleRenderModOverlay(MatrixStack matrixStack, float partialTicks) {
        this.handleRenderModOverlayOverridable(matrixStack, partialTicks);
    }

    public void handleRenderGameOverlayEventPreAll(MatrixStack matrixStack, float partialTicks) {
        if (Minecraft.func_71410_x().field_71474_y.field_74319_N) {
            return;
        }
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null) {
            MainWindow mainwindow = Minecraft.func_71410_x().func_228018_at_();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)mainwindow.func_198109_k(), (double)mainwindow.func_198091_l(), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            Minecraft mc = Minecraft.func_71410_x();
            Vector3d renderPos = mc.field_71460_t.func_215316_n().func_216785_c();
            MinimapElementWorldRendererHandler worldRendererHandler = HudMod.INSTANCE.getMinimap().getWorldRendererHandler();
            worldRendererHandler.prepareRender(XaeroMinimapCore.waypointsProjection, XaeroMinimapCore.waypointModelView);
            worldRendererHandler.render(matrixStack, renderPos, partialTicks, null, mc.field_71441_e.func_230315_m_().func_242724_f(), (RegistryKey<World>)mc.field_71441_e.func_234923_W_());
            RenderSystem.matrixMode((int)5889);
            Misc.minecraftOrtho(Minecraft.func_71410_x(), false);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (!this.modMain.isLoadedClient()) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            XaeroMinimapCore.onRenderStatusEffectOverlayPost(event.getMatrixStack());
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            this.modMain.getHud().getEventHandler().handleRenderGameOverlayEventPost();
            if (this.crosshairDisabledByThisMod) {
                ForgeIngameGui.renderCrosshairs = true;
                this.crosshairDisabledByThisMod = false;
            }
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (e.getMessage().startsWith("xaero_waypoint_add:")) {
            String[] args = e.getMessage().split(":");
            e.setMessage("");
            WaypointSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession().getWaypointSession();
            minimapSession.getSharing().onWaypointAdd(args);
        } else if (e.getMessage().equals("/xaero_tp_anyway")) {
            e.setMessage("");
            WaypointSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession().getWaypointSession();
            minimapSession.getTeleport().teleportAnyway();
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getMessage() == null) {
            return;
        }
        ITextComponent text = e.getMessage();
        String textString = text.getString();
        if (textString.contains("xaero_waypoint:") || textString.contains("xaero-waypoint:")) {
            MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
            if (minimapSession == null) {
                return;
            }
            minimapSession.getWaypointSession().getSharing().onWaypointReceived(textString, e);
        } else {
            XaeroMinimapSession minimapSession;
            if (e.getType() == ChatType.SYSTEM && e.getSenderUUID().equals(Util.field_240973_b_) && textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(false);
                minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(false);
            }
            if (e.getType() == ChatType.SYSTEM && e.getSenderUUID().equals(Util.field_240973_b_) && textString.contains("\u00a7n\u00a7o\u00a7m\u00a7i\u00a7n\u00a7i\u00a7m\u00a7a\u00a7p")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                minimapSession.getMinimapProcessor().setNoMinimapMessageReceived(true);
            }
            if (e.getType() == ChatType.SYSTEM && e.getSenderUUID().equals(Util.field_240973_b_) && textString.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
                minimapSession = XaeroMinimapSession.getCurrentSession();
                minimapSession.getMinimapProcessor().setFairPlayOnlyMessageReceived(true);
            }
        }
    }

    @SubscribeEvent
    public void handleRenderWorldLastEvent(RenderWorldLastEvent event) {
        XaeroMinimapCore.onProjectionMatrix(event.getProjectionMatrix());
        XaeroMinimapCore.onWorldModelViewMatrix(event.getMatrixStack());
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon.needsNotification() && event.getGui() instanceof MainMenuScreen) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    public void handlePlayerSetSpawn(World world, BlockPos newSpawnPoint) {
        MinimapSession minimapSession;
        if (world instanceof ClientWorld && (minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession()) != null) {
            minimapSession.getWorldStateUpdater().setCurrentWorldSpawn(newSpawnPoint);
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        XaeroMinimapSession minimapSession;
        if (event.getWorld() instanceof ClientWorld && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.getRadarSession().update(null, null, null);
        }
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        XaeroMinimapSession minimapSession;
        if (event.phase == TickEvent.Phase.START && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.onClientTick();
            if (Minecraft.func_71410_x().field_71462_r == null) {
                minimapSession.getKeyMappingTickHandler().tick();
            }
            HudSession hudSession = HudSession.getCurrentSession();
            this.clientTickPostOverridable(hudSession);
        }
    }

    protected void clientTickPostOverridable(HudSession minimapSession) {
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (!this.modMain.isLoadedClient()) {
            return;
        }
        if (event.side == LogicalSide.CLIENT && event.player == Minecraft.func_71410_x().field_71439_g) {
            try {
                MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
                if (minimapSession != null && event.phase == TickEvent.Phase.START) {
                    MinimapProcessor minimap = minimapSession.getProcessor();
                    minimapSession.getWorldStateUpdater().update();
                    minimap.onPlayerTick();
                    Minecraft mc = Minecraft.func_71410_x();
                    HudSession hudSession = HudSession.getCurrentSession();
                    this.playerTickPostOverridable(hudSession);
                }
            }
            catch (Throwable t) {
                this.modMain.getInterfaces().getMinimapInterface().setCrashedWith(t);
            }
        }
    }

    protected void playerTickPostOverridable(HudSession hudSession) {
    }

    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
            if (!this.modMain.isLoadedClient()) {
                return;
            }
            this.modMain.getInterfaces().getMinimapInterface().checkCrashes();
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                MinimapProcessor minimap = minimapSession.getMinimapProcessor();
                minimap.getMinimapWriter().onRender();
            }
        }
    }

    protected void handleRenderGameOverlayEventPreOverridable(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == OVERLAY_LAYERS[this.modMain.getSettings().renderLayerIndex]) {
            this.handleRenderModOverlay(event.getMatrixStack(), event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (!this.modMain.isLoadedClient()) {
            return;
        }
        this.handleRenderGameOverlayEventPreOverridable(event);
    }

    public boolean handleForceToggleKeyMapping(ToggleableKeyBinding keyMapping) {
        if (KeyMappingTickHandler.DISABLE_KEY_MAPPING_OVERRIDES) {
            return false;
        }
        return this.handleForceToggleKeyMappingOverridable(keyMapping);
    }

    public boolean handleForceToggleKeyMappingOverridable(ToggleableKeyBinding keyMapping) {
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleBossHealthRender(RenderGameOverlayEvent.BossInfo event) {
        XaeroMinimapCore.onBossHealthRender(event.getY() + event.getIncrement());
    }
}

