/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyConflictContext;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.gui.dropdown.IDropDownWidgetCallback;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.path.XaeroPath;

public class GuiWaypoints
extends ScreenBase
implements IDropDownWidgetCallback {
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    public static double distanceDivided;
    private List list;
    private MinimapWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private DropDownWidget containersDD;
    private DropDownWidget worldsDD;
    private DropDownWidget setsDD;
    private MinimapSession session;
    private MinimapWorldManager manager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;
    private ArrayList<Waypoint> waypointsSorted;
    private final XaeroPath frozenAutoWorldPath;

    @Deprecated
    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen) {
        this(modMain, minimapSession, par1GuiScreen, null);
    }

    @Deprecated
    public GuiWaypoints(IXaeroMinimap modMain, XaeroMinimapSession minimapSession, Screen par1GuiScreen, Screen escapeScreen) {
        this((HudMod)modMain, BuiltInHudModules.MINIMAP.getCurrentSession(), par1GuiScreen, escapeScreen);
    }

    public GuiWaypoints(HudMod modMain, MinimapSession session, Screen par1GuiScreen, Screen escapeScreen) {
        super(modMain, par1GuiScreen, escapeScreen, (ITextComponent)new TranslationTextComponent("gui.xaero_waypoints"));
        this.session = session;
        this.manager = session.getWorldManager();
        this.selectedListSet = new ConcurrentSkipListSet();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.frozenAutoWorldPath = session.getWorldState().getAutoWorldPath();
        this.displayedWorld = this.manager.getCurrentWorld(this.frozenAutoWorldPath);
        XaeroPath currentContainer = this.displayedWorld.getContainer().getRoot().getPath();
        this.containers = new GuiWaypointContainers(modMain, this.manager, currentContainer, this.frozenAutoWorldPath);
        this.worlds = new GuiWaypointWorlds(this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()), session, this.displayedWorld.getFullPath(), this.frozenAutoWorldPath);
        this.displayingTeleportableWorld = session.getWaypointSession().getTeleport().isWorldTeleportable(this.displayedWorld);
        this.waypointsSorted = new ArrayList();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.updateSortedList();
        this.list = new List();
        this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrentWaypointSetId());
        this.field_230705_e_.add(this.list);
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 129, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_delete"), b -> {
            Waypoint w;
            if (!this.isSomethingSelected()) {
                return;
            }
            this.undrag();
            boolean shouldRestore = true;
            for (int i : this.selectedListSet) {
                w = this.list.getWaypoint(i);
                if (w.isTemporary()) continue;
                shouldRestore = false;
                w.setTemporary(true);
            }
            if (shouldRestore) {
                for (int i : this.selectedListSet) {
                    w = this.list.getWaypoint(i);
                    w.setTemporary(false);
                }
            }
            try {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 29, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done", new Object[0]), b -> this.goBack()));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 203, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_add_edit", new Object[0]), b -> {
            if (!this.isAddEditEnabled()) {
                return;
            }
            ArrayList selectedWaypoints = this.getSelectedWaypointsList().stream().filter(w -> !w.isServerWaypoint()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            this.field_230706_i_.func_147108_a((Screen)new GuiAddWaypoint((HudMod)this.modMain, this.session, (Screen)this, this.escape, (ArrayList<Waypoint>)selectedWaypoints, this.displayedWorld.getContainer().getRoot().getPath(), this.displayedWorld, this.displayedWorld.getCurrentWaypointSetId(), selectedWaypoints.isEmpty()));
            this.list.setSelected(null);
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 120, this.field_230709_l_ - 53, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)"), b -> {
            if (!this.canTeleport()) {
                return;
            }
            this.displayingTeleportableWorld = this.session.getWaypointSession().getTeleport().isWorldTeleportable(this.displayedWorld);
            this.session.getWaypointSession().getTeleport().teleportToWaypoint(this.list.getWaypoint(this.selectedListSet.first()), this.displayedWorld, this);
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 46, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_disable_enable", new Object[0]), b -> {
            if (!this.isSomethingSelected()) {
                return;
            }
            ArrayList<Waypoint> selectedWaypoints = this.getSelectedWaypointsList();
            if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isTemporary)) {
                for (Waypoint selected : selectedWaypoints) {
                    this.displayedWorld.getCurrentWaypointSet().remove(selected);
                }
                this.selectedListSet.clear();
            } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isDisabled)) {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(false);
                }
            } else {
                for (Waypoint selected : selectedWaypoints) {
                    selected.setDisabled(true);
                }
            }
            this.updateSortedList();
            try {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 + 130, 32, (ITextComponent)new TranslationTextComponent("gui.xaero_clear", new Object[0]), b -> {
            XaeroPath worldKeys = (XaeroPath)this.worlds.getCurrentKey();
            String name = this.sets.getOptions()[this.sets.getCurrentSet()];
            if (this.shouldDeleteSet()) {
                this.field_230706_i_.func_147108_a((Screen)new GuiDeleteSet(I18n.func_135052_a((String)name, (Object[])new Object[0]), worldKeys, name, this, this.escape, this.modMain, this.session));
            } else {
                this.field_230706_i_.func_147108_a((Screen)new GuiClearSet(I18n.func_135052_a((String)name, (Object[])new Object[0]), worldKeys, name, this, this.escape, this.modMain, this.session));
            }
        }));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 203, 32, (ITextComponent)new TranslationTextComponent("gui.xaero_options", new Object[0]), b -> this.field_230706_i_.func_147108_a((Screen)new GuiWaypointsOptions(this.modMain, this.session, this, this.escape, this.displayedWorld, this.frozenAutoWorldPath))));
        this.func_230480_a_((Widget)new MyTinyButton(this.field_230708_k_ / 2 - 37, this.field_230709_l_ - 53, (ITextComponent)new TranslationTextComponent("gui.xaero_share", new Object[0]), b -> {
            Waypoint selected;
            if (!this.isOneSelected()) {
                return;
            }
            Waypoint waypoint = selected = this.selectedListSet.isEmpty() ? null : this.list.getWaypoint(this.selectedListSet.first());
            if (selected != null) {
                this.session.getWaypointSession().getSharing().shareWaypoint(this, selected, this.displayedWorld);
            }
        }));
        this.containersDD = this.createContainersDropdown();
        this.func_230481_d_(this.containersDD);
        this.worldsDD = this.createWorldsDropdown();
        this.func_230481_d_(this.worldsDD);
        this.setsDD = this.createSetsDropdown();
        this.func_230481_d_(this.setsDD);
    }

    private DropDownWidget createSetsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.sets.getOptions()).setX(this.field_230708_k_ / 2 - 100).setY(33).setW(200).setSelected(this.sets.getCurrentSet()).setCallback(this).setContainer(this).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_waypoint_set")).build();
    }

    private DropDownWidget createContainersDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.containers.options).setX(this.field_230708_k_ / 2 - 202).setY(17).setW(200).setSelected(this.containers.current).setCallback(this).setContainer(this).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_waypoint_container")).build();
    }

    private DropDownWidget createWorldsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.worlds.options).setX(this.field_230708_k_ / 2 + 2).setY(17).setW(200).setSelected(this.worlds.current).setCallback(this).setContainer(this).setNarrationTitle((ITextComponent)new TranslationTextComponent("gui.xaero_dropdown_waypoint_world")).build();
    }

    private ArrayList<Waypoint> getSelectedWaypointsList() {
        return this.selectedListSet.stream().map(i -> this.list.getWaypoint(i)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, Predicate<Waypoint> predicate) {
        boolean allTrue = true;
        for (Waypoint w : waypoints) {
            if (predicate.test(w)) continue;
            allTrue = false;
            break;
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentWaypointSet().isEmpty();
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    @Override
    public boolean func_231044_a_(double par1, double par2, int par3) {
        if (this.openDropdown == null) {
            if (Misc.inputMatchesKeyBinding(InputMappings.Type.MOUSE, par3, ModSettings.keyWaypoints, KeyConflictContext.GUI)) {
                this.goBack();
                return true;
            }
            if (par3 == 0) {
                if (par2 >= 58.0 && par2 < (double)(this.field_230709_l_ - 61) && this.displayedWorld.getRootConfig().getSortType() == WaypointsSort.NONE) {
                    this.draggingFromX = (int)par1;
                    this.draggingFromY = (int)par2;
                    this.draggingFromSlot = this.list.getEntryAt(par1, par2);
                    if (this.draggingFromSlot >= this.displayedWorld.getCurrentWaypointSet().size()) {
                        this.draggingFromSlot = -1;
                    }
                }
            } else {
                this.list.setSelected(null);
            }
        }
        return super.func_231044_a_(par1, par2, par3);
    }

    @Override
    public boolean func_231048_c_(double par1, double par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.undrag();
        if (!super.func_231048_c_(par1, par2, par3)) {
            return this.list.func_231048_c_(par1, par2, par3);
        }
        return true;
    }

    public boolean func_223281_a_(int par1, int par2, int par3) {
        switch (par1) {
            case 261: {
                if (((Widget)this.field_230710_m_.get((int)4)).field_230693_o_) {
                    for (int i : this.selectedListSet) {
                        this.list.getWaypoint(i).setTemporary(true);
                    }
                    ((Widget)this.field_230710_m_.get(4)).func_230982_a_(0.0, 0.0);
                }
                return true;
            }
            case 84: {
                if (((Widget)this.field_230710_m_.get((int)3)).field_230693_o_) {
                    ((Widget)this.field_230710_m_.get(3)).func_230982_a_(0.0, 0.0);
                }
                return true;
            }
        }
        return super.func_223281_a_(par1, par2, par3);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        if (this.field_230706_i_.field_71439_g == null) {
            this.field_230706_i_.func_147108_a(null);
            return;
        }
        this.field_230706_i_.field_71456_v.func_230926_e_(0);
        this.updateButtons();
        this.list.func_230430_a_(matrixStack, par1, par2, par3);
        super.func_230430_a_(matrixStack, par1, par2, par3);
    }

    @Override
    protected void renderPreDropdown(MatrixStack poseStack, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        AbstractGui.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_world_server", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 - 102), (int)5, (int)0xFFFFFF);
        AbstractGui.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 102), (int)5, (int)0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(mouseX - this.draggingFromX, 2.0) + Math.pow(mouseY - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentWaypointSet().size() - 1, this.list.getEntryAt(mouseX, mouseY));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentWaypointSet().get(this.draggingFromSlot);
                this.list.setSelected(null);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentWaypointSet().set(i, this.displayedWorld.getCurrentWaypointSet().get(i + direction));
                }
                this.displayedWorld.getCurrentWaypointSet().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
                this.updateSortedList();
            }
            int fromCenter = this.draggingFromX - this.list.getWidth() / 2;
            this.list.drawWaypointSlot(poseStack, this.draggingWaypoint, mouseX - 108 - fromCenter, mouseY - this.list.getItemHeight() / 4);
        }
    }

    private void updateButtons() {
        ((Button)this.field_230710_m_.get((int)0)).field_230693_o_ = ((Button)this.field_230710_m_.get((int)4)).field_230693_o_ = this.isSomethingSelected();
        ((Button)this.field_230710_m_.get((int)7)).field_230693_o_ = this.isOneSelected();
        ((Button)this.field_230710_m_.get((int)3)).field_230693_o_ = this.canTeleport();
        ((Button)this.field_230710_m_.get((int)2)).field_230693_o_ = this.isAddEditEnabled();
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        ((Button)this.field_230710_m_.get(5)).func_238482_a_((ITextComponent)new TranslationTextComponent(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear", new Object[0]));
        if (this.isSomethingSelected() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isTemporary)) {
            ((Button)this.field_230710_m_.get(4)).func_238482_a_((ITextComponent)new TranslationTextComponent("gui.xaero_delete"));
            ((Button)this.field_230710_m_.get(0)).func_238482_a_((ITextComponent)new TranslationTextComponent("gui.xaero_restore"));
        } else {
            ((Button)this.field_230710_m_.get(0)).func_238482_a_((ITextComponent)new TranslationTextComponent("gui.xaero_delete"));
            String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            ((Button)this.field_230710_m_.get(4)).func_238482_a_((ITextComponent)new StringTextComponent(enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isDisabled) ? 0 : 1]));
        }
    }

    private boolean isAddEditEnabled() {
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        return selectedWaypointsList.isEmpty() || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isServerWaypoint);
    }

    private boolean isSomethingSelected() {
        return !this.selectedListSet.isEmpty();
    }

    private boolean isOneSelected() {
        return this.selectedListSet.size() == 1;
    }

    private boolean canTeleport() {
        return this.isOneSelected() && (this.modMain.getSettings().allowWrongWorldTeleportation || this.displayingTeleportableWorld) && this.displayedWorld.getRootConfig().isTeleportationEnabled();
    }

    @Override
    public boolean onSelected(DropDownWidget menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()).getFirstWorld();
                    this.session.getWorldState().setCustomWorldPath(firstWorld.getFullPath());
                } else {
                    this.session.getWorldState().setCustomWorldPath(null);
                }
                this.displayedWorld = this.manager.getCurrentWorld(this.frozenAutoWorldPath);
                this.updateSortedList();
                this.worlds = new GuiWaypointWorlds(this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()), this.session, this.displayedWorld.getFullPath(), this.frozenAutoWorldPath);
                this.worldsDD = this.createWorldsDropdown();
                this.replaceWidget(this.worldsDD, this.worldsDD);
            } else {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    XaeroPath selectedWorldPath = (XaeroPath)this.worlds.getCurrentKey();
                    this.session.getWorldState().setCustomWorldPath(selectedWorldPath);
                } else {
                    this.session.getWorldState().setCustomWorldPath(null);
                }
                this.displayedWorld = this.manager.getCurrentWorld(this.frozenAutoWorldPath);
                this.updateSortedList();
            }
            this.displayingTeleportableWorld = this.session.getWaypointSession().getTeleport().isWorldTeleportable(this.displayedWorld);
            this.list.setSelected(null);
            this.sets = new GuiWaypointSets(true, this.displayedWorld, this.displayedWorld.getCurrentWaypointSetId());
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget(this.setsDD, this.setsDD);
            return true;
        }
        if (menu == this.setsDD) {
            this.list.setSelected(null);
            if (selectedIndex == menu.size() - 1) {
                MinimapLogs.LOGGER.info("New waypoint set gui");
                this.field_230706_i_.func_147108_a((Screen)new GuiNewSet(this.modMain, this.session, (Screen)this, this.escape, this.displayedWorld));
                return false;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrentWaypointSetId(this.sets.getCurrentSetKey());
            this.updateSortedList();
            try {
                this.session.getWorldManagerIO().saveWorld(this.displayedWorld);
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getRootConfig().getSortType();
        this.waypointsSorted = new ArrayList();
        if (sortType == WaypointsSort.NONE) {
            for (Waypoint waypoint : this.displayedWorld.getCurrentWaypointSet().getWaypoints()) {
                this.waypointsSorted.add(waypoint);
            }
            return;
        }
        distanceDivided = this.session.getDimensionHelper().getDimensionDivision(this.displayedWorld);
        ArrayList<KeySortableByOther<Waypoint>> sortableKeys = new ArrayList<KeySortableByOther<Waypoint>>();
        ActiveRenderInfo camera = this.field_230706_i_.field_71460_t.func_215316_n();
        for (Waypoint waypoint : this.displayedWorld.getCurrentWaypointSet().getWaypoints()) {
            sortableKeys.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{sortType == WaypointsSort.COLOR ? waypoint.getWaypointColor() : (sortType == WaypointsSort.ANGLE ? Double.valueOf(-waypoint.getComparisonAngleCos(camera, distanceDivided)) : (sortType == WaypointsSort.NAME ? waypoint.getComparisonName() : (sortType == WaypointsSort.SYMBOL ? waypoint.getInitials() : Double.valueOf(waypoint.getComparisonDistance(camera, distanceDivided)))))}));
        }
        Collections.sort(sortableKeys);
        for (KeySortableByOther keySortableByOther : sortableKeys) {
            this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
        }
        if (this.displayedWorld.getRootConfig().isSortReversed()) {
            Collections.reverse(this.waypointsSorted);
        }
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        if (!super.func_231046_a_(par1, par2, par3)) {
            if (Misc.inputMatchesKeyBinding(par1 != -1 ? InputMappings.Type.KEYSYM : InputMappings.Type.SCANCODE, par1 != -1 ? par1 : par2, ModSettings.keyWaypoints, KeyConflictContext.GUI)) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    class List
    extends ExtendedList<WaypointEntry> {
        private int createdCount;

        public List() {
            super(GuiWaypoints.this.field_230706_i_, GuiWaypoints.this.field_230708_k_, GuiWaypoints.this.field_230709_l_, 58, Math.max(62, GuiWaypoints.this.field_230709_l_ - 61), 18);
            this.createEntries(this.getWaypointCount());
        }

        protected int getWaypointCount() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentWaypointSet().size();
            return size += GuiWaypoints.this.displayedWorld.getContainer().getServerWaypointManager().size();
        }

        private Waypoint getWaypoint(int slotIndex) {
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentWaypointSet().size()) {
                return (Waypoint)GuiWaypoints.this.waypointsSorted.get(slotIndex);
            }
            int serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentWaypointSet().size();
            if (serverWPIndex < GuiWaypoints.this.displayedWorld.getContainer().getServerWaypointManager().size()) {
                return GuiWaypoints.this.displayedWorld.getContainer().getServerWaypointManager().getBySlot(serverWPIndex);
            }
            return null;
        }

        protected boolean func_230957_f_(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        protected void func_230433_a_(MatrixStack matrixStack) {
            GuiWaypoints.this.func_230446_a_(matrixStack);
        }

        private void createEntries(int count) {
            this.func_230963_j_();
            this.createdCount = count;
            for (int i = 0; i < count; ++i) {
                WaypointEntry entry = new WaypointEntry(i);
                this.func_230513_b_((AbstractList.AbstractListEntry)entry);
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
            int currentCount = this.getWaypointCount();
            if (currentCount != this.createdCount) {
                this.createEntries(currentCount);
                this.func_230932_a_(this.func_230966_l_());
            }
            super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        }

        public boolean func_230971_aw__() {
            if (GuiWaypoints.this.openDropdown != null || GuiWaypoints.this.draggingWaypoint != null) {
                return false;
            }
            return super.func_230971_aw__();
        }

        public void setSelected(WaypointEntry e) {
            if (e == null) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            Waypoint waypoint = this.getWaypoint(e.index);
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = Screen.func_231173_s_();
            if ((currentSize > 1 || currentSize == 1 && (Integer)GuiWaypoints.this.selectedListSet.first() != e.index) && !Screen.func_231172_r_() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = e.index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != e.index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(e.index)) {
                GuiWaypoints.this.selectedListSet.remove(e.index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = e.index;
                GuiWaypoints.this.selectedListSet.add(e.index);
            }
            String narration = "";
            if (waypoint != null) {
                narration = narration + I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{waypoint.getName()}) + (waypoint.isDisabled() ? " " + I18n.func_135052_a((String)"gui.xaero_disabled", (Object[])new Object[0]) : "") + (waypoint.isTemporary() ? " " + I18n.func_135052_a((String)"gui.xaero_temporary", (Object[])new Object[0]) : "") + ", ";
            }
            if (GuiWaypoints.this.selectedListSet.size() != 1) {
                narration = narration + I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{I18n.func_135052_a((String)"gui.xaero_waypoints", (Object[])new Object[0]) + " " + GuiWaypoints.this.selectedListSet.size()});
            }
            NarratorChatListener.field_193643_a.func_216864_a(narration);
            super.func_241215_a_((AbstractList.AbstractListEntry)(GuiWaypoints.this.selectedListSet.isEmpty() ? null : e));
        }

        public int getItemHeight() {
            return this.field_230669_c_;
        }

        public void drawWaypointSlot(MatrixStack matrixStack, Waypoint w, int p_180791_2_, int p_180791_3_) {
            if (w == null) {
                return;
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
            AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)GuiWaypoints.this.field_230712_o_, (String)(w.getLocalizedName() + (w.isDisabled() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_temporary", (Object[])new Object[0]) : ""))), (int)(p_180791_2_ + 110), (int)(p_180791_3_ + 1), (int)0xFFFFFF);
            int rectX = p_180791_2_ + 8 + 4;
            int rectY = p_180791_3_ + 6;
            if (w.isGlobal()) {
                AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)GuiWaypoints.this.field_230712_o_, (String)"*", (int)(rectX - 25), (int)(rectY - 3), (int)0xFFFFFF);
            }
            int opacity = 90;
            IRenderTypeBuffer.Impl renderTypeBuffers = GuiWaypoints.this.modMain.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
            GuiWaypoints.this.modMain.getMinimap().getWaypointGuiRenderer().drawIconOnGUI(matrixStack, GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper(), w, rectX, rectY, opacity, renderTypeBuffers, renderTypeBuffers.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS), renderTypeBuffers.getBuffer(CustomRenderTypes.GUI_NEAREST));
            renderTypeBuffers.func_228461_a_();
            matrixStack.func_227865_b_();
        }

        public int getEntryAt(double x, double y) {
            WaypointEntry entry = (WaypointEntry)this.func_230933_a_(x, y);
            return entry == null ? -1 : entry.index;
        }

        @OnlyIn(value=Dist.CLIENT)
        public class WaypointEntry
        extends ExtendedList.AbstractListEntry<WaypointEntry> {
            private int index;

            public WaypointEntry(int index) {
                this.index = index;
            }

            public void func_230432_a_(MatrixStack matrixStack, int index, int p_render_2_, int p_render_3_, int p_render_4_, int p_render_5_, int p_render_6_, int p_render_7_, boolean p_render_8_, float p_render_9_) {
                Waypoint w = List.this.getWaypoint(index);
                if (w == GuiWaypoints.this.draggingWaypoint) {
                    return;
                }
                List.this.drawWaypointSlot(matrixStack, w, p_render_3_, p_render_2_);
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                if (p_mouseClicked_5_ == 0) {
                    List.this.setSelected(this);
                    return true;
                }
                return false;
            }
        }
    }
}

