/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ScreenBase;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.EditorCategoryNodeConverter;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntry;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.EditorSettingsNode;

public abstract class GuiCategoryEditor<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>>
extends ScreenBase {
    private static final int FRAME_TOP_SIZE = 32;
    private static final int FRAME_BOTTOM_SIZE = 48;
    public static final int ROW_HEIGHT = 24;
    public static final int ROW_WIDTH = 220;
    private SettingRowList rowList;
    private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;
    private ED editorData;
    protected ED cutCategory;
    protected ED cutCategorySuper;

    protected GuiCategoryEditor(IXaeroMinimap modMain, Screen parent, Screen escape, ITextComponent title, EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
        super(modMain, parent, escape, title);
        this.dataConverter = dataConverter;
        this.editorData = this.constructEditorData(dataConverter);
    }

    protected abstract ED constructEditorData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract ED constructDefaultData(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> var1);

    protected abstract void onConfigConfirmed(C var1);

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ - 32, 150, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_cancel", new Object[0]), b -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
            if (result) {
                super.onExit(this.parent);
            } else {
                this.field_230706_i_.func_147108_a((Screen)this);
            }
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_cancel_confirm"), (ITextComponent)new StringTextComponent("")))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 155, this.field_230709_l_ - 32, 150, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_confirm"), b -> this.confirm()));
        this.func_230480_a_((Widget)new Button(6, 6, 120, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset"), b -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.editorData = this.constructDefaultData(this.dataConverter);
            }
            this.field_230706_i_.func_147108_a((Screen)this);
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset_confirm1"), (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_reset_confirm2")))));
        this.rowList = new SettingRowList(this.dataConverter);
        this.field_230705_e_.add(this.rowList);
    }

    private void confirm() {
        this.onConfigConfirmed(((ObjectCategory.Builder)this.dataConverter.getConfiguredBuilder(this.editorData)).build());
        super.onExit(this.parent);
    }

    @Override
    protected void onExit(Screen screen) {
        this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(result -> {
            if (result) {
                this.confirm();
            }
            super.onExit(screen);
        }, (ITextComponent)new TranslationTextComponent("gui.xaero_category_settings_save_confirm"), (ITextComponent)new StringTextComponent("")){

            public boolean func_231046_a_(int i, int j, int k) {
                if (i == 256) {
                    return true;
                }
                return super.func_231046_a_(i, j, k);
            }
        });
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.rowList.func_230430_a_(poseStack, i, j, f);
        GuiCategoryEditor.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        super.func_230430_a_(poseStack, i, j, f);
        if (this.rowList.hovered == null) {
            return;
        }
        Supplier<CursorBox> tooltipSupplier = this.rowList.hovered.getTooltipSupplier();
        if (tooltipSupplier == null) {
            return;
        }
        CursorBox tooltip = tooltipSupplier.get();
        if (tooltip == null) {
            return;
        }
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, 0.0, 0.1);
        tooltip.drawBox(poseStack, i, j, this.field_230708_k_, this.field_230709_l_);
        poseStack.func_227865_b_();
    }

    public boolean func_231046_a_(int i, int j, int k) {
        if (this.rowList.func_230971_aw__() && i == 257 && this.rowList.confirmSelection()) {
            return true;
        }
        return super.func_231046_a_(i, j, k);
    }

    public void func_231023_e_() {
        this.rowList.tick();
        super.func_231023_e_();
    }

    public void func_231035_a_(IGuiEventListener guiEventListener) {
        super.func_231035_a_(guiEventListener);
        if (guiEventListener != null && guiEventListener == this.rowList) {
            this.rowList.narrateSelection();
        }
    }

    public SettingRowList getRowList() {
        return this.rowList;
    }

    @Override
    public boolean func_231044_a_(double d, double e, int i) {
        if (super.func_231044_a_(d, e, i)) {
            return true;
        }
        return this.rowList.func_231044_a_(d, e, i);
    }

    @Override
    public boolean func_231048_c_(double d, double e, int i) {
        if (super.func_231048_c_(d, e, i)) {
            return true;
        }
        return this.rowList.func_231048_c_(d, e, i);
    }

    public boolean func_231045_a_(double d, double e, int i, double f, double g) {
        if (super.func_231045_a_(d, e, i, f, g)) {
            return true;
        }
        return this.rowList.func_231045_a_(d, e, i, f, g);
    }

    @Override
    public boolean func_231043_a_(double d, double e, double f) {
        if (super.func_231043_a_(d, e, f)) {
            return true;
        }
        return this.rowList.func_231043_a_(d, e, f);
    }

    public class SettingRowList
    extends ExtendedList<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
        private EditorNode lastExpandedData;
        private boolean restoreScrollAfterUpdate;
        private EditorListEntry hovered;
        private final EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter;

        public SettingRowList(EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> dataConverter) {
            super(GuiCategoryEditor.this.field_230706_i_, GuiCategoryEditor.this.field_230708_k_, GuiCategoryEditor.this.field_230709_l_, 32, Math.max(36, GuiCategoryEditor.this.field_230709_l_ - 48), 24);
            this.dataConverter = dataConverter;
            this.updateEntries();
            this.func_230943_a_(false);
        }

        public boolean hasCut() {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return false;
            }
            if (((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().contains(GuiCategoryEditor.this.cutCategory)) {
                return true;
            }
            this.setCutCategory(null, null);
            return false;
        }

        public ED getCut() {
            return GuiCategoryEditor.this.cutCategory;
        }

        public boolean isCut(ED category) {
            if (GuiCategoryEditor.this.cutCategory == category) {
                return this.hasCut();
            }
            return false;
        }

        public void setCutCategory(ED cutCategory, ED cutCategorySuper) {
            GuiCategoryEditor.this.cutCategory = cutCategory;
            GuiCategoryEditor.this.cutCategorySuper = cutCategorySuper;
        }

        public void pasteTo(ED destination) {
            if (GuiCategoryEditor.this.cutCategory == null) {
                return;
            }
            if (destination == GuiCategoryEditor.this.cutCategory || destination == GuiCategoryEditor.this.cutCategorySuper) {
                this.setCutCategory(null, null);
                this.updateEntries();
                return;
            }
            ((EditorNode)destination).getExpandAction(this).run();
            this.setLastExpandedData((EditorNode)GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)GuiCategoryEditor.this.cutCategorySuper).getSubCategories().remove(GuiCategoryEditor.this.cutCategory);
            ((EditorCategoryNode)destination).getSubCategories().add(0, GuiCategoryEditor.this.cutCategory);
            this.setCutCategory(null, null);
        }

        public boolean func_230971_aw__() {
            return GuiCategoryEditor.this.func_241217_q_() == this;
        }

        public void setLastExpandedData(EditorNode lastExpandedData) {
            this.lastExpandedData = lastExpandedData;
        }

        public void restoreScrollAfterUpdate() {
            this.restoreScrollAfterUpdate = true;
        }

        public void updateEntries() {
            double scrollBackup = this.func_230966_l_();
            this.func_230963_j_();
            GuiCategoryEditor.this.editorData.setExpanded(true);
            this.addEntriesForExpanded(GuiCategoryEditor.this.editorData, null);
            if (this.func_230958_g_() != null) {
                this.func_230951_c_(this.func_230958_g_());
            }
            if (this.restoreScrollAfterUpdate) {
                this.func_230932_a_(scrollBackup);
                this.restoreScrollAfterUpdate = false;
            }
        }

        private void addEntriesForExpanded(EditorNode data, EditorNode parent) {
            int nextIndex = this.func_231039_at__().size();
            List<EditorNode> subExpandables = data.getSubNodes();
            if (subExpandables == null) {
                return;
            }
            EditorNode expandedData = null;
            for (EditorNode sed : subExpandables) {
                if (!sed.isExpanded()) continue;
                expandedData = sed;
                break;
            }
            EditorListRootEntry wrappedEntry = data.getListEntryFactory().get(data, parent, nextIndex, nextIndex == 0 ? ConnectionLineType.NONE : ConnectionLineType.PATH, this, this.field_230670_d_, expandedData == null);
            Entry currentEntry = new Entry(wrappedEntry, nextIndex++);
            this.func_230513_b_((AbstractList.AbstractListEntry)currentEntry);
            if (data == this.lastExpandedData) {
                this.setSelected(currentEntry);
            }
            if (expandedData != null) {
                this.addEntriesForExpanded(expandedData, data);
                return;
            }
            if (this.lastExpandedData == null && data.isExpanded()) {
                this.setSelected(currentEntry);
            }
            boolean first = true;
            for (EditorNode sed : subExpandables) {
                wrappedEntry = sed.getListEntryFactory().get(sed, data, nextIndex, first ? ConnectionLineType.HEAD_LEAF : ConnectionLineType.TAIL_LEAF, this, this.field_230670_d_, false);
                Entry leafEntry = new Entry(wrappedEntry, nextIndex++);
                this.func_230513_b_((AbstractList.AbstractListEntry)leafEntry);
                if (sed == this.lastExpandedData) {
                    this.setSelected(leafEntry);
                }
                first = false;
            }
        }

        public boolean func_231044_a_(double d, double e, int i) {
            if (!this.func_231047_b_(d, e)) {
                this.setSelected(null);
            }
            return super.func_231044_a_(d, e, i);
        }

        public void func_212927_b(double d, double e) {
            if (this.func_230958_g_() != null) {
                ((Entry)this.func_230958_g_()).func_212927_b(d, e);
            }
            super.func_212927_b(d, e);
        }

        public boolean func_223281_a_(int i, int j, int k) {
            if (this.func_230958_g_() != null && ((Entry)this.func_230958_g_()).func_223281_a_(i, j, k)) {
                return true;
            }
            return super.func_223281_a_(i, j, k);
        }

        public boolean func_231042_a_(char c, int i) {
            boolean result;
            if (this.func_230958_g_() != null && (result = ((Entry)this.func_230958_g_()).func_231042_a_(c, i))) {
                return true;
            }
            return super.func_231042_a_(c, i);
        }

        public void tick() {
            if (this.func_230958_g_() != null) {
                ((Entry)this.func_230958_g_()).tick();
            }
        }

        public boolean confirmSelection() {
            Entry entry = (Entry)this.func_230958_g_();
            if (entry == null) {
                return false;
            }
            EditorListEntry selectedSubEntry = entry.wrappedEntry.confirmSelection();
            return selectedSubEntry != null;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public void setSelected(Entry entry) {
            if (this.func_230958_g_() != null) {
                ((Entry)this.func_230958_g_()).wrappedEntry.unfocusRecursively();
            }
            if (this.func_241217_q_() != null) {
                ((Entry)this.func_241217_q_()).func_231049_c__(false);
            }
            if (entry != null) {
                entry.wrappedEntry.focusFirstRecursively();
            }
            super.func_241215_a_((AbstractList.AbstractListEntry)entry);
            super.func_231035_a_((IGuiEventListener)entry);
            this.narrateSelection();
        }

        public void func_231035_a_(IGuiEventListener guiEventListener) {
        }

        public int func_230949_c_() {
            return this.field_230670_d_;
        }

        protected int func_230952_d_() {
            return this.field_230670_d_ / 2 + 164;
        }

        public void narrateSelection() {
            if (!this.func_230971_aw__()) {
                return;
            }
            Entry entry = (Entry)this.func_230958_g_();
            if (entry == null) {
                return;
            }
            String selectedNarrationString = entry.wrappedEntry.getSelectedNarration();
            if (selectedNarrationString == null || selectedNarrationString.isEmpty()) {
                return;
            }
            String narration = entry == null ? I18n.func_135052_a((String)"gui.xaero_narrator_select_nothing", (Object[])new Object[0]) : selectedNarrationString;
            NarratorChatListener.field_193643_a.func_216864_a(I18n.func_135052_a((String)"narrator.select", (Object[])new Object[]{narration}) + " . " + I18n.func_135052_a((String)"narration.xaero_ui_list_left_right_usage", (Object[])new Object[0]));
        }

        public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
            this.hovered = null;
            super.func_230430_a_(poseStack, i, j, f);
        }

        public EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> getDataConverter() {
            return this.dataConverter;
        }

        public class Entry
        extends ExtendedList.AbstractListEntry<xaero.hud.category.ui.GuiCategoryEditor$SettingRowList.Entry> {
            private EditorListRootEntry wrappedEntry;
            private int index;
            private int lastX;
            private int lastY;

            public Entry(EditorListRootEntry entryInfo, int index) {
                this.wrappedEntry = entryInfo;
                this.index = index;
            }

            public void func_230432_a_(MatrixStack poseStack, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.lastX = x;
                this.lastY = y;
                poseStack.func_227860_a_();
                poseStack.func_227861_a_((double)x, (double)y, 0.0);
                boolean includesSelected = SettingRowList.this.func_230958_g_() == this;
                this.wrappedEntry.preRender(poseStack, includesSelected, true);
                EditorListEntry hoveredInRow = this.wrappedEntry.render(poseStack, index, rowWidth, rowHeight, mouseX - x - this.wrappedEntry.getEntryRelativeX(), mouseY - y - this.wrappedEntry.getEntryRelativeY(), isMouseOver, partialTicks, GuiCategoryEditor.this.field_230712_o_, mouseX, mouseY, includesSelected, true);
                this.wrappedEntry.postRender(poseStack);
                poseStack.func_227865_b_();
                if (hoveredInRow != null) {
                    SettingRowList.this.hovered = hoveredInRow;
                }
            }

            public boolean func_231044_a_(double mouseX, double mouseY, int i) {
                SettingRowList.this.setSelected(this);
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseClicked(this, relativeMouseX, relativeMouseY, i);
                return true;
            }

            public boolean func_231048_c_(double mouseX, double mouseY, int i) {
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                double relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY();
                this.wrappedEntry.mouseReleased(relativeMouseX, relativeMouseY, i);
                return super.func_231048_c_(mouseX, mouseY, i);
            }

            public boolean func_231043_a_(double mouseX, double mouseY, double f) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseScrolled(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), f)) {
                    return true;
                }
                return super.func_231043_a_(mouseX, mouseY, f);
            }

            public boolean func_231045_a_(double mouseX, double mouseY, int i, double f, double g) {
                double relativeMouseY;
                double relativeMouseX = mouseX - (double)this.lastX - (double)this.wrappedEntry.getEntryRelativeX();
                if (this.wrappedEntry.mouseDragged(relativeMouseX, relativeMouseY = mouseY - (double)this.lastY - (double)this.wrappedEntry.getEntryRelativeY(), i, f, g)) {
                    return true;
                }
                return super.func_231045_a_(mouseX, mouseY, i, f, g);
            }

            public boolean func_231046_a_(int i, int j, int k) {
                if (this.wrappedEntry.keyPressed(i, j, k, true)) {
                    return true;
                }
                return super.func_231046_a_(i, j, k);
            }

            public boolean func_223281_a_(int i, int j, int k) {
                if (this.wrappedEntry.keyReleased(i, j, k)) {
                    return true;
                }
                return super.func_223281_a_(i, j, k);
            }

            public boolean func_231042_a_(char c, int i) {
                if (this.wrappedEntry.charTyped(c, i)) {
                    return true;
                }
                return super.func_231042_a_(c, i);
            }

            public void func_212927_b(double d, double e) {
                this.wrappedEntry.mouseMoved(d, e);
                super.func_212927_b(d, e);
            }

            public boolean func_231049_c__(boolean bl) {
                this.wrappedEntry.changeFocus(bl);
                return super.func_231049_c__(bl);
            }

            public void tick() {
                this.wrappedEntry.tick();
            }
        }
    }
}

