/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.compass.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import xaero.common.HudMod;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.misc.Misc;
import xaero.hud.minimap.compass.render.CardinalDirection;
import xaero.hud.minimap.element.render.over.MinimapElementOverMapRendererHandler;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.render.util.RenderBufferUtil;

public class CompassRenderer {
    private final HudMod modMain;
    private final Minecraft mc;
    private double[] partialDest;

    public CompassRenderer(HudMod modMain, Minecraft mc) {
        this.modMain = modMain;
        this.mc = mc;
        this.partialDest = new double[2];
    }

    public void drawCompass(MatrixStack matrixStack, int specW, int specH, double ps, double pc, double zoom, boolean circle, float minimapScale, boolean background, IRenderTypeBuffer.Impl textRenderTypeBuffer, IVertexBuilder nameBgBuilder) {
        if (this.modMain.getSettings().compassLocation == 0) {
            return;
        }
        WaypointColor defaultColor = WaypointColor.fromIndex(this.modMain.getSettings().compassColor);
        MinimapRendererHelper rendererHelper = this.modMain.getMinimap().getMinimapFBORenderer().getHelper();
        for (int i = 0; i < 4; ++i) {
            WaypointColor effectiveColor;
            double offX = (i & 1) * (i == 1 ? 10000 : -10000);
            double offY = (i + 1 & 1) * (i == 2 ? 10000 : -10000);
            matrixStack.func_227860_a_();
            MinimapElementOverMapRendererHandler.translatePosition(matrixStack, specW, specH, specW, specH, ps, pc, offX, offY, zoom, circle, this.partialDest);
            matrixStack.func_227861_a_(-1.0, -1.0, 0.0);
            matrixStack.func_227862_a_(minimapScale, minimapScale, 1.0f);
            ITextComponent initials = CardinalDirection.values()[i].getInitials();
            int halfW = this.mc.field_71466_p.func_238414_a_((ITextProperties)initials) / 2 - 1;
            WaypointColor waypointColor = effectiveColor = i == 0 ? WaypointColor.fromIndex(this.modMain.getSettings().getNorthCompassColor()) : defaultColor;
            if (background) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                int addedFrame = halfW > 3 ? halfW - 3 : 0;
                RenderBufferUtil.addColoredRect(matrixStack.func_227866_c_().func_227870_a_(), nameBgBuilder, -4 - addedFrame, -4 - addedFrame, 9 + 2 * addedFrame, 9 + 2 * addedFrame, 0x90000000 | effectiveColor.getHex() & 0xFFFFFF);
                RenderSystem.defaultBlendFunc();
            }
            Misc.drawNormalText(matrixStack, initials, (float)(-halfW + 1), -2.0f, effectiveColor.getHex(), false, textRenderTypeBuffer);
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
            Misc.drawNormalText(matrixStack, initials, (float)(-halfW), -3.0f, -1, false, textRenderTypeBuffer);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227861_a_(0.0, 0.0, 2.0);
    }
}

