/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.color;

import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.Team;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.radar.color.RadarColor;

public class RadarColorHelper {
    public int getTeamColor(Entity e) {
        Integer teamColor = null;
        Team team = e.func_96124_cp();
        if (team != null) {
            teamColor = team.func_178775_l().func_211163_e();
        }
        return teamColor == null ? -1 : teamColor;
    }

    public int getEntityColor(Entity entity, float offY, boolean cave, int heightLimit, int startFadingAt, boolean heightBasedFade, RadarColor radarColor, RadarColor fallbackColor) {
        float heightFade;
        int color = this.getRadarColorHex(entity, radarColor, fallbackColor);
        float f = heightFade = heightBasedFade ? this.getEntityHeightFade(offY, heightLimit, startFadingAt) : 1.0f;
        if (heightFade >= 1.0f) {
            return color;
        }
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int alpha = 255;
        if (cave) {
            alpha = (int)((float)alpha * heightFade);
        } else {
            red = (int)((float)red * heightFade);
            green = (int)((float)green * heightFade);
            blue = (int)((float)blue * heightFade);
        }
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    private int getRadarColorHex(Entity entity, RadarColor radarColor, RadarColor fallbackColor) {
        if (radarColor != null) {
            return radarColor.getHex();
        }
        int entityTeamColour = this.getTeamColor(entity);
        if (entityTeamColour != -1) {
            return 0xFF000000 | entityTeamColour;
        }
        return fallbackColor.getHex();
    }

    public RadarColor getFallbackColor(EntityRadarCategory category) {
        int colorSetting;
        EntityRadarCategory fallbackCategory = category;
        do {
            if ((fallbackCategory = (EntityRadarCategory)fallbackCategory.getSuperCategory()) != null) continue;
            return RadarColor.WHITE;
        } while ((colorSetting = fallbackCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue()) == -1);
        return RadarColor.fromIndex(colorSetting);
    }

    public float getEntityHeightFade(float offY, int heightLimit, int startFadingAt) {
        int threshold;
        float level = (float)heightLimit - offY;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        int n = threshold = startFadingAt == 0 ? heightLimit * 3 / 4 : heightLimit - startFadingAt;
        if (level <= (float)threshold) {
            brightness = 0.25f + 0.5f * level / (float)threshold;
        }
        return brightness;
    }
}

