/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model.part;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.misc.Misc;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.ModelPartUtil;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelPartRenderTrace;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;

public class RadarIconModelPartPrerenderer {
    public final Method ageableModelHeadPartsMethod = Misc.getMethodReflection(AgeableModel.class, "headParts", "method_22946", "()Ljava/lang/Iterable;", "func_225602_a_", new Class[0]);
    public final Method ageableModelBodyPartsMethod = Misc.getMethodReflection(AgeableModel.class, "bodyParts", "method_22948", "()Ljava/lang/Iterable;", "func_225600_b_", new Class[0]);
    public final Method listModelPartsMethod = Misc.getMethodReflection(SegmentedModel.class, "parts", "method_22960", "()Ljava/lang/Iterable;", "func_225601_a_", new Class[0]);
    private final VertexConsumerWrapper vertexConsumerWrapper = new VertexConsumerWrapper();
    private boolean testedRenderEngineWrapperCompatibility;
    private boolean renderEngineIsWrapperCompatible;
    private IRenderTypeBuffer.Impl testBufferSource = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(256));

    public void renderPart(MatrixStack matrixStack, IVertexBuilder vertexConsumer, ModelRenderer part, ModelRenderer mainPart, Parameters parameters) {
        if (part == null) {
            return;
        }
        if (parameters.renderedDest.contains(part)) {
            return;
        }
        ModelPartRenderTrace renderInfo = parameters.mrt.getModelPartRenderInfo(part);
        if (renderInfo == null) {
            return;
        }
        if (!ModelPartUtil.hasCubes(part)) {
            return;
        }
        boolean showModelBU = part.field_78806_j;
        if (!this.testedRenderEngineWrapperCompatibility) {
            this.testRenderEngineWrapperCompatibility(part, parameters.mrt, renderInfo);
        }
        float centerPointX = mainPart.field_78800_c;
        float centerPointY = mainPart.field_78797_d;
        float centerPointZ = mainPart.field_78798_e;
        ModelRenderer.ModelBox biggestMainPartCuboid = ModelPartUtil.getBiggestCuboid(mainPart);
        if (biggestMainPartCuboid != null) {
            centerPointY += (biggestMainPartCuboid.field_78249_e + biggestMainPartCuboid.field_78250_b) / 2.0f;
            centerPointZ += (biggestMainPartCuboid.field_78246_f + biggestMainPartCuboid.field_78251_c) / 2.0f;
        }
        float xRotBU = 0.0f;
        float yRotBU = 0.0f;
        float zRotBU = 0.0f;
        if (parameters.config.modelPartsRotationReset) {
            xRotBU = part.field_78795_f;
            yRotBU = part.field_78796_g;
            zRotBU = part.field_78808_h;
            part.field_78795_f = 0.0f;
            part.field_78796_g = 0.0f;
            part.field_78808_h = 0.0f;
        }
        part.field_78806_j = true;
        float xBU = part.field_78800_c;
        float yBU = part.field_78797_d;
        float zBU = part.field_78798_e;
        part.func_78793_a(part.field_78800_c - centerPointX, part.field_78797_d - centerPointY, part.field_78798_e - centerPointZ);
        try {
            if (this.renderEngineIsWrapperCompatible) {
                vertexConsumer = this.vertexConsumerWrapper.prepareDetection(vertexConsumer, 3.0, 61.0, 3.0, 61.0, -497.0, -2.0);
            }
            part.func_228309_a_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            if ((!this.renderEngineIsWrapperCompatible || this.vertexConsumerWrapper.hasDetectedVertex()) && renderInfo.alpha > 0.0f) {
                parameters.renderedDest.add(part);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + part + " " + t.getMessage());
        }
        part.field_78800_c = xBU;
        part.field_78797_d = yBU;
        part.field_78798_e = zBU;
        while (GL11.glGetError() != 0) {
        }
        if (parameters.config.modelPartsRotationReset) {
            part.field_78795_f = xRotBU;
            part.field_78796_g = yRotBU;
            part.field_78808_h = zRotBU;
        }
        part.field_78806_j = showModelBU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRenderEngineWrapperCompatibility(ModelRenderer part, ModelRenderTrace mrt, ModelPartRenderTrace renderInfo) {
        boolean normalWorks = false;
        try {
            MatrixStack testMatrix = new MatrixStack();
            testMatrix.func_227861_a_(0.0, 0.0, -2500.0);
            IVertexBuilder actualVertexConsumer = this.testBufferSource.getBuffer(CustomRenderTypes.entityIconRenderType(mrt.renderTexture, mrt.layerPhases));
            part.func_228309_a_(testMatrix, actualVertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            normalWorks = true;
            testMatrix = new MatrixStack();
            testMatrix.func_227861_a_(0.0, 0.0, -2500.0);
            this.vertexConsumerWrapper.prepareDetection(actualVertexConsumer, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            part.field_78806_j = true;
            part.func_228309_a_(testMatrix, (IVertexBuilder)this.vertexConsumerWrapper, 0xF000F0, OverlayTexture.field_229196_a_, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            this.renderEngineIsWrapperCompatible = this.vertexConsumerWrapper.hasDetectedVertex();
            if (!this.renderEngineIsWrapperCompatible) {
                throw new Exception("can't detect vertices");
            }
        }
        catch (Throwable t) {
            if (normalWorks) {
                MinimapLogs.LOGGER.warn("Render engine used for entities is not fully compatible with the minimap entity icons. Using fallback. " + t.getMessage());
            }
        }
        finally {
            this.testBufferSource.func_228461_a_();
        }
        if (normalWorks) {
            this.testedRenderEngineWrapperCompatibility = true;
        }
    }

    public <T extends Entity> ModelRenderer renderDeclaredMethod(MatrixStack matrixStack, IVertexBuilder vertexConsumer, Method method, EntityModel<T> model, ModelRenderer mainPart, Parameters parameters) {
        if (method == null) {
            return mainPart;
        }
        return this.renderPartsIterable((Iterable)Misc.getReflectMethodValue(model, method, new Object[0]), matrixStack, vertexConsumer, mainPart, parameters);
    }

    public ModelRenderer renderPartsIterable(Iterable<ModelRenderer> parts, MatrixStack matrixStack, IVertexBuilder vertexConsumer, ModelRenderer mainPart, Parameters parameters) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<ModelRenderer> partsIterator = parts.iterator();
        if (!partsIterator.hasNext()) {
            return mainPart;
        }
        if (mainPart == null) {
            mainPart = partsIterator.next();
            this.renderPart(matrixStack, vertexConsumer, mainPart, mainPart, parameters);
        }
        while (partsIterator.hasNext()) {
            this.renderPart(matrixStack, vertexConsumer, partsIterator.next(), mainPart, parameters);
        }
        return mainPart;
    }

    public static class Parameters {
        public final RadarIconModelConfig config;
        public final ModelRenderTrace mrt;
        public final List<ModelRenderer> renderedDest;

        public Parameters(RadarIconModelConfig config, ModelRenderTrace mrt, List<ModelRenderer> renderedDest) {
            this.config = config;
            this.mrt = mrt;
            this.renderedDest = renderedDest;
        }
    }

    public static class VertexConsumerWrapper
    implements IVertexBuilder {
        private IVertexBuilder consumer;
        private boolean detectedVertex;
        private double detectionMinX;
        private double detectionMaxX;
        private double detectionMinY;
        private double detectionMaxY;
        private double detectionMinZ;
        private double detectionMaxZ;

        public VertexConsumerWrapper prepareDetection(IVertexBuilder consumer, double detectionMinX, double detectionMaxX, double detectionMinY, double detectionMaxY, double detectionMinZ, double detectionMaxZ) {
            this.consumer = consumer;
            this.detectionMinX = detectionMinX;
            this.detectionMaxX = detectionMaxX;
            this.detectionMinY = detectionMinY;
            this.detectionMaxY = detectionMaxY;
            this.detectionMinZ = detectionMinZ;
            this.detectionMaxZ = detectionMaxZ;
            this.detectedVertex = false;
            return this;
        }

        public IVertexBuilder func_225582_a_(double d, double e, double f) {
            if (d >= this.detectionMinX && d <= this.detectionMaxX && e >= this.detectionMinY && e <= this.detectionMaxY && f >= this.detectionMinZ && f <= this.detectionMaxZ) {
                this.detectedVertex = true;
            }
            return this.consumer.func_225582_a_(d, e, f);
        }

        public IVertexBuilder func_225586_a_(int i, int j, int k, int l) {
            return this.consumer.func_225586_a_(i, j, k, l);
        }

        public IVertexBuilder func_225583_a_(float f, float g) {
            return this.consumer.func_225583_a_(f, g);
        }

        public IVertexBuilder func_225585_a_(int i, int j) {
            return this.consumer.func_225585_a_(i, j);
        }

        public IVertexBuilder func_225587_b_(int i, int j) {
            return this.consumer.func_225587_b_(i, j);
        }

        public IVertexBuilder func_225584_a_(float f, float g, float h) {
            return this.consumer.func_225584_a_(f, g, h);
        }

        public void func_181675_d() {
            this.consumer.func_181675_d();
        }

        public boolean hasDetectedVertex() {
            return this.detectedVertex;
        }
    }
}

