/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.resources.I18n;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.render.WaypointGuiRenderContext;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.Misc;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.waypoint.render.WaypointDeleter;
import xaero.hud.minimap.waypoint.render.WaypointMapRenderContext;
import xaero.hud.minimap.waypoint.render.WaypointReader;
import xaero.hud.minimap.waypoint.render.WaypointRenderProvider;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.render.util.RenderBufferUtil;

public abstract class WaypointMapRenderer
extends MinimapElementRenderer<Waypoint, WaypointMapRenderContext> {
    private MinimapRendererHelper helper;
    private int scale;
    private boolean temporaryWaypointsGlobal;
    private double waypointsDistance;
    private boolean dimensionScaleDistance;
    private int opacity;
    private IRenderTypeBuffer.Impl minimapBufferSource;
    private IVertexBuilder texturedIconConsumer;
    private IVertexBuilder waypointBackgroundConsumer;

    protected WaypointMapRenderer(WaypointReader elementReader, WaypointRenderProvider provider, WaypointMapRenderContext context) {
        super(elementReader, provider, context);
    }

    @Override
    public boolean renderElement(Waypoint w, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo, MatrixStack matrixStack, IRenderTypeBuffer.Impl vanillaBufferSource) {
        double waypointPosDivider = renderInfo.backgroundCoordinateScale / ((WaypointMapRenderContext)this.context).dimCoordinateScale;
        double wX = (double)w.getX(waypointPosDivider) + 0.5;
        double wZ = (double)w.getZ(waypointPosDivider) + 0.5;
        double offX = wX - renderInfo.renderPos.field_72450_a;
        double offZ = wZ - renderInfo.renderPos.field_72449_c;
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        double distanceScale = this.dimensionScaleDistance ? renderInfo.backgroundCoordinateScale : 1.0;
        double scaledDistance2D = distance2D * distanceScale;
        if (!(w.isDestination() || w.getPurpose() == WaypointPurpose.DEATH || w.isGlobal() || w.isTemporary() && this.temporaryWaypointsGlobal || this.waypointsDistance == 0.0 || !(scaledDistance2D > this.waypointsDistance))) {
            return false;
        }
        MinimapElementRenderLocation location = renderInfo.location;
        matrixStack.func_227861_a_(-1.0, -1.0, optionalDepth);
        if (this.scale <= 0 || location != MinimapElementRenderLocation.OVER_MINIMAP) {
            matrixStack.func_227862_a_(optionalScale, optionalScale, 1.0f);
        } else {
            matrixStack.func_227862_a_((float)this.scale, (float)this.scale, 1.0f);
        }
        this.drawIconOnGUI(matrixStack, this.helper, w, 0, 0, this.opacity, this.minimapBufferSource, this.waypointBackgroundConsumer, this.texturedIconConsumer);
        return true;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        RenderSystem.disableDepthTest();
        vanillaBufferSource.func_228461_a_();
        this.minimapBufferSource = HudMod.INSTANCE.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        this.waypointBackgroundConsumer = this.minimapBufferSource.getBuffer(CustomRenderTypes.COLORED_WAYPOINTS_BGS);
        this.texturedIconConsumer = this.minimapBufferSource.getBuffer(CustomRenderTypes.GUI_NEAREST);
        this.helper = HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().getHelper();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorld currentWorld = session.getWorldManager().getCurrentWorld();
        ((WaypointMapRenderContext)this.context).dimCoordinateScale = session.getDimensionHelper().getDimCoordinateScale(currentWorld);
        ModSettings settings = HudMod.INSTANCE.getSettings();
        this.scale = settings.waypointOnMapScale;
        this.temporaryWaypointsGlobal = settings.temporaryWaypointsGlobal;
        this.waypointsDistance = settings.getMaxWaypointsDistance();
        this.dimensionScaleDistance = settings.dimensionScaledMaxWaypointDistance;
        this.opacity = settings.waypointOpacityMap;
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo, IRenderTypeBuffer.Impl vanillaBufferSource, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        this.minimapBufferSource.func_228461_a_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)515);
        this.waypointBackgroundConsumer = null;
    }

    @Deprecated
    public void updateWaypointCollection() {
    }

    @Deprecated
    public void drawIconOnGUI(MatrixStack matrixStack, MinimapRendererHelper rendererHelper, Waypoint w, int drawX, int drawY, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer, IVertexBuilder texturedIconConsumer) {
        ModSettings settings = HudMod.INSTANCE.getSettings();
        int opacity = settings.waypointOpacityMap;
        this.drawIconOnGUI(matrixStack, rendererHelper, w, drawX, drawY, opacity, renderTypeBuffer, waypointBackgroundConsumer, texturedIconConsumer);
    }

    public void drawIconOnGUI(MatrixStack matrixStack, MinimapRendererHelper rendererHelper, Waypoint w, int drawX, int drawY, int opacity, IRenderTypeBuffer.Impl renderTypeBuffer, IVertexBuilder waypointBackgroundConsumer, IVertexBuilder texturedIconConsumer) {
        int color = w.getWaypointColor().getHex();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float a = (float)opacity / 100.0f;
        int initialsWidth = w.getPurpose() == WaypointPurpose.DEATH ? 7 : Minecraft.func_71410_x().field_71466_p.func_78256_a(w.getInitials());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        int rectX1 = drawX - 4 - addedFrame;
        int rectY1 = drawY - 4;
        int rectX2 = drawX + 5 + addedFrame;
        int rectY2 = drawY + 5;
        RenderBufferUtil.addColoredRect(matrixStack.func_227866_c_().func_227870_a_(), waypointBackgroundConsumer, rectX1, rectY1, rectX2 - rectX1, rectY2 - rectY1, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, a);
        if (w.getPurpose() == WaypointPurpose.DEATH) {
            RenderBufferUtil.addTexturedColoredRect(matrixStack.func_227866_c_().func_227870_a_(), texturedIconConsumer, rectX1 + 1, rectY1 + 1, 0, 87, 9, 9, 9, -9, 0.2431f, 0.2431f, 0.2431f, 1.0f, 256.0f);
            RenderBufferUtil.addTexturedColoredRect(matrixStack.func_227866_c_().func_227870_a_(), texturedIconConsumer, rectX1, rectY1, 0, 87, 9, 9, 9, -9, 0.9882f, 0.9882f, 0.9882f, 1.0f, 256.0f);
            return;
        }
        Misc.drawNormalText(matrixStack, w.getInitials(), (float)(drawX + 1 - initialsWidth / 2), (float)(drawY - 3), -1, true, renderTypeBuffer);
    }

    @Deprecated
    public void drawSetChange(WaypointsManager waypointsManager, MatrixStack matrixStack, MainWindow res) {
        this.drawSetChange((MinimapSession)waypointsManager, matrixStack, res);
    }

    public void drawSetChange(MinimapSession session, MatrixStack matrixStack, MainWindow res) {
        MinimapWorld minimapWorld = session.getWorldManager().getCurrentWorld();
        if (minimapWorld == null) {
            return;
        }
        WaypointSession waypointSession = session.getWaypointSession();
        if (waypointSession.getSetChangedTime() == 0L) {
            return;
        }
        int passed = (int)(System.currentTimeMillis() - waypointSession.getSetChangedTime());
        if (passed >= 1500) {
            waypointSession.setSetChangedTime(0L);
            return;
        }
        int fadeTime = 300;
        boolean fading = passed > 1500 - fadeTime;
        float fadeFactor = fading ? (float)(1500 - passed) / (float)fadeTime : 1.0f;
        int alpha = 3 + (int)(252.0f * fadeFactor);
        int c = 0xFFFFFF | alpha << 24;
        IRenderTypeBuffer.Impl renderBuffers = HudMod.INSTANCE.getHudRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        Misc.drawCenteredPiercingText(matrixStack, I18n.func_135052_a((String)minimapWorld.getCurrentWaypointSet().getName(), (Object[])new Object[0]), (float)(res.func_198107_o() / 2), (float)(res.func_198087_p() / 2 + 50), c, true, renderBuffers);
        renderBuffers.func_228461_a_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        if (!(location != MinimapElementRenderLocation.OVER_MINIMAP && location != MinimapElementRenderLocation.IN_MINIMAP || HudMod.INSTANCE.getSettings().getShowWaypoints())) {
            return false;
        }
        return !Misc.hasEffect(Effects.NO_WAYPOINTS) && !Misc.hasEffect(Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static final class Builder {
        private WaypointDeleter waypointDeleter;
        private final IXaeroMinimap modMain;

        private Builder(IXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        private Builder setDefault() {
            this.setWaypointDeleter(null);
            return this;
        }

        public Builder setWaypointDeleter(WaypointDeleter waypointDeleter) {
            this.waypointDeleter = waypointDeleter;
            return this;
        }

        public WaypointMapRenderer build() {
            if (this.waypointDeleter == null) {
                throw new IllegalStateException();
            }
            WaypointGuiRenderContext context = new WaypointGuiRenderContext();
            return new WaypointsGuiRenderer(new xaero.common.minimap.waypoints.render.WaypointReader(), new xaero.common.minimap.waypoints.render.WaypointRenderProvider(), context);
        }

        public static Builder begin(IXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

