/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world.state;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.FolderName;
import xaero.common.HudMod;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.minimap.world.container.config.RootConfig;
import xaero.hud.minimap.world.state.MinimapWorldState;
import xaero.hud.path.XaeroPath;

public class MinimapWorldStateUpdater {
    public static final int ROOT_CONTAINER_FORMAT = 3;
    private final HudMod modMain;
    private final MinimapSession session;
    private final ClientPlayNetHandler connection;
    private BlockPos currentWorldSpawn;

    public MinimapWorldStateUpdater(HudMod modMain, MinimapSession session, ClientPlayNetHandler connection) {
        this.modMain = modMain;
        this.session = session;
        this.connection = connection;
    }

    public void init() {
        this.session.getWorldState().setAutoRootContainerPath(this.getAutoRootContainerPath(3));
        for (int i = 0; i < 3; ++i) {
            this.session.getWorldState().setOutdatedAutoRootContainerPath(i, this.getAutoRootContainerPath(i));
        }
    }

    @Deprecated
    public void update(MinimapSession session) {
        this.update();
    }

    public void update() {
        MinimapWorldState state = this.session.getWorldState();
        XaeroPath oldAutoWorldPath = state.getAutoWorldPath();
        XaeroPath potentialAutoContainerPath = this.getPotentialContainerPath();
        state.setAutoContainerPathIgnoreCaseCache(potentialAutoContainerPath);
        boolean worldmap = this.modMain.getSupportMods().worldmap();
        String potentialAutoWorldNode = this.getPotentialWorldNode((RegistryKey<World>)this.session.getMc().field_71441_e.func_234923_W_(), worldmap);
        if (potentialAutoWorldNode == null) {
            return;
        }
        XaeroPath autoWorldPath = potentialAutoContainerPath.resolve(potentialAutoWorldNode);
        state.setAutoWorldPath(autoWorldPath);
        if (oldAutoWorldPath != null && potentialAutoContainerPath.equals(oldAutoWorldPath.getParent())) {
            return;
        }
        MinimapWorldRootContainer autoRootContainer = this.session.getWorldManager().getAutoRootContainer();
        autoRootContainer.renameOldContainer(potentialAutoContainerPath);
        autoRootContainer.updateDimensionType(this.session.getMc().field_71441_e);
        if (oldAutoWorldPath == null) {
            return;
        }
        MinimapWorldContainer oldContainer = this.session.getWorldManager().getWorldContainer(oldAutoWorldPath.getParent());
        oldContainer.getServerWaypointManager().clear();
    }

    @Deprecated
    public XaeroPath getPotentialContainerPath(MinimapSession session) {
        return this.getPotentialContainerPath();
    }

    public XaeroPath getPotentialContainerPath() {
        String dimensionNode = this.session.getDimensionHelper().getDimensionDirectoryName((RegistryKey<World>)this.session.getMc().field_71441_e.func_234923_W_());
        XaeroPath potentialContainerPath = this.session.getWorldState().getAutoRootContainerPath().resolve(dimensionNode);
        return this.ignoreContainerCase(potentialContainerPath, this.session.getWorldState().getAutoContainerPathIgnoreCaseCache());
    }

    @Deprecated
    public XaeroPath ignoreContainerCase(XaeroPath potentialContainerPath, XaeroPath currentPath, MinimapSession session) {
        return this.ignoreContainerCase(potentialContainerPath, currentPath);
    }

    public XaeroPath ignoreContainerCase(XaeroPath potentialContainerPath, XaeroPath currentPath) {
        if (potentialContainerPath.equals(currentPath)) {
            return currentPath;
        }
        for (MinimapWorldRootContainer rootContainer : this.session.getWorldManager().getRootContainers()) {
            XaeroPath containerSearch = rootContainer.fixPathCharacterCases(potentialContainerPath);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerPath;
    }

    @Deprecated
    public XaeroPath getAutoRootContainerPath(int version, ClientPlayNetHandler connection, MinimapSession session) {
        return this.getAutoRootContainerPath(version);
    }

    public XaeroPath getAutoRootContainerPath(int version) {
        String potentialContainerID;
        Minecraft mc = Minecraft.func_71410_x();
        ServerData serverData = mc.func_147104_D();
        if (mc.func_71401_C() != null) {
            potentialContainerID = MinimapWorldContainerUtil.convertWorldFolderToContainerNode(mc.func_71401_C().func_240776_a_(FolderName.field_237253_i_).getParent().getFileName().toString(), version);
        } else if (mc.func_181540_al() && this.modMain.getEvents().latestRealm != null) {
            potentialContainerID = "Realms_" + this.modMain.getEvents().latestRealm.field_230588_g_ + "." + this.modMain.getEvents().latestRealm.field_230582_a_;
        } else if (serverData != null) {
            String serverIP = this.modMain.getSettings().differentiateByServerAddress ? serverData.field_78845_b : "Any Address";
            int portDivider = version >= 1 && serverIP.indexOf(":") != serverIP.lastIndexOf(":") ? serverIP.lastIndexOf("]:") + 1 : serverIP.indexOf(":");
            if (portDivider > 0) {
                serverIP = serverIP.substring(0, portDivider);
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            if (version >= 2) {
                serverIP = serverIP.replace("[", "").replace("]", "");
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", version < 3 ? "\u00a7" : ".").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = "Unknown";
        }
        XaeroPath potentialContainerPath = XaeroPath.root(potentialContainerID);
        potentialContainerPath = this.ignoreContainerCase(potentialContainerPath, null);
        return potentialContainerPath;
    }

    @Deprecated
    public String getPotentialWorldNode(RegistryKey<World> dimId, boolean useWorldmap, MinimapSession session) {
        return this.getPotentialWorldNode(dimId, useWorldmap);
    }

    public String getPotentialWorldNode(RegistryKey<World> dimId, boolean useWorldmap) {
        String actualWorldNode;
        String worldmapWorldNode;
        if (this.session.getMc().func_71401_C() != null) {
            return "waypoints";
        }
        MinimapWorldState state = this.session.getWorldState();
        MinimapWorldRootContainer rootContainer = this.session.getWorldManager().getRootWorldContainer(state.getAutoRootContainerPath());
        Object autoNodeBase = this.getAutoWorldNodeBase(rootContainer);
        if (autoNodeBase == null) {
            return null;
        }
        String string = worldmapWorldNode = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId(dimId) : null;
        if (useWorldmap && worldmapWorldNode == null) {
            return null;
        }
        if (autoNodeBase instanceof BlockPos) {
            BlockPos pos = (BlockPos)autoNodeBase;
            actualWorldNode = "mw" + (pos.func_177958_n() >> 6) + "," + (pos.func_177956_o() >> 6) + "," + (pos.func_177952_p() >> 6);
            RootConfig config = rootContainer.getConfig();
            if (!config.isUsingMultiworldDetection()) {
                String defaultMultiworldId = config.getDefaultMultiworldId();
                if (defaultMultiworldId == null) {
                    config.setDefaultMultiworldId(actualWorldNode);
                    this.session.getWorldManagerIO().getRootConfigIO().save(rootContainer);
                } else {
                    actualWorldNode = defaultMultiworldId;
                }
            }
        } else {
            actualWorldNode = "mw$" + autoNodeBase;
        }
        if (useWorldmap && worldmapWorldNode != "minimap") {
            actualWorldNode = worldmapWorldNode;
        }
        return actualWorldNode;
    }

    public boolean hasServerLevelId(MinimapWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.getConfig().isIgnoreServerLevelId();
    }

    public Object getAutoWorldNodeBase(MinimapWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentWorldSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + Minecraft.func_71410_x().field_71441_e.func_234923_W_());
    }

    public void setCurrentWorldSpawn(BlockPos currentWorldSpawn) {
        this.currentWorldSpawn = currentWorldSpawn;
    }
}

