/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render.world;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import xaero.common.HudMod;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.element.render.MinimapElementRendererHandler;
import xaero.hud.minimap.module.MinimapSession;

public class MinimapElementWorldRendererHandler
extends MinimapElementRendererHandler {
    private static final float DEFAULT_SCALE = 0.8f;
    private static final float MINECRAFT_SCALE = 0.02666667f;
    private static final double ELEMENT_WORLD_SCALE = 0.02133333496749401;
    private final PoseStack matrixStackWorld;
    private final Vector4f origin4f;
    private Matrix4f waypointsProjection;
    private Matrix4f worldModelView;
    private int screenWidth;
    private int screenHeight;
    private Object workingClosestHoveredElement;
    private float workingClosestHoveredElementDistance;
    private MinimapElementRenderer<?, ?> workingClosestHoveredElementRenderer;
    private Object previousClosestHoveredElement;
    private MinimapElementRenderer<?, ?> previousClosestHoveredElementRenderer;
    private boolean previousClosestHoveredElementPresent;
    private boolean renderingMainHighlightedElement;

    protected MinimapElementWorldRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, PoseStack matrixStackWorld, Vector4f origin4f) {
        super(modMain, renderers, MinimapElementRenderLocation.IN_WORLD, 19499);
        this.matrixStackWorld = matrixStackWorld;
        this.origin4f = origin4f;
    }

    public void prepareRender(Matrix4f waypointsProjection, Matrix4f worldModelView) {
        this.waypointsProjection = waypointsProjection;
        this.worldModelView = worldModelView;
    }

    @Override
    public void render(PoseStack matrixStack, Vec3 renderPos, float partialTicks, RenderTarget framebuffer, double backgroundCoordinateScale, ResourceKey<Level> mapDimension) {
        if (HudMod.INSTANCE.getSupportMods().vivecraft) {
            return;
        }
        this.renderingMainHighlightedElement = false;
        super.render(matrixStack, renderPos, partialTicks, framebuffer, backgroundCoordinateScale, mapDimension);
    }

    @Override
    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, double elementX, double elementY, double elementZ, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo, PoseStack matrixStackOverlay, MultiBufferSource.BufferSource vanillaBufferSource) {
        float partialTicks = renderInfo.partialTicks;
        Vec3 renderPos = renderInfo.renderPos;
        MinimapElementReader<E, RRC> elementReader = renderer.getElementReader();
        double offX = elementX - renderPos.f_82479_;
        double offY = elementReader.getRenderY(element, context, partialTicks) - renderPos.f_82480_;
        double offZ = elementZ - renderPos.f_82481_;
        Vector3f lookVector = Minecraft.m_91087_().f_91063_.m_109153_().m_90596_().m_122281_();
        double depth = offX * (double)lookVector.m_122239_() + offY * (double)lookVector.m_122260_() + offZ * (double)lookVector.m_122269_();
        if (depth < 0.05) {
            return false;
        }
        if (!this.renderingMainHighlightedElement && element == this.previousClosestHoveredElement) {
            this.previousClosestHoveredElementPresent = true;
            return false;
        }
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        if (distance > 250000.0) {
            double offScaler = 250000.0 / distance;
            offX *= offScaler;
            offY *= offScaler;
            offZ *= offScaler;
        }
        matrixStackOverlay.m_85836_();
        this.matrixStackWorld.m_85836_();
        this.matrixStackWorld.m_85837_(offX, offY, offZ);
        this.origin4f.m_123607_(this.matrixStackWorld.m_85850_().m_85861_());
        this.matrixStackWorld.m_85849_();
        this.origin4f.m_123607_(this.waypointsProjection);
        float translateX = (1.0f + this.origin4f.m_123601_() / this.origin4f.m_123617_()) / 2.0f * (float)this.screenWidth;
        float translateY = (1.0f - this.origin4f.m_123615_() / this.origin4f.m_123617_()) / 2.0f * (float)this.screenHeight;
        this.origin4f.m_123602_(0.0f, 0.0f, 0.0f, 1.0f);
        int roundedX = Math.round(translateX);
        int roundedY = Math.round(translateY);
        boolean outOfBounds = roundedX < 0 || roundedY < 0 || roundedX >= this.screenWidth || roundedY >= this.screenHeight;
        boolean renderingHoveredElement = this.isElementHovered(element, roundedX, roundedY, elementReader, context, renderInfo);
        double partialX = translateX - (float)roundedX;
        double partialY = translateY - (float)roundedY;
        matrixStackOverlay.m_85837_((double)roundedX, (double)roundedY, 0.0);
        boolean highlighted = this.renderingMainHighlightedElement;
        highlighted = highlighted || renderingHoveredElement && elementReader.isAlwaysHighlightedWhenHovered(element, context);
        boolean result = renderer.renderElement(element, highlighted, outOfBounds, optionalDepth, 1.0f, partialX, partialY, renderInfo, matrixStackOverlay, vanillaBufferSource);
        matrixStackOverlay.m_85849_();
        if (result && renderingHoveredElement) {
            this.handleClosestHovered(element, renderer, roundedX, roundedY);
        }
        return result;
    }

    private <E, RRC> boolean isElementHovered(E element, int roundedX, int roundedY, MinimapElementReader<E, RRC> elementReader, RRC context, MinimapElementRenderInfo renderInfo) {
        int centerX;
        if (!elementReader.isInteractable(this.location, element)) {
            return false;
        }
        float partialTicks = renderInfo.partialTicks;
        int interactionLeft = elementReader.getInteractionBoxLeft(element, context, partialTicks);
        int interactionRight = elementReader.getInteractionBoxRight(element, context, partialTicks);
        int interactionTop = elementReader.getInteractionBoxTop(element, context, partialTicks);
        int interactionBottom = elementReader.getInteractionBoxBottom(element, context, partialTicks);
        double boxScale = elementReader.getBoxScale(this.location, element, context);
        if (boxScale != 1.0) {
            interactionLeft = (int)((double)interactionLeft * boxScale);
            interactionRight = (int)((double)interactionRight * boxScale);
            interactionTop = (int)((double)interactionTop * boxScale);
            interactionBottom = (int)((double)interactionBottom * boxScale);
        }
        if ((centerX = this.screenWidth / 2) - roundedX < interactionLeft || centerX - roundedX >= interactionRight) {
            return false;
        }
        int centerY = this.screenHeight / 2;
        return centerY - roundedY >= interactionTop && centerY - roundedY < interactionBottom;
    }

    private <E, RRC, RR extends MinimapElementRenderer<E, RRC>> void handleClosestHovered(E element, RR renderer, int roundedX, int roundedY) {
        int centerX = this.screenWidth / 2;
        int centerY = this.screenHeight / 2;
        int screenOffX = roundedX - centerX;
        int screenOffY = roundedY - centerY;
        float squaredScreenDistance = screenOffX * screenOffX + screenOffY * screenOffY;
        if (this.workingClosestHoveredElement == null || squaredScreenDistance < this.workingClosestHoveredElementDistance || element == this.previousClosestHoveredElement && squaredScreenDistance <= this.workingClosestHoveredElementDistance) {
            this.workingClosestHoveredElement = element;
            this.workingClosestHoveredElementDistance = squaredScreenDistance;
            this.workingClosestHoveredElementRenderer = renderer;
        }
    }

    private <E, RR extends MinimapElementRenderer<E, RRC>, RRC> void renderMainHighlightedElement(MinimapElementRenderInfo renderInfo, PoseStack matrixStack, MultiBufferSource.BufferSource vanillaBufferSource) {
        if (!this.previousClosestHoveredElementPresent) {
            return;
        }
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = session.getMultiTextureRenderTypeRenderers();
        Object element = this.previousClosestHoveredElement;
        MinimapElementRenderer<?, ?> renderer = this.previousClosestHoveredElementRenderer;
        this.renderingMainHighlightedElement = true;
        renderer.preRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        boolean result = this.transformAndRenderForRenderer(element, renderer, renderer.getContext(), 0, 0.0, renderInfo, matrixStack, vanillaBufferSource);
        renderer.postRender(renderInfo, vanillaBufferSource, multiTextureRenderTypeRenderers);
        this.renderingMainHighlightedElement = false;
        this.previousClosestHoveredElementPresent = false;
        if (!result) {
            return;
        }
        matrixStack.m_85837_(0.0, 0.0, this.getElementIndexDepth(1, 1));
    }

    @Override
    protected void beforeRender(PoseStack matrixStackOverlay, MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource) {
        this.screenWidth = Minecraft.m_91087_().m_91268_().m_85441_();
        this.screenHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        this.matrixStackWorld.m_85836_();
        this.matrixStackWorld.m_85850_().m_85861_().m_27644_(this.worldModelView);
        matrixStackOverlay.m_85836_();
        matrixStackOverlay.m_85837_(0.0, 0.0, -2980.0);
    }

    @Override
    protected void afterRender(PoseStack matrixStackOverlay, MinimapElementRenderInfo renderInfo, MultiBufferSource.BufferSource vanillaBufferSource) {
        this.renderMainHighlightedElement(renderInfo, matrixStackOverlay, vanillaBufferSource);
        this.previousClosestHoveredElement = this.workingClosestHoveredElement;
        this.previousClosestHoveredElementRenderer = this.workingClosestHoveredElementRenderer;
        this.workingClosestHoveredElement = null;
        this.workingClosestHoveredElementRenderer = null;
        matrixStackOverlay.m_85849_();
        this.matrixStackWorld.m_85849_();
        CustomRenderTypes.DEPTH_CLEAR.m_110185_();
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        CustomRenderTypes.DEPTH_CLEAR.m_110188_();
    }

    public static final class Builder {
        public MinimapElementWorldRendererHandler build() {
            ArrayList renderers = new ArrayList();
            return new MinimapElementWorldRendererHandler(HudMod.INSTANCE, renderers, new PoseStack(), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        }

        protected Builder setDefault() {
            return this;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

