/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.IntBuffer;
import org.joml.Matrix4f;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.render.util.ImmediateRenderUtil;

public class MinimapRendererHelper {
    public void drawMyTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        this.drawMyTexturedModalRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f);
    }

    public void drawMyTexturedModalRect(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, discardAlpha);
    }

    public void drawIconOutline(PoseStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        ImmediateRenderUtil.drawOutlineLayer(matrixStack, x, y, textureX, textureY, width, height, theight, factor, discardAlpha);
    }

    void drawTexturedElipseInsideRectangle(PoseStack matrixStack, double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(matrixStack, startAngle, sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(PoseStack matrixStack, double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_TEX);
        for (int i = 0; i <= sides; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                vertexBuffer.addVertex(matrix, x + vertexLocalX, y + vertexLocalY, 0.0f).setUv(((float)textureX + vertexLocalX) * f, ((float)textureY + vertexLocalV) * f1);
                vertexBuffer.addVertex(matrix, x + prevVertexLocalX, y + prevVertexLocalY, 0.0f).setUv(((float)textureX + prevVertexLocalX) * f, ((float)textureY + prevVertexLocalV) * f1);
                vertexBuffer.addVertex(matrix, (float)centerX, (float)centerY, 0.0f).setUv(centerU, centerV);
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), CustomRenderTypes.RP_POSITION_TEX_NO_ALPHA);
    }

    void drawTexturedElipseInsideRectangleFrame(PoseStack matrixStack, boolean resetTexture, boolean reverseTexture, double startAngle, int startIndex, int endIndex, int sides, float thickness, float x, float y, int textureX, int textureY, float width, float twidth, float theight, int seamWidth, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        float prevSegmentTextureX = 0.0f;
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        float outerRadius = halfWidth + thickness;
        float segmentOuterWidth = (float)(fullCircle / (double)sides * (double)outerRadius);
        startIndex = Math.max(Math.min(startIndex, sides), 0);
        endIndex = Math.max(Math.min(endIndex, sides), startIndex);
        int textureStartIndex = resetTexture ? (reverseTexture ? endIndex : startIndex) : 0;
        float seamThreshold = reverseTexture ? (float)seamWidth + segmentOuterWidth : (float)seamWidth;
        for (int i = startIndex; i <= endIndex; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)outerRadius * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)outerRadius * cos);
            float segmentTextureStartX = textureX;
            float offsetX = Math.abs(segmentOuterWidth * (float)(i - textureStartIndex));
            if (offsetX >= seamThreshold) {
                segmentTextureStartX = textureX + seamWidth;
                if ((offsetX -= seamThreshold) >= twidth) {
                    offsetX %= twidth;
                }
            }
            float segmentTextureX = segmentTextureStartX + offsetX;
            if (i > startIndex) {
                vertexBuffer.addVertex(matrix, x + prevVertexLocalX, y + prevVertexLocalY, 0.0f).setUv(prevSegmentTextureX * f, ((float)textureY + theight) * f1);
                vertexBuffer.addVertex(matrix, x + vertexLocalX, y + vertexLocalY, 0.0f).setUv(segmentTextureX * f, ((float)textureY + theight) * f1);
                vertexBuffer.addVertex(matrix, x + vertexLocalOuterX, y + vertexLocalOuterY, 0.0f).setUv(segmentTextureX * f, (float)textureY * f1);
                vertexBuffer.addVertex(matrix, x + prevVertexLocalOuterX, y + prevVertexLocalOuterY, 0.0f).setUv(prevSegmentTextureX * f, (float)textureY * f1);
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
            prevSegmentTextureX = segmentTextureX;
        }
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), CustomRenderTypes.RP_POSITION_TEX_NO_ALPHA);
    }

    public void addTexturedRectToExistingBuffer(Matrix4f matrix, VertexConsumer vertexBuffer, float x, float y, int u, int v, int w, int h) {
        float f = 0.00390625f;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.addVertex(matrix, x, y + (float)h, 0.0f).setUv(normalizedU1, normalizedV2);
        vertexBuffer.addVertex(matrix, x + (float)w, y + (float)h, 0.0f).setUv(normalizedU2, normalizedV2);
        vertexBuffer.addVertex(matrix, x + (float)w, y, 0.0f).setUv(normalizedU2, normalizedV1);
        vertexBuffer.addVertex(matrix, x, y, 0.0f).setUv(normalizedU1, normalizedV1);
    }

    public void drawMyColoredRect(PoseStack matrixStack, float x1, float y1, float x2, float y2) {
        Matrix4f matrix = matrixStack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexBuffer = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        vertexBuffer.addVertex(matrix, x1, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y2, 0.0f);
        vertexBuffer.addVertex(matrix, x2, y1, 0.0f);
        vertexBuffer.addVertex(matrix, x1, y1, 0.0f);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.build(), CustomRenderTypes.RP_POSITION);
    }

    public void addColoredLineToExistingBuffer(PoseStack.Pose matrices, VertexConsumer vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.addVertex(matrices, x1, y1, 0.0f).setColor(r, g, b, a).setNormal(matrices, x2 - x1, y2 - y1, 0.0f);
        vertexBuffer.addVertex(matrices, x2, y2, 0.0f).setColor(r, g, b, a).setNormal(matrices, x2 - x1, y2 - y1, 0.0f);
    }

    public void drawMyColoredRect(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrix, x1, y1, x2, y2, color);
    }

    void bindTextureBuffer(IntBuffer image, int width, int height, GpuTexture texture) {
        RenderSystem.getDevice().createCommandEncoder().writeToTexture(texture, image, NativeImage.Format.RGBA, 0, 0, 0, width, height);
        RenderSystem.setShaderTexture((int)0, (GpuTexture)texture);
    }

    void putColor(int[] data, int x, int y, int red, int green, int blue, int size) {
        data[y * size + x] = 0xFF000000 | blue << 16 | green << 8 | red;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho(RenderTarget framebuffer) {
        if (framebuffer != null) {
            Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)framebuffer.width, (float)framebuffer.height, 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)ortho, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        }
    }

    public static void restoreDefaultShaderBlendState() {
    }
}

