/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;

public class GuiNewSet
extends ScreenBase {
    private EditBox nameTextField;
    private MinimapSession session;
    private MinimapWorldManager manager;
    private MinimapWorld minimapWorld;
    private Button confirmButton;

    @Deprecated
    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession session, Screen par1GuiScreen, WaypointWorld waypointWorld) {
        this(modMain, session, par1GuiScreen, null, waypointWorld);
    }

    @Deprecated
    public GuiNewSet(IXaeroMinimap modMain, XaeroMinimapSession session, Screen par1GuiScreen, Screen escapeScreen, WaypointWorld waypointWorld) {
        this(modMain, BuiltInHudModules.MINIMAP.getCurrentSession(), par1GuiScreen, escapeScreen, (MinimapWorld)waypointWorld);
    }

    public GuiNewSet(IXaeroMinimap modMain, MinimapSession session, Screen par1GuiScreen, Screen escapeScreen, MinimapWorld minimapWorld) {
        super(modMain, par1GuiScreen, escapeScreen, (Component)Component.translatable((String)"gui.xaero_create_set"));
        this.session = session;
        this.manager = this.session.getWorldManager();
        this.minimapWorld = minimapWorld;
        this.canSkipWorldRender = true;
    }

    @Override
    public void init() {
        super.init();
        this.nameTextField = new EditBox(this.font, this.width / 2 - 100, 60, 200, 20, (Component)Component.translatable((String)"gui.xaero_set_name"));
        this.setFocused((GuiEventListener)this.nameTextField);
        this.nameTextField.setFocused(true);
        this.addRenderableWidget((GuiEventListener)this.nameTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (this.canConfirm()) {
                String setName = this.nameTextField.getValue().replace(":", "\u00a7\u00a7");
                this.minimapWorld.setCurrentWaypointSetId(setName);
                this.minimapWorld.addWaypointSet(setName);
                try {
                    this.session.getWorldManagerIO().saveWorld(this.minimapWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
                this.goBack();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return this.nameTextField.getValue().length() > 0 && this.minimapWorld.getWaypointSet(this.nameTextField.getValue()) == null;
    }

    private void updateConfirmButton() {
        this.confirmButton.active = this.canConfirm();
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257 && this.canConfirm()) {
            this.confirmButton.onClick(0.0, 0.0);
            return true;
        }
        return result;
    }

    public void tick() {
        this.updateConfirmButton();
    }

    public void renderBackground(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        super.renderBackground(guiGraphics, par1, par2, par3);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        this.nameTextField.render(guiGraphics, par1, par2, par3);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        this.renderEscapeScreen(guiGraphics, par1, par2, par3);
        super.render(guiGraphics, par1, par2, par3);
    }
}

