/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.INetworkDirection;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.PlayNetworkDirection;
import xaero.common.IXaeroMinimap;
import xaero.common.PlatformContextNeoForge;
import xaero.common.message.MinimapMessage;
import xaero.common.message.MinimapMessageHandler;
import xaero.common.message.PacketConsumerNeoForge;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class MinimapMessageHandlerNeoForge
extends MinimapMessageHandler {
    private final IXaeroMinimap modMain;
    private final PlatformContextNeoForge xaeroHudForge;

    public MinimapMessageHandlerNeoForge(IXaeroMinimap modMain, PlatformContextNeoForge xaeroHudForge) {
        this.modMain = modMain;
        this.xaeroHudForge = xaeroHudForge;
    }

    @Override
    public <T extends MinimapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, FriendlyByteBuf> encoder) {
        PacketConsumerNeoForge<T> consumer = new PacketConsumerNeoForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            this.xaeroHudForge.getNetwork().messageBuilder(type, index, (INetworkDirection)(clientHandler == null ? PlayNetworkDirection.PLAY_TO_SERVER : PlayNetworkDirection.PLAY_TO_CLIENT)).consumerNetworkThread(consumer).decoder(decoder::apply).encoder(encoder::accept).add();
            return;
        }
        this.xaeroHudForge.getNetwork().messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder::apply).encoder(encoder::accept).add();
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToPlayer(ServerPlayer player, T message) {
        this.xaeroHudForge.getNetwork().send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    @Override
    public <T extends MinimapMessage<T>> void sendToServer(T message) {
        this.xaeroHudForge.getNetwork().send(PacketDistributor.SERVER.noArg(), message);
    }
}

