/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.message;

import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.INetworkDirection;
import net.neoforged.neoforge.network.NetworkEvent;
import net.neoforged.neoforge.network.PlayNetworkDirection;
import net.neoforged.neoforge.network.simple.MessageFunctions;
import xaero.common.message.MinimapMessage;
import xaero.common.message.client.ClientMessageConsumer;
import xaero.common.message.server.ServerMessageConsumer;

public class PacketConsumerNeoForge<T extends MinimapMessage<T>>
implements MessageFunctions.MessageConsumer<T> {
    private final ServerMessageConsumer<T> serverHandler;
    private final ClientMessageConsumer<T> clientHandler;

    public PacketConsumerNeoForge(ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    public void handle(T msg, NetworkEvent.Context context) {
        if (msg == null) {
            context.setPacketHandled(true);
            return;
        }
        INetworkDirection networkDirection = context.getDirection();
        if (this.clientHandler != null && networkDirection == PlayNetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> this.clientHandler.handle((MinimapMessage)msg));
        } else if (this.serverHandler != null && networkDirection == PlayNetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            context.enqueueWork(() -> this.serverHandler.handle(sender.getServer(), sender, (MinimapMessage)msg));
        }
        context.setPacketHandled(true);
    }
}

