/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.trace;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelPartRenderTrace;

public class ModelRenderTrace {
    public final Model model;
    public final ResourceLocation renderTexture;
    public final TextureAtlasSprite renderAtlasSprite;
    public final RenderPipeline layerPipeline;
    public int color;
    public boolean allVisible;
    private HashMap<ModelPart, ModelPartRenderTrace> visibleParts;

    public ModelRenderTrace(Model model, ResourceLocation renderTexture, TextureAtlasSprite renderAtlasSprite, RenderPipeline layerPipeline, int color) {
        this.model = model;
        this.renderTexture = renderTexture;
        this.renderAtlasSprite = renderAtlasSprite;
        this.layerPipeline = layerPipeline;
        this.color = color;
    }

    public String toString() {
        return String.valueOf(this.model) + " " + String.valueOf(this.layerPipeline.getLocation());
    }

    public void addVisibleModelPart(ModelPart part, int color) {
        if (this.visibleParts == null) {
            this.visibleParts = new HashMap();
        }
        this.visibleParts.put(part, new ModelPartRenderTrace(part, color));
    }

    public ModelPartRenderTrace getModelPartRenderInfo(ModelPart part) {
        ModelPartRenderTrace mprdi;
        ModelPartRenderTrace modelPartRenderTrace = mprdi = this.visibleParts == null ? null : this.visibleParts.get(part);
        if (mprdi == null && this.allVisible) {
            mprdi = new ModelPartRenderTrace(part, this.color);
        }
        return mprdi;
    }

    public boolean isEmpty() {
        return !this.allVisible && (this.visibleParts == null || this.visibleParts.isEmpty());
    }

    public boolean sameVisibility(ModelRenderTrace other) {
        HashMap<ModelPart, ModelPartRenderTrace> otherVisibleParts;
        if (this.visibleParts == null != ((otherVisibleParts = other.visibleParts) == null)) {
            return false;
        }
        if (this.visibleParts == null) {
            return true;
        }
        if (this.visibleParts.size() != otherVisibleParts.size()) {
            return false;
        }
        Set<ModelPart> keySet = this.visibleParts.keySet();
        for (ModelPart key : keySet) {
            if (otherVisibleParts.containsKey(key)) continue;
            return false;
        }
        return true;
    }
}

