/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.IXaeroMinimap;
import xaero.hud.category.ui.EditorCategoryNodeConverter;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.category.ui.EditorEntityRadarCategoryNodeConverter;
import xaero.hud.minimap.radar.category.ui.node.EditorEntityRadarCategoryNode;
import xaero.hud.minimap.radar.category.ui.node.EditorEntityRadarCategorySettingsNode;
import xaero.lib.client.gui.config.EditConfigScreen;

public class GuiEntityRadarCategoryEditor
extends GuiCategoryEditor<EntityRadarCategory, EditorEntityRadarCategoryNode, EntityRadarCategory.Builder, EditorEntityRadarCategorySettingsNode<?>, EditorEntityRadarCategorySettingsNode.Builder, EditorEntityRadarCategoryNode.Builder> {
    public static final ITextComponent SERVER_ENFORCED_COMPONENT = new TextComponentTranslation("gui.xaero_entity_category_editor_server_enforced", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    private final EntityRadarCategoryManager entityRadarCategoryManager;
    private final boolean clientSide;
    private final Runnable onChange;
    private final boolean viewingEnforced;

    public GuiEntityRadarCategoryEditor(IXaeroMinimap modMain, EditConfigScreen parent, GuiScreen escape, Runnable onChange, boolean viewingEnforced) {
        super(modMain, (GuiScreen)parent, escape, (ITextComponent)new TextComponentTranslation("gui.xaero_entity_radar_categories", new Object[0]), EditorEntityRadarCategoryNodeConverter.Builder.begin().build(), viewingEnforced);
        this.entityRadarCategoryManager = modMain.getEntityRadarCategoryManager();
        this.clientSide = parent.getContext().isClientSide();
        this.onChange = onChange;
        this.viewingEnforced = viewingEnforced;
    }

    @Override
    protected EditorEntityRadarCategoryNode constructEditorData(EditorCategoryNodeConverter<EntityRadarCategory, EditorEntityRadarCategoryNode, EntityRadarCategory.Builder, EditorEntityRadarCategorySettingsNode<?>, EditorEntityRadarCategorySettingsNode.Builder, EditorEntityRadarCategoryNode.Builder> dataConverter) {
        EntityRadarCategory editedCategory = this.readOnly ? this.modMain.getEntityRadarCategoryManager().getSyncedRootCategory() : this.modMain.getEntityRadarCategoryManager().getEditedCategory();
        return dataConverter.convert(editedCategory, !this.readOnly && ((EditConfigScreen)this.parent).getContext().isClientSide());
    }

    @Override
    protected EditorEntityRadarCategoryNode constructDefaultData(EditorCategoryNodeConverter<EntityRadarCategory, EditorEntityRadarCategoryNode, EntityRadarCategory.Builder, EditorEntityRadarCategorySettingsNode<?>, EditorEntityRadarCategorySettingsNode.Builder, EditorEntityRadarCategoryNode.Builder> dataConverter) {
        this.modMain.getSettings().resetEntityRadarBackwardsCompatibilityConfig();
        EntityRadarCategory rootCategory = this.clientSide ? this.entityRadarCategoryManager.fetchDefaultClientCategory() : this.entityRadarCategoryManager.fetchDefaultServerCategory();
        return dataConverter.convert(rootCategory, this.clientSide);
    }

    @Override
    protected void onConfigConfirmed(EntityRadarCategory confirmedRootCategory) {
        this.entityRadarCategoryManager.storeEditedCategory(confirmedRootCategory, this.clientSide);
        this.onChange.run();
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        super.func_73863_a(i, j, f);
        if (this.viewingEnforced) {
            this.func_73732_a(this.field_146289_q, SERVER_ENFORCED_COMPONENT.func_150254_d(), this.field_146294_l / 2, 15, -1);
        }
    }
}

