/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.setting.ObjectCategorySetting;
import xaero.hud.category.ui.node.EditorCategoryNode;
import xaero.hud.category.ui.node.EditorSettingsNode;
import xaero.hud.category.ui.node.options.range.setting.IEditorSettingNode;

public abstract class EditorCategoryNodeConverter<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>> {
    private final Supplier<CB> categoryBuilderFactory;
    private final Supplier<EDB> editorNodeBuilderFactory;

    public EditorCategoryNodeConverter(@Nonnull Supplier<CB> categoryBuilderFactory, @Nonnull Supplier<EDB> editorNodeBuilderFactory) {
        this.categoryBuilderFactory = categoryBuilderFactory;
        this.editorNodeBuilderFactory = editorNodeBuilderFactory;
    }

    public ED convert(C category, boolean canBeRoot) {
        return (ED)((EditorCategoryNode.Builder)this.getConfiguredBuilder(category, canBeRoot)).build();
    }

    protected EDB getConfiguredBuilder(C category, final boolean canBeRoot) {
        final EditorCategoryNode.Builder editorNodeBuilder = (EditorCategoryNode.Builder)this.editorNodeBuilderFactory.get();
        editorNodeBuilder.setName(((ObjectCategory)category).getName());
        Object settingDataBuilder = editorNodeBuilder.getSettingDataBuilder();
        ((ObjectCategory)category).getSettingOverridesIterator().forEachRemaining(new Consumer<Map.Entry<ObjectCategorySetting<?>, Object>>((EditorSettingsNode.Builder)settingDataBuilder){
            final /* synthetic */ EditorSettingsNode.Builder val$settingDataBuilder;
            {
                this.val$settingDataBuilder = builder;
            }

            @Override
            public void accept(Map.Entry<ObjectCategorySetting<?>, Object> e) {
                EditorCategoryNodeConverter.this.setSettingValue((CB)this.val$settingDataBuilder, (ObjectCategorySetting<T>)e.getKey(), e.getValue());
            }
        });
        ((EditorSettingsNode.Builder)settingDataBuilder).setRootSettings(canBeRoot && ((ObjectCategory)category).getSuperCategory() == null);
        ((EditorSettingsNode.Builder)settingDataBuilder).setProtection(((ObjectCategory)category).getProtection());
        ((ObjectCategory)category).getDirectSubCategoryIterator().forEachRemaining(new Consumer<C>(){

            @Override
            public void accept(C sc) {
                editorNodeBuilder.addSubCategoryBuilder(EditorCategoryNodeConverter.this.getConfiguredBuilder(sc, canBeRoot));
            }
        });
        return (EDB)editorNodeBuilder;
    }

    private <T> void setSettingValue(SDB settingOverridesBuilder, ObjectCategorySetting<T> setting, Object value) {
        ((EditorSettingsNode.Builder)settingOverridesBuilder).setSettingValue(setting, (Object)value);
    }

    public C convert(ED editorData) {
        return ((ObjectCategory.Builder)this.getConfiguredBuilder(editorData)).build();
    }

    protected CB getConfiguredBuilder(ED editorNode) {
        final ObjectCategory.Builder categoryBuilder = (ObjectCategory.Builder)this.categoryBuilderFactory.get();
        categoryBuilder.setName(((EditorCategoryNode)editorNode).getName());
        categoryBuilder.setProtection(((EditorSettingsNode)((EditorCategoryNode)editorNode).getSettingsNode()).getProtection());
        ((EditorSettingsNode)((EditorCategoryNode)editorNode).getSettingsNode()).getSettings().forEach(new BiConsumer<ObjectCategorySetting<?>, IEditorSettingNode<?>>(){

            @Override
            public void accept(ObjectCategorySetting<?> k, IEditorSettingNode<?> d) {
                EditorCategoryNodeConverter.this.setSettingValue((CB)categoryBuilder, (ObjectCategorySetting<T>)k, d.getSettingValue());
            }
        });
        ((EditorCategoryNode)editorNode).getSubCategories().forEach(new Consumer<ED>(){

            @Override
            public void accept(ED sed) {
                categoryBuilder.addSubCategoryBuilder(EditorCategoryNodeConverter.this.getConfiguredBuilder(sed));
            }
        });
        return (CB)categoryBuilder;
    }

    private <T> void setSettingValue(CB categoryBuilder, ObjectCategorySetting<T> setting, Object value) {
        ((ObjectCategory.Builder)categoryBuilder).setSettingValue(setting, (Object)value);
    }

    public static abstract class Builder<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, CB extends ObjectCategory.Builder<C, CB>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends EditorCategoryNode.Builder<C, ED, SD, SDB, EDB>, B extends Builder<C, ED, CB, SD, SDB, EDB, B>> {
        protected final B self = this;
        protected final Supplier<CB> categoryBuilderFactory;
        protected final Supplier<EDB> editorDataBuilderFactory;

        protected Builder(Supplier<CB> categoryBuilderFactory, Supplier<EDB> editorDataBuilderFactory) {
            this.categoryBuilderFactory = categoryBuilderFactory;
            this.editorDataBuilderFactory = editorDataBuilderFactory;
        }

        protected B setDefault() {
            return this.self;
        }

        public EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> build() {
            return this.buildInternally();
        }

        protected abstract EditorCategoryNodeConverter<C, ED, CB, SD, SDB, EDB> buildInternally();
    }
}

