/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.config.option.value.redirect;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.common.HudMod;
import xaero.common.minimap.MinimapProcessor;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.lib.client.config.option.value.redirect.ClientOptionValueRedirectorManager;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.ConfigOption;

public class MinimapConfigOptionClientRedirectors {
    public static final ITextComponent LEGACY_PLUGIN_TOOLTIP = new TextComponentTranslation("gui.xaero_minimap_redirect_legacy", new Object[0]);
    public static final ITextComponent FAIRPLAY_TOOLTIP = new TextComponentTranslation("gui.xaero_config_redirect_fairplay", new Object[0]);
    public static final ITextComponent SAFE_MODE_TOOLTIP = new TextComponentTranslation("gui.xaero_config_redirect_safe_mode", new Object[0]);
    public static final ITextComponent EFFECT_TOOLTIP = new TextComponentTranslation("gui.xaero_config_redirect_effect", new Object[0]);
    public static final ITextComponent OLD_MINECRAFT_COMPONENT = new TextComponentTranslation("gui.xaero_old_minecraft", new Object[0]);
    public static final ITextComponent FROM_WORLDMAP_TOOLTIP = new TextComponentTranslation("gui.xaero_uses_worldmap_value", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    public static final ITextComponent HARD_WORLDMAP_TOOLTIP = new TextComponentTranslation("gui.xaero_uses_worldmap_hard_value", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    public static final ITextComponent FROM_WORLDMAP_SCREEN_TOOLTIP = new TextComponentTranslation("gui.xaero_uses_worldmap_screen_value", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
    public static final ITextComponent WORLD_MAP_COMPONENT = new TextComponentTranslation("gui.xaero_world_map", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));

    public static void registerAll(ClientOptionValueRedirectorManager manager) {
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_MINIMAP, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.getSettings().minimapDisabled() || Minecraft.func_71410_x().field_71439_g != null && !MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                if (HudMod.INSTANCE.getSettings().minimapDisabled()) {
                    return LEGACY_PLUGIN_TOOLTIP;
                }
                if (Minecraft.func_71410_x().field_71439_g != null && !MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    String minimapItemId = (String)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective(MinimapProfiledConfigOptions.MINIMAP_ITEM);
                    return new TextComponentTranslation("gui.xaero_minimap_redirect_item", new Object[]{minimapItemId});
                }
                return null;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_RADAR, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.isFairPlay();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FAIRPLAY_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.RADAR_DOTS_STYLE, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                return 1;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return !HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().assumeUsingFBO();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return SAFE_MODE_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.RADAR_SMOOTH_DOTS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return !HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().assumeUsingFBO();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return SAFE_MODE_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.RADAR_MAIN_DOT_SIZE, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                return 2;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return !HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().assumeUsingFBO();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return SAFE_MODE_TOOLTIP;
            }
        });
        Predicate<ConfigChannel> waypointDisableCondition = new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.getSettings().showWaypointsDisabled() || Minecraft.func_71410_x().field_71439_g != null && !MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
        };
        Supplier<ITextComponent> waypointDisableTooltipSupplier = new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                if (HudMod.INSTANCE.getSettings().showWaypointsDisabled()) {
                    return LEGACY_PLUGIN_TOOLTIP;
                }
                if (Minecraft.func_71410_x().field_71439_g != null && !MinimapProcessor.hasMinimapItem((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                    String minimapItemId = (String)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective(MinimapProfiledConfigOptions.MINIMAP_ITEM);
                    return new TextComponentTranslation("gui.xaero_minimap_redirect_item", new Object[]{minimapItemId});
                }
                return null;
            }
        };
        manager.register((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ON_MINIMAP, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)waypointDisableCondition, null, null, (Supplier)waypointDisableTooltipSupplier);
        manager.register((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_IN_WORLD, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)waypointDisableCondition, null, null, (Supplier)waypointDisableTooltipSupplier);
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DEATHPOINTS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.getSettings().deathpointsDisabled();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return LEGACY_PLUGIN_TOOLTIP;
            }
        });
        Function<GuiScreen, GuiScreen> worldMapSettingsScreenFactory = new Function<GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current) {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getSettingsScreen(current);
            }
        };
        manager.register((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_PARTIAL_Y_TELEPORT, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getPartialYTeleport();
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.getSupportMods().worldmap();
            }
        }, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        Predicate<ConfigChannel> shouldUseWorldMapChunksPredicate = new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.getSupportMods().shouldUseWorldMapChunks();
            }
        };
        manager.register((ConfigOption)MinimapProfiledConfigOptions.BLOCK_COLORS, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getWorldMapColours();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.BIOMES_IN_VANILLA_COLORS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getWorldMapBiomeColorsVanillaMode();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_ALLOWED, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return MinimapConfigClientUtils.isFairPlayForCaveMode() || HudMod.INSTANCE.getSettings().caveMapsDisabled() || MinimapConfigClientUtils.hasNoCaveModeEffect();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return MinimapConfigClientUtils.isFairPlayForCaveMode() ? FAIRPLAY_TOOLTIP : (HudMod.INSTANCE.getSettings().caveMapsDisabled() ? LEGACY_PLUGIN_TOOLTIP : EFFECT_TOOLTIP);
            }
        });
        manager.register(MinimapProfiledConfigOptions.MANUAL_CAVE_MODE_START, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getManualCaveStart();
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return HudMod.INSTANCE.getSupportMods().shouldUseWorldMapCaveChunks();
            }
        }, (Function)new Function<GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen currentScreen) {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getWorldMapScreenForOption((ConfigOption<?>)MinimapProfiledConfigOptions.MANUAL_CAVE_MODE_START, currentScreen);
            }
        }, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_SCREEN_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.BIOME_BLENDING, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getBiomeBlending();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.CAVE_MODE_DEPTH, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getCaveModeDepth();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.LEGIBLE_CAVE_MAPS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.isLegibleCaveMaps();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_WORLD_MAP_CHUNKS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return !HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().assumeUsingFBO();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return SAFE_MODE_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.TERRAIN_DEPTH, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getWorldMapTerrainDepth();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.TERRAIN_SLOPES, (Supplier)new Supplier<Integer>(){

            @Override
            public Integer get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getWorldMapTerrainSlopes();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_REDSTONE, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, null, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return HARD_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_FLOWERS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getWorldMapFlowers();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.DISPLAY_STAINED_GLASS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.isStainedGlassDisplayed();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return HudMod.INSTANCE.getSupportMods().worldmapSupport.getAdjustHeightForCarpetLikeBlocks();
            }
        }, (Predicate)shouldUseWorldMapChunksPredicate, (Function)worldMapSettingsScreenFactory, WORLD_MAP_COMPONENT, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return FROM_WORLDMAP_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.ANTI_ALIASING, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return !HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().assumeUsingFBO();
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return SAFE_MODE_TOOLTIP;
            }
        });
        manager.register((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_TELEPORT_CROSS_DIMENSION, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return false;
            }
        }, (Predicate)new Predicate<ConfigChannel>(){

            @Override
            public boolean test(ConfigChannel channel) {
                return true;
            }
        }, null, null, (Supplier)new Supplier<ITextComponent>(){

            @Override
            public ITextComponent get() {
                return OLD_MINECRAFT_COMPONENT;
            }
        });
    }
}

