/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import xaero.common.gui.GuiInfoDisplayEdit;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.common.config.util.ConfigConstants;

public final class InfoDisplayCycleButton
extends GuiActionButton {
    private int currentIndex;
    private final Consumer<GuiButton> action;

    private InfoDisplayCycleButton(int currentIndex, int x, int y, int w, int h, String message, Consumer<GuiButton> action) {
        super(x, y, w, h, message);
        this.currentIndex = currentIndex;
        this.action = action;
    }

    protected void onPress() {
        this.action.accept((GuiButton)this);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.press();
            return true;
        }
        return false;
    }

    public static final class Builder<T> {
        private int x;
        private int y;
        private int w;
        private int h;
        private List<T> values;
        private List<ITextComponent> valueNames;
        private GuiInfoDisplayEdit.MoveableEntry<T> entry;
        private Runnable onChange;
        private boolean includeNull;

        private Builder() {
        }

        public Builder<T> setDefault() {
            this.setBounds(0, 0, 0, 0);
            this.setValues(null, null);
            this.setEntry(null);
            this.setIncludeNull(false);
            return this;
        }

        public Builder<T> setBounds(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder<T> setValues(List<T> values, List<ITextComponent> valueNames) {
            if (values == null != (valueNames == null)) {
                throw new IllegalArgumentException();
            }
            if (values != null && values.size() != valueNames.size()) {
                throw new IllegalArgumentException();
            }
            this.values = values;
            this.valueNames = valueNames;
            return this;
        }

        public Builder<T> setEntry(GuiInfoDisplayEdit.MoveableEntry<T> entry) {
            this.entry = entry;
            return this;
        }

        public Builder<T> setOnChange(Runnable onChange) {
            this.onChange = onChange;
            return this;
        }

        public Builder<T> setIncludeNull(boolean includeNull) {
            this.includeNull = includeNull;
            return this;
        }

        public InfoDisplayCycleButton build() {
            int currentStateIndex;
            if (this.w == 0 || this.h == 0 || this.values == null || this.entry == null) {
                throw new IllegalStateException();
            }
            List<T> allValues = this.values;
            List<ITextComponent> allValueNames = this.valueNames;
            if (this.includeNull) {
                allValues = new ArrayList<T>(this.values);
                allValueNames = new ArrayList<ITextComponent>(this.valueNames);
                allValues.add(0, null);
                allValueNames.add(0, ConfigConstants.UNSPECIFIED);
            }
            if ((currentStateIndex = allValues.indexOf(this.entry.getState())) < 0) {
                this.entry.setState(allValues.get(0));
                currentStateIndex = 0;
            }
            final List<T> finalValues = allValues;
            final List<ITextComponent> finalValueNames = allValueNames;
            final GuiInfoDisplayEdit.MoveableEntry<T> finalEntry = this.entry;
            final Runnable finalOnChange = this.onChange;
            Consumer<GuiButton> action = new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    InfoDisplayCycleButton cycleButton = (InfoDisplayCycleButton)b;
                    if (GuiScreen.func_146272_n()) {
                        cycleButton.currentIndex--;
                        if (cycleButton.currentIndex < 0) {
                            cycleButton.currentIndex = finalValues.size() - 1;
                        }
                    } else {
                        cycleButton.currentIndex = (cycleButton.currentIndex + 1) % finalValues.size();
                    }
                    finalEntry.setState(finalValues.get(cycleButton.currentIndex));
                    cycleButton.field_146126_j = ((ITextComponent)finalValueNames.get(cycleButton.currentIndex)).func_150254_d();
                    if (finalOnChange != null) {
                        finalOnChange.run();
                    }
                }
            };
            return new InfoDisplayCycleButton(currentStateIndex, this.x, this.y, this.w, this.h, allValueNames.get(currentStateIndex).func_150254_d(), action);
        }

        public static <T> Builder<T> begin() {
            return new Builder<T>().setDefault();
        }
    }
}

