/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.category;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.PatternSyntaxException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xaero.common.HudMod;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;
import xaero.hud.category.rule.ObjectCategoryHardRule;
import xaero.hud.category.rule.ObjectCategoryListRuleType;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.PlaceholderEntityType;
import xaero.hud.minimap.radar.category.serialization.data.EntityRadarCategoryData;

public final class EntityRadarCategoryConstants {
    public static final String format = "\u00a7";
    public static final ListFactory LIST_FACTORY = new ListFactory(){

        @Override
        public <T> List<T> get() {
            return new ArrayList();
        }
    };
    public static final MapFactory MAP_FACTORY = new MapFactory(){

        @Override
        public <K, V> Map<K, V> get() {
            return new HashMap();
        }
    };
    public static final Path LEGACY_CONFIG_PATH = HudMod.INSTANCE.getPlatformContext().getConfigFolderPath().resolve("xaerominimap_entities.json");
    public static final Path LEGACY_DEFAULT_CONFIG_PATH = HudMod.INSTANCE.getPlatformContext().getDefaultConfigsFolderPath().resolve("xaerominimap_entities.json");
    public static final Supplier<EntityRadarCategoryData.Builder> DATA_BUILDER_FACTORY = new Supplier<EntityRadarCategoryData.Builder>(){

        @Override
        public EntityRadarCategoryData.Builder get() {
            return EntityRadarCategoryData.Builder.begin();
        }
    };
    public static final Supplier<EntityRadarCategory.Builder> CATEGORY_BUILDER_FACTORY = new Supplier<EntityRadarCategory.Builder>(){

        @Override
        public EntityRadarCategory.Builder get() {
            return EntityRadarCategory.Builder.begin();
        }
    };
    public static final PlaceholderEntityType PLAYER_ENTITY_ENTRY = new PlaceholderEntityType("minecraft:player");
    public static final Function<EntityEntry, String> DEFAULT_LIST_SERIALIZER = new Function<EntityEntry, String>(){

        @Override
        public String apply(EntityEntry t) {
            if (t == PLAYER_ENTITY_ENTRY) {
                return PLAYER_ENTITY_ENTRY.getHelpString();
            }
            return t.getRegistryName().toString();
        }
    };
    private static final Function<String, String> WILDCARD_TO_REGEX = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s.replaceAll("([\\.\\-\\:\\/\\^\\$\\?\\+\\[\\]\\{\\}])", "\\\\$1").replace("*", ".*");
        }
    };
    public static final EntityRadarCategoryData NULL_DATA = (EntityRadarCategoryData)((EntityRadarCategoryData.Builder)EntityRadarCategoryData.Builder.begin().setName("null")).build();
    public static final Predicate<String> DEFAULT_LIST_WILDCARD_VALIDATOR = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            try {
                "test string".matches((String)WILDCARD_TO_REGEX.apply(s));
                return true;
            }
            catch (PatternSyntaxException pse) {
                return false;
            }
        }
    };
    public static final Predicate<String> DEFAULT_LIST_STRING_VALIDATOR = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            if (EntityRadarCategoryConstants.isValidResourceLocation(s)) {
                return true;
            }
            return DEFAULT_LIST_WILDCARD_VALIDATOR.test(s);
        }
    };
    public static final Function<String, String> DEFAULT_LIST_STRING_VALIDATOR_FIXER = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    };
    private static final String PLAYER_NAME_LIST_ALLOWED_CHARS = "A-Za-z_0-9\\_";
    public static final Predicate<String> PLAYER_NAME_VALIDATOR = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return s.matches("[A-Za-z_0-9\\_]+");
        }
    };
    public static final Function<String, String> PLAYER_NAME_VALIDATOR_FIXER = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s.replaceAll("[^A-Za-z_0-9\\_]+", "");
        }
    };
    public static final Supplier<Iterable<Boolean>> PREDICATE_VALUE_ALL_SUPPLIER = new Supplier<Iterable<Boolean>>(){

        @Override
        public Iterable<Boolean> get() {
            return Lists.newArrayList((Object[])new Boolean[]{false, true});
        }
    };
    public static final Function<String, List<Boolean>> PREDICATE_VALUE_RESOLVER = new Function<String, List<Boolean>>(){

        @Override
        public List<Boolean> apply(String s) {
            return Lists.newArrayList((Object[])new Boolean[]{s.equalsIgnoreCase("yes")});
        }
    };
    public static final Function<Boolean, String> PREDICATE_VALUE_SERIALIZER = new Function<Boolean, String>(){

        @Override
        public String apply(Boolean b) {
            return b != false ? "yes" : "no";
        }
    };
    public static final Predicate<String> PREDICATE_VALUE_VALIDATOR = new Predicate<String>(){

        @Override
        public boolean test(String s) {
            return s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("no");
        }
    };
    public static final Function<String, String> PREDICATE_VALUE_VALIDATOR_FIXER = new Function<String, String>(){

        @Override
        public String apply(String s) {
            return s;
        }
    };
    public static final String CATEGORY_ROOT = "gui.xaero_entity_category_root";
    public static final String CATEGORY_LIVING = "gui.xaero_entity_category_living";
    public static final String CATEGORY_HOSTILE = "gui.xaero_entity_category_hostile";
    public static final String CATEGORY_FRIENDLY = "gui.xaero_entity_category_friendly";
    public static final String CATEGORY_HOSTILE_TAMED = "gui.xaero_entity_category_hostile_tamed";
    public static final String CATEGORY_FRIENDLY_TAMED = "gui.xaero_entity_category_friendly_tamed";
    public static final String CATEGORY_PLAYERS = "gui.xaero_entity_category_players";
    public static final String CATEGORY_FRIENDS = "gui.xaero_entity_category_friend";
    public static final String CATEGORY_TRACKED = "gui.xaero_entity_category_tracked";
    public static final String CATEGORY_SAME_TEAM = "gui.xaero_entity_category_same_team";
    public static final String CATEGORY_OTHER_TEAMS = "gui.xaero_entity_category_other_teams";
    public static final String CATEGORY_ITEMS = "gui.xaero_entity_category_items";
    public static final String CATEGORY_OTHER = "gui.xaero_entity_category_other_entities";
    public static final String HARD_NOTHING = "nothing";
    public static final String HARD_LIVING = "living";
    public static final String HARD_HOSTILE = "hostile";
    public static final String HARD_FRIENDLY = "friendly";
    public static final String HARD_TAMED = "tamed";
    public static final String HARD_PLAYERS = "players";
    public static final String HARD_SAME_TEAM = "same-team";
    public static final String HARD_OTHER_TEAMS = "other-teams";
    public static final String HARD_ITEMS = "items";
    public static final String HARD_ANYTHING = "anything";
    public static final String HARD_BABY = "baby";
    public static final String HARD_VANILLA = "vanilla";
    public static final String HARD_MODDED = "modded";
    public static final String HARD_ABOVE_GROUND = "above-ground";
    public static final String HARD_BELOW_GROUND = "below-ground";
    public static final String HARD_MY_GROUND = "my-ground";
    public static final String HARD_NOT_MY_GROUND = "not-my-ground";
    public static final String HARD_LIT = "block-lit";
    public static final String HARD_UNLIT = "block-unlit";
    public static final String HARD_CUSTOM_NAME = "has-custom-name";
    public static final String HARD_NO_CUSTOM_NAME = "no-custom-name";
    public static final String HARD_TRACKED = "tracked";
    public static final String HARD_IN_TEAM = "in-a-team";
    public static final String HARD_TEAMLESS = "teamless";

    public static <E extends IForgeRegistryEntry<E>> Function<String, List<E>> getDefaultElementResolver(final Iterable<E> all, final Function<String, E> keyToElement, final Function<E, ResourceLocation> elementToKey) {
        return new Function<String, List<E>>(){

            @Override
            public List<E> apply(String s) {
                boolean validResourceLocation;
                boolean bl = validResourceLocation = EntityRadarCategoryConstants.isValidResourceLocation(s) && !EntityRadarCategoryConstants.containsWildcardCharacters(s);
                if (validResourceLocation) {
                    IForgeRegistryEntry directReference = (IForgeRegistryEntry)keyToElement.apply(s);
                    if (directReference == null) {
                        return null;
                    }
                    return Lists.newArrayList((Object[])new IForgeRegistryEntry[]{directReference});
                }
                String regexPattern = (String)WILDCARD_TO_REGEX.apply(s);
                ArrayList<IForgeRegistryEntry> result = new ArrayList<IForgeRegistryEntry>();
                try {
                    for (IForgeRegistryEntry et : all) {
                        ResourceLocation entityTypeLocation = (ResourceLocation)elementToKey.apply(et);
                        if (entityTypeLocation == null || !entityTypeLocation.toString().matches(regexPattern)) continue;
                        result.add(et);
                    }
                }
                catch (PatternSyntaxException pse) {
                    return null;
                }
                return result;
            }
        };
    }

    private static boolean containsWildcardCharacters(String string) {
        return string.contains("(") || string.contains(")") || string.contains("|") || string.contains("*");
    }

    public static ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean> createHardRuleBasedPredicateListRuleType(final ObjectCategoryHardRule<Entity, EntityPlayer> hardRule, List<ObjectCategoryListRuleType<Entity, EntityPlayer, ?>> typeList, Map<String, ObjectCategoryListRuleType<Entity, EntityPlayer, ?>> typeMap) {
        return new ObjectCategoryListRuleType<Entity, EntityPlayer, Boolean>(hardRule.getName(), new BiFunction<Entity, EntityPlayer, Boolean>(){

            @Override
            public Boolean apply(Entity e, EntityPlayer p) {
                return hardRule.isFollowedBy(e, p);
            }
        }, PREDICATE_VALUE_ALL_SUPPLIER, PREDICATE_VALUE_RESOLVER, PREDICATE_VALUE_SERIALIZER, PREDICATE_VALUE_VALIDATOR_FIXER, PREDICATE_VALUE_VALIDATOR, typeList, typeMap);
    }

    private static String[] decompose(String location) {
        String[] split;
        if (!location.contains(":")) {
            location = "minecraft:" + location;
        }
        if ((split = location.split(":")).length == 2) {
            return split;
        }
        String[] result = new String[2];
        String string = result[0] = split.length < 2 ? "" : split[0];
        result[1] = split.length == 0 ? "" : (split.length < 2 ? split[0] : split[1]);
        return result;
    }

    public static boolean isValidResourceLocation(String location) {
        String[] strings = EntityRadarCategoryConstants.decompose(location);
        return !strings[0].isEmpty() && !strings[1].isEmpty() && strings[0].matches("[a-z0-9\\._\\-]+") && strings[1].matches("[a-z0-9\\/\\._\\-]+");
    }
}

