/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world.state;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import xaero.common.HudMod;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.config.primary.option.MinimapPrimaryClientConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.container.MinimapWorldContainer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.minimap.world.container.config.RootConfig;
import xaero.hud.minimap.world.state.MinimapWorldState;
import xaero.hud.path.XaeroPath;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;

public class MinimapWorldStateUpdater {
    public static final int ROOT_CONTAINER_FORMAT = 3;
    private final HudMod modMain;
    private final MinimapSession session;
    private final ClientPacketListener connection;
    private BlockPos currentWorldSpawn;

    public MinimapWorldStateUpdater(HudMod modMain, MinimapSession session, ClientPacketListener connection) {
        this.modMain = modMain;
        this.session = session;
        this.connection = connection;
    }

    public void init() {
        this.session.getWorldState().setAutoRootContainerPath(this.getAutoRootContainerPath(3));
        for (int i = 0; i < 3; ++i) {
            this.session.getWorldState().setOutdatedAutoRootContainerPath(i, this.getAutoRootContainerPath(i));
        }
    }

    @Deprecated
    public void update(MinimapSession session) {
        this.update();
    }

    public void update() {
        MinimapWorldState state = this.session.getWorldState();
        XaeroPath oldAutoWorldPath = state.getAutoWorldPath();
        XaeroPath potentialAutoContainerPath = this.getPotentialContainerPath();
        state.setAutoContainerPathIgnoreCaseCache(potentialAutoContainerPath);
        boolean worldmap = this.modMain.getSupportMods().worldmap();
        String potentialAutoWorldNode = this.getPotentialWorldNode((ResourceKey<Level>)this.session.getMc().f_91073_.m_46472_(), worldmap);
        if (potentialAutoWorldNode == null) {
            return;
        }
        XaeroPath autoWorldPath = potentialAutoContainerPath.resolve(potentialAutoWorldNode);
        state.setAutoWorldPath(autoWorldPath);
        if (oldAutoWorldPath != null && potentialAutoContainerPath.equals(oldAutoWorldPath.getParent())) {
            return;
        }
        MinimapWorldRootContainer autoRootContainer = this.session.getWorldManager().getAutoRootContainer();
        autoRootContainer.renameOldContainer(potentialAutoContainerPath);
        autoRootContainer.updateDimensionType(this.session.getMc().f_91073_);
        if (oldAutoWorldPath == null) {
            return;
        }
        MinimapWorldContainer oldContainer = this.session.getWorldManager().getWorldContainer(oldAutoWorldPath.getParent());
        oldContainer.getServerWaypointManager().clear();
    }

    @Deprecated
    public XaeroPath getPotentialContainerPath(MinimapSession session) {
        return this.getPotentialContainerPath();
    }

    public XaeroPath getPotentialContainerPath() {
        String dimensionNode = this.session.getDimensionHelper().getDimensionDirectoryName((ResourceKey<Level>)this.session.getMc().f_91073_.m_46472_());
        XaeroPath potentialContainerPath = this.session.getWorldState().getAutoRootContainerPath().resolve(dimensionNode);
        return this.ignoreContainerCase(potentialContainerPath, this.session.getWorldState().getAutoContainerPathIgnoreCaseCache());
    }

    @Deprecated
    public XaeroPath ignoreContainerCase(XaeroPath potentialContainerPath, XaeroPath currentPath, MinimapSession session) {
        return this.ignoreContainerCase(potentialContainerPath, currentPath);
    }

    public XaeroPath ignoreContainerCase(XaeroPath potentialContainerPath, XaeroPath currentPath) {
        if (potentialContainerPath.equals(currentPath)) {
            return currentPath;
        }
        for (MinimapWorldRootContainer rootContainer : this.session.getWorldManager().getRootContainers()) {
            XaeroPath containerSearch = rootContainer.fixPathCharacterCases(potentialContainerPath);
            if (containerSearch == null) continue;
            return containerSearch;
        }
        return potentialContainerPath;
    }

    @Deprecated
    public XaeroPath getAutoRootContainerPath(int version, ClientPacketListener connection, MinimapSession session) {
        return this.getAutoRootContainerPath(version);
    }

    public XaeroPath getAutoRootContainerPath(int version) {
        Object potentialContainerID;
        Minecraft mc = Minecraft.m_91087_();
        ServerData serverData = mc.m_91089_();
        if (mc.m_91092_() != null) {
            potentialContainerID = MinimapWorldContainerUtil.convertWorldFolderToContainerNode(mc.m_91092_().m_129843_(LevelResource.f_78182_).getParent().getFileName().toString(), version);
        } else if (mc.m_91294_() && this.modMain.getEvents().latestRealm != null) {
            potentialContainerID = "Realms_" + this.modMain.getEvents().latestRealm.f_87479_ + "." + this.modMain.getEvents().latestRealm.f_87473_;
        } else if (serverData != null) {
            ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
            SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
            boolean differentiateByServerAddress = (Boolean)primaryConfigManager.getEffective((ConfigOption)MinimapPrimaryClientConfigOptions.DIFFERENTIATE_BY_SERVER_ADDRESS);
            String serverIP = differentiateByServerAddress ? serverData.f_105363_ : "Any Address";
            int portDivider = version >= 1 && serverIP.indexOf(":") != serverIP.lastIndexOf(":") ? serverIP.lastIndexOf("]:") + 1 : serverIP.indexOf(":");
            if (portDivider > 0) {
                serverIP = serverIP.substring(0, portDivider);
            }
            while (serverIP.endsWith(".")) {
                serverIP = serverIP.substring(0, serverIP.length() - 1);
            }
            if (version >= 2) {
                serverIP = serverIP.replace("[", "").replace("]", "");
            }
            potentialContainerID = "Multiplayer_" + serverIP.replace(":", version < 3 ? "\u00a7" : ".").replace("_", "%us%").replace("/", "%fs%").replace("\\", "%bs%");
        } else {
            potentialContainerID = "Unknown";
        }
        XaeroPath potentialContainerPath = XaeroPath.root((String)potentialContainerID);
        potentialContainerPath = this.ignoreContainerCase(potentialContainerPath, null);
        return potentialContainerPath;
    }

    @Deprecated
    public String getPotentialWorldNode(ResourceKey<Level> dimId, boolean useWorldmap, MinimapSession session) {
        return this.getPotentialWorldNode(dimId, useWorldmap);
    }

    public String getPotentialWorldNode(ResourceKey<Level> dimId, boolean useWorldmap) {
        Object actualWorldNode;
        String worldmapWorldNode;
        if (this.session.getMc().m_91092_() != null) {
            return "waypoints";
        }
        MinimapWorldState state = this.session.getWorldState();
        MinimapWorldRootContainer rootContainer = this.session.getWorldManager().getRootWorldContainer(state.getAutoRootContainerPath());
        Object autoNodeBase = this.getAutoWorldNodeBase(rootContainer);
        if (autoNodeBase == null) {
            return null;
        }
        String string = worldmapWorldNode = useWorldmap ? this.modMain.getSupportMods().worldmapSupport.tryToGetMultiworldId(dimId) : null;
        if (useWorldmap && worldmapWorldNode == null) {
            return null;
        }
        if (autoNodeBase instanceof BlockPos) {
            BlockPos pos = (BlockPos)autoNodeBase;
            actualWorldNode = "mw" + (pos.m_123341_() >> 6) + "," + (pos.m_123342_() >> 6) + "," + (pos.m_123343_() >> 6);
            RootConfig config = rootContainer.getConfig();
            if (!config.isUsingMultiworldDetection()) {
                String defaultMultiworldId = config.getDefaultMultiworldId();
                if (defaultMultiworldId == null) {
                    config.setDefaultMultiworldId((String)actualWorldNode);
                    this.session.getWorldManagerIO().getRootConfigIO().save(rootContainer);
                } else {
                    actualWorldNode = defaultMultiworldId;
                }
            }
        } else {
            actualWorldNode = "mw$" + autoNodeBase;
        }
        if (useWorldmap && worldmapWorldNode != "minimap") {
            actualWorldNode = worldmapWorldNode;
        }
        return actualWorldNode;
    }

    public boolean hasServerLevelId(MinimapWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData.serverLevelId != null && !rootContainer.getConfig().isIgnoreServerLevelId();
    }

    public Object getAutoWorldNodeBase(MinimapWorldRootContainer rootContainer) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return this.hasServerLevelId(rootContainer) ? worldData.serverLevelId : this.currentWorldSpawn;
    }

    public void onServerLevelId(int id) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        worldData.serverLevelId = id;
        MinimapLogs.LOGGER.info("Minimap updated server level id: " + id + " for world " + Minecraft.m_91087_().f_91073_.m_46472_());
    }

    public void setCurrentWorldSpawn(BlockPos currentWorldSpawn) {
        this.currentWorldSpawn = currentWorldSpawn;
    }
}

