/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.common.config.util;

import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.platform.Services;

public class MinimapConfigUtils {
    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max, boolean includeAutoValue) {
        return MinimapConfigUtils.getUIScaleDisplayGetter(auto, max, 1.0, includeAutoValue);
    }

    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(final int auto, final int max, final double autoScale, final boolean includeAutoValue) {
        return new BiFunction<ConfigOption<Integer>, Integer, ITextComponent>(){

            @Override
            public ITextComponent apply(ConfigOption<Integer> o, Integer v) {
                if (v == auto) {
                    ITextComponent result = MinimapConfigConstants.AUTO_SCALE_COMPONENT.func_150259_f();
                    if (includeAutoValue && !Services.PLATFORM.isDedicatedServer()) {
                        MinimapConfigClientUtils.addAutoUIScaleValueToComponent(result, autoScale);
                    }
                    return result;
                }
                if (v == max) {
                    ITextComponent result = MinimapConfigConstants.MINECRAFT_SCALE_COMPONENT.func_150259_f();
                    if (!Services.PLATFORM.isDedicatedServer()) {
                        MinimapConfigClientUtils.addAutoMCScaleValueToComponent(result);
                    }
                    return result;
                }
                return new TextComponentString(v.toString());
            }
        };
    }

    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max) {
        return MinimapConfigUtils.getUIScaleDisplayGetter(auto, max, 1.0);
    }

    public static BiFunction<ConfigOption<Integer>, Integer, ITextComponent> getUIScaleDisplayGetter(int auto, int max, double autoScale) {
        return MinimapConfigUtils.getUIScaleDisplayGetter(auto, max, autoScale, true);
    }

    public static ITextComponent getAutoMinimapSizeName() {
        TextComponentTranslation component = new TextComponentTranslation("gui.xaero_auto_map_size", new Object[0]);
        if (!Services.PLATFORM.isDedicatedServer()) {
            component.func_150253_a().add(new TextComponentString(" (" + MinimapConfigClientUtils.getAutoMinimapSize(new ScaledResolution(Minecraft.func_71410_x()).func_78325_e()) + ")"));
        }
        return component;
    }
}

