/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.render.util;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderBufferUtil {
    public static void addColoredRect(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int w, int h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderBufferUtil.addColoredRect(matrix, vertexBuffer, x, y, w, h, r, g, b, a);
    }

    public static void addColoredRect(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int w, int h, float r, float g, float b, float a) {
        vertexBuffer.func_227888_a_(matrix, x, y + (float)h, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y + (float)h, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x, y, 0.0f).func_227885_a_(r, g, b, a).func_181675_d();
    }

    public static void addTexturedColoredRect(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int u, int v, int w, int h, float r, float g, float b, float a, float factor) {
        RenderBufferUtil.addTexturedColoredRect(matrix, vertexBuffer, x, y, u, v, w, h, w, h, r, g, b, a, factor);
    }

    public static void addTexturedColoredRect(Matrix4f matrix, IVertexBuilder vertexBuffer, float x, float y, int u, int v, int w, int h, int tw, int th, float r, float g, float b, float a, float factor) {
        float f = 1.0f / factor;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + tw) * f;
        float normalizedV2 = (float)(v + th) * f;
        vertexBuffer.func_227888_a_(matrix, x, y + (float)h, 0.0f).func_225583_a_(normalizedU1, normalizedV1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y + (float)h, 0.0f).func_225583_a_(normalizedU2, normalizedV1).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x + (float)w, y, 0.0f).func_225583_a_(normalizedU2, normalizedV2).func_227885_a_(r, g, b, a).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(normalizedU1, normalizedV2).func_227885_a_(r, g, b, a).func_181675_d();
    }
}

