/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.cache.id.armor;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import xaero.hud.minimap.radar.icon.cache.id.armor.RadarIconArmor;

public class RadarIconArmorHandler {
    public RadarIconArmor getArmor(LivingEntity livingEntity) {
        EquipmentSlot relevantArmourSlot = livingEntity instanceof Horse ? EquipmentSlot.CHEST : EquipmentSlot.HEAD;
        ItemStack armorItemStack = livingEntity.getItemBySlot(relevantArmourSlot);
        if (armorItemStack == null || armorItemStack == ItemStack.EMPTY) {
            return null;
        }
        Item armorItem = armorItemStack.getItem();
        if (armorItemStack.getTag() == null || !armorItemStack.is(ItemTags.TRIMMABLE_ARMOR)) {
            return new RadarIconArmor(armorItem, null, null);
        }
        if (!armorItemStack.getTag().contains("Trim", 10)) {
            return new RadarIconArmor(armorItem, null, null);
        }
        CompoundTag trimTag = armorItemStack.getTag().getCompound("Trim");
        if (trimTag.contains("material", 8) && trimTag.contains("pattern", 8)) {
            String trimMaterial = trimTag.getString("material");
            String trimPattern = trimTag.getString("pattern");
            return new RadarIconArmor(armorItem, trimMaterial, trimPattern);
        }
        return new RadarIconArmor(armorItem, "inline_material", "inline_pattern");
    }
}

