/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.network.CustomPayloadEvent;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class PacketConsumerForge<T extends WorldMapMessage<T>>
implements BiConsumer<T, CustomPayloadEvent.Context> {
    private final ServerMessageConsumer<T> serverHandler;
    private final ClientMessageConsumer<T> clientHandler;

    public PacketConsumerForge(ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler) {
        this.serverHandler = serverHandler;
        this.clientHandler = clientHandler;
    }

    @Override
    public void accept(T msg, CustomPayloadEvent.Context context) {
        if (msg == null) {
            context.setPacketHandled(true);
            return;
        }
        if (this.clientHandler != null && context.isClientSide()) {
            context.enqueueWork(() -> this.clientHandler.handle((WorldMapMessage)msg));
        } else if (this.serverHandler != null && context.isServerSide()) {
            ServerPlayer sender = context.getSender();
            context.enqueueWork(() -> this.serverHandler.handle(sender.level().getServer(), sender, (WorldMapMessage)msg));
        }
        context.setPacketHandled(true);
    }
}

