/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import xaero.map.WorldMapForge;
import xaero.map.message.PacketConsumerForge;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageHandler;
import xaero.map.message.client.ClientMessageConsumer;
import xaero.map.message.server.ServerMessageConsumer;

public class WorldMapMessageHandlerForge
extends WorldMapMessageHandler {
    @Override
    public <T extends WorldMapMessage<T>> void register(int index, Class<T> type, ServerMessageConsumer<T> serverHandler, ClientMessageConsumer<T> clientHandler, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, FriendlyByteBuf> encoder) {
        PacketConsumerForge<T> consumer = new PacketConsumerForge<T>(serverHandler, clientHandler);
        if (clientHandler == null != (serverHandler == null)) {
            WorldMapForge.network.messageBuilder(type, index, clientHandler == null ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT).consumerNetworkThread(consumer).decoder(decoder::apply).encoder(encoder::accept).add();
            return;
        }
        WorldMapForge.network.messageBuilder(type, index).consumerNetworkThread(consumer).decoder(decoder).encoder(encoder).add();
    }

    @Override
    public <T extends WorldMapMessage<T>> void sendToPlayer(ServerPlayer player, T message) {
        WorldMapForge.network.send(message, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public <T extends WorldMapMessage<T>> void sendToServer(T message) {
        WorldMapForge.network.send(message, PacketDistributor.SERVER.noArg());
    }
}

