/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.PlayerTeam;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.controls.IKeyBindingHelper;
import xaero.map.core.IGameRenderer;
import xaero.map.core.IGuiRenderer;
import xaero.map.gui.IScreenBase;
import xaero.map.mods.SupportMods;
import xaero.map.platform.Services;

public class Misc {
    private static final long[] ZERO_LONG_1024 = new long[1024];
    private static long cpuTimerPreTime;
    private static long glTimerPreTime;
    public static final String OUTDATED_FILE_EXT = ".outdated";

    public static int myFloor(double d) {
        int asInt = (int)d;
        if ((double)asInt != d && d < 0.0) {
            --asInt;
        }
        return asInt;
    }

    public static double round(double a, int komaarvu) {
        double x = Math.pow(10.0, komaarvu);
        return (double)Math.round(a * x) / x;
    }

    public static BlockState getStateById(int id) {
        try {
            return Block.stateById((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static BlockState getDefaultBlockStateForStateId(int id) {
        try {
            return Block.stateById((int)id).getBlock().defaultBlockState();
        }
        catch (Exception e) {
            return Blocks.AIR.defaultBlockState();
        }
    }

    public static void glTimerPre() {
        GL11.glFinish();
        glTimerPreTime = System.nanoTime();
    }

    public static int glTimerResult() {
        GL11.glFinish();
        return (int)(System.nanoTime() - glTimerPreTime);
    }

    public static void timerPre() {
        cpuTimerPreTime = System.nanoTime();
    }

    public static int timerResult() {
        return (int)(System.nanoTime() - cpuTimerPreTime);
    }

    public static double getMouseX(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.xpos();
        }
        return mc.mouseHandler.xpos() * (double)mc.getWindow().getWidth() / (double)mc.getWindow().getScreenWidth();
    }

    public static double getMouseY(Minecraft mc, boolean raw) {
        if (raw) {
            return mc.mouseHandler.ypos();
        }
        return mc.mouseHandler.ypos() * (double)mc.getWindow().getHeight() / (double)mc.getWindow().getScreenHeight();
    }

    public static void minecraftOrtho(Minecraft mc, boolean raw) {
        Window mainwindow = mc.getWindow();
        int width = raw ? mc.getWindow().getScreenWidth() : mainwindow.getWidth();
        int height = raw ? mc.getWindow().getScreenHeight() : mainwindow.getHeight();
        CachedOrthoProjectionMatrixBuffer guiProjectionCache = ((IGuiRenderer)((IGameRenderer)mc.gameRenderer).xaero_wm_getGuiRenderer()).xaero_wm_getGuiProjectionMatrixBuffer();
        GpuBufferSlice guiProjection = guiProjectionCache.getBuffer((float)width / (float)mainwindow.getGuiScale(), (float)height / (float)mainwindow.getGuiScale());
        RenderSystem.setProjectionMatrix((GpuBufferSlice)guiProjection, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
    }

    public static void clearHeightsData1024(long[] data) {
        System.arraycopy(ZERO_LONG_1024, 0, data, 0, 1024);
    }

    public static <T extends Comparable<? super T>> void addToListOfSmallest(int maxSize, List<T> list, T element) {
        int currentSize = list.size();
        if (currentSize == maxSize && ((Comparable)list.get(currentSize - 1)).compareTo(element) <= 0) {
            return;
        }
        int iterLimit = currentSize == maxSize ? maxSize : currentSize + 1;
        for (int i = 0; i < iterLimit; ++i) {
            if (i != currentSize && element.compareTo(list.get(i)) >= 0) continue;
            list.add(i, element);
            if (currentSize != maxSize) break;
            list.remove(currentSize);
            break;
        }
    }

    public static String getKeyName(KeyMapping kb) {
        if (kb == null || Services.PLATFORM.getKeyBindingHelper().getBoundKeyOf(kb).getValue() == -1) {
            return "(unset)";
        }
        return kb.getTranslatedKeyMessage().getString().toUpperCase();
    }

    public static boolean inputMatchesKeyBinding(InputConstants.Type type, int code, KeyMapping kb, int keyConflictContext) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        return kb != null && code != -1 && keyBindingHelper.getBoundKeyOf(kb).getType() == type && keyBindingHelper.getBoundKeyOf(kb).getValue() == code && keyBindingHelper.modifiersAreActive(kb, keyConflictContext);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        Misc.deleteFileIf(file, path -> true, attempts);
    }

    public static void deleteFileIf(Path file, final Predicate<Path> condition, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (condition.test(path)) {
                        Files.delete(path);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (condition.test(path)) {
                        Files.delete(path);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFileIf(file, condition, attempts);
            }
            throw e;
        }
    }

    public static Path convertToOutdated(Path path, int attempts) throws IOException {
        if (path.getFileName().toString().endsWith(OUTDATED_FILE_EXT)) {
            return path;
        }
        Path outdatedPath = path.resolveSibling(path.getFileName().toString() + OUTDATED_FILE_EXT);
        if (Files.exists(path, new LinkOption[0])) {
            Misc.convertToOutdated(path, outdatedPath, attempts);
        }
        return outdatedPath;
    }

    private static void convertToOutdated(Path path, Path outdatedPath, int attempts) throws IOException {
        --attempts;
        try {
            Files.move(path, outdatedPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to convert file to outdated! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.convertToOutdated(path, outdatedPath, attempts);
            }
            throw e;
        }
    }

    public static boolean screenShouldSkipWorldRender(Screen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && SupportMods.minimap() && SupportMods.xaeroMinimap.screenShouldSkipWorldRender(screen);
    }

    public static void drawNormalText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public static void drawPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Minecraft.getInstance().font.drawInBatch(name, x, y, color, shadow, matrices.last().pose(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, String name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(PoseStack matrices, Component name, float x, float y, int color, boolean shadow, MultiBufferSource.BufferSource renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.getInstance().font.width((FormattedText)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static boolean hasItem(Player player, Item item) {
        int i;
        Inventory inventory = player.getInventory();
        for (i = 0; i < 9; ++i) {
            if (inventory.getItem(i).getItem() != item) continue;
            return true;
        }
        for (i = 36; i < inventory.getContainerSize(); ++i) {
            if (inventory.getItem(i).getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).getItem() != item) continue;
            return true;
        }
        return false;
    }

    public static int getTeamColour(Entity e) {
        Integer teamColour = null;
        PlayerTeam team = e.getTeam();
        if (team != null) {
            teamColour = team.getColor().getColor();
        }
        return teamColour == null ? -1 : teamColour;
    }

    public static void setFieldText(EditBox field, String text) {
        Misc.setFieldText(field, text, -1);
    }

    public static void setFieldText(EditBox field, String text, int color) {
        field.setTextColor(color);
        if (field.getValue().equals(text)) {
            return;
        }
        field.setValue(text);
    }

    public static Class<?> getClassForName(String obfuscatedName, String deobfName) throws ClassNotFoundException {
        return Services.PLATFORM.getObfuscatedFieldReflection().getClassForName(obfuscatedName, deobfName);
    }

    public static Field getFieldReflection(Class<?> c, String deobfName, String obfuscatedNameFabric, String descriptor, String obfuscatedNameForge) {
        return Services.PLATFORM.getObfuscatedFieldReflection().getFieldReflection(c, deobfName, obfuscatedNameFabric, descriptor, obfuscatedNameForge);
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static <A, B> void setReflectFieldValue(A parentObject, Field field, B value) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        try {
            field.set(parentObject, value);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
    }

    public static Method getMethodReflection(Class<?> c, String deobfName, String obfuscatedNameFabric, String descriptor, String obfuscatedNameForge, Class<?> ... parameters) {
        return Services.PLATFORM.getObfuscatedFieldReflection().getMethodReflection(c, deobfName, obfuscatedNameFabric, descriptor, obfuscatedNameForge, parameters);
    }

    public static <A, B> B getReflectMethodValue(A parentObject, Method method, Object ... arguments) {
        boolean accessibleBU = method.isAccessible();
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(parentObject, arguments);
        }
        catch (Exception e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        method.setAccessible(accessibleBU);
        return (B)result;
    }

    public static boolean hasEffect(Player player, Holder<MobEffect> effect) {
        return effect != null && player.hasEffect(effect);
    }

    public static boolean hasEffect(Holder<MobEffect> effect) {
        return Misc.hasEffect((Player)Minecraft.getInstance().player, effect);
    }
}

