/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import org.joml.Matrix4fStack;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.GpuTextureAndView;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.TextureUtils;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO;
    private GpuTextureAndView glEmptyTexture;
    private PoseStack matrixStack = new PoseStack();
    private GpuBufferSlice projectionMatrix;
    private MultiTextureRenderTypeRendererProvider rendererProvider;

    public BranchTextureRenderer() {
        CachedOrthoProjectionMatrixBuffer orthoProjectionCache = new CachedOrthoProjectionMatrixBuffer("branch renderer", -1.0f, 1.0f, true);
        this.projectionMatrix = orthoProjectionCache.getBuffer(64.0f, 64.0f);
        this.rendererProvider = new MultiTextureRenderTypeRendererProvider(1);
    }

    public GpuTextureAndView getEmptyTexture() {
        this.ensureRenderTarget();
        return this.glEmptyTexture;
    }

    private void ensureRenderTarget() {
        if (this.renderFBO == null) {
            this.renderFBO = new ImprovedFramebuffer(64, 64, false);
            this.glEmptyTexture = new GpuTextureAndView(this.renderFBO.getColorTexture(), this.renderFBO.getColorTextureView());
            TextureUtils.clearRenderTarget((RenderTarget)this.renderFBO, -16777216);
        }
    }

    public void render(GpuTextureAndView destTexture, GpuTextureAndView srcTextureTopLeft, GpuTextureAndView srcTextureTopRight, GpuTextureAndView srcTextureBottomLeft, GpuTextureAndView srcTextureBottomRight, RenderTarget defaultFramebuffer, boolean justAllocated) {
        this.ensureRenderTarget();
        this.renderFBO.bindAsMainTarget(true);
        this.renderFBO.setColorTexture(destTexture.texture, destTexture.view);
        OpenGLException.checkGLError();
        Matrix4fStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.pushMatrix();
        shaderMatrixStack.identity();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrix, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        if (justAllocated) {
            TextureUtils.clearRenderTarget((RenderTarget)this.renderFBO, -16777216);
        }
        MultiTextureRenderTypeRenderer renderer = this.rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP_BRANCH);
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0, renderer);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0, renderer);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1, renderer);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1, renderer);
        }
        this.rendererProvider.draw(renderer);
        OpenGLException.checkGLError(false, "updating a map branch texture");
        shaderMatrixStack.popMatrix();
        Minecraft mc = Minecraft.getInstance();
        Misc.minecraftOrtho(mc, false);
        this.renderFBO.bindDefaultFramebuffer(mc);
        OpenGLException.checkGLError();
    }

    private boolean renderCorner(GpuTextureAndView srcTexture, int cornerX, int cornerY, MultiTextureRenderTypeRenderer renderer) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        MapRenderHelper.renderBranchUpdate(srcTexture.texture, xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f, renderer);
        return false;
    }

    public GpuTextureAndView getGlEmptyTexture() {
        return this.glEmptyTexture;
    }
}

