/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import xaero.map.WorldMap;
import xaero.map.graphics.ImprovedCompositeRenderType;
import xaero.map.graphics.shader.BuiltInCustomUniforms;
import xaero.map.graphics.shader.MapShaders;
import xaero.map.misc.Misc;

public class CustomRenderTypes
extends RenderType {
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    protected static final BlendFunction TRANSLUCENT_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction DEST_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction PREMULTIPLIED_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction ADD_ALPHA_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE);
    public static final RenderPipeline RP_POSITION_COLOR_TEX;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_NO_CULL;
    public static final RenderPipeline RP_POSITION_COLOR;
    public static final RenderPipeline RP_POSITION_COLOR_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_NO_CULL;
    public static final RenderPipeline RP_MAP_BRANCH;
    public static final RenderType GUI;
    public static final RenderType GUI_PREMULTIPLIED;
    public static final RenderType MAP;
    public static final RenderType MAP_BRANCH;
    public static final RenderType MAP_COLOR_OVERLAY;
    public static final RenderType MAP_FRAME;
    public static final RenderType MAP_COLOR_FILLER;
    public static final RenderType MAP_ELEMENT_TEXT_BG;
    private static final Method compositeStateBuilderMethod;
    private static final Method compositeStateBuilderCreateCompositeStateMethod;
    private static final Method compositeStateBuilderSetTextureStateMethod;
    private static final Method compositeStateBuilderSetLightmapStateMethod;
    private static final Method compositeStateBuilderSetOverlayStateMethod;
    private static final Method compositeStateBuilderSetLayeringStateMethod;
    private static final Method compositeStateBuilderSetOutputStateMethod;
    private static final Method compositeStateBuilderSetTexturingStateMethod;
    private static final Method compositeStateBuilderSetLineStateMethod;
    private static final Method renderTypeCreateMethod;

    private CustomRenderTypes(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable startAction, Runnable endAction) {
        super(name, bufferSize, affectsCrumbling, sortOnUpload, startAction, endAction);
    }

    public void draw(MeshData var1) {
        throw new IllegalAccessError();
    }

    public VertexFormat format() {
        throw new IllegalAccessError();
    }

    public VertexFormat.Mode mode() {
        throw new IllegalAccessError();
    }

    public RenderPipeline pipeline() {
        throw new IllegalAccessError();
    }

    private static CustomStateBuilder getStateBuilder() {
        return new CustomStateBuilder((RenderType.CompositeState.CompositeStateBuilder)Misc.getReflectMethodValue(null, compositeStateBuilderMethod, new Object[0]));
    }

    private static RenderType createRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, CustomStateBuilder stateBuilder, RenderType.OutlineProperty outlineProperty) {
        RenderType.CompositeState compositeState = stateBuilder.createCompositeState(outlineProperty);
        RenderType normalRenderType = (RenderType)Misc.getReflectMethodValue(null, renderTypeCreateMethod, name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, compositeState);
        return new ImprovedCompositeRenderType(name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, stateBuilder.getOutputState(), compositeState, normalRenderType);
    }

    public static RenderTarget getOutputStateTarget(Object outputStateShard) {
        return ((RenderStateShard.OutputStateShard)outputStateShard).getRenderTarget();
    }

    static {
        try {
            Class<?> compositeStateClass = Misc.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            compositeStateBuilderMethod = Misc.getMethodReflection(compositeStateClass, "builder", "method_23598", "()Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110628_", new Class[0]);
            compositeStateBuilderCreateCompositeStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "createCompositeState", "method_24297", "(Lnet/minecraft/class_1921$class_4750;)Lnet/minecraft/class_1921$class_4688;", "m_110689_", RenderType.OutlineProperty.class);
            compositeStateBuilderSetTextureStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setTextureState", "method_34577", "(Lnet/minecraft/class_4668$class_5939;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_173290_", RenderStateShard.EmptyTextureStateShard.class);
            compositeStateBuilderSetLightmapStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLightmapState", "method_23608", "(Lnet/minecraft/class_4668$class_4676;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110671_", RenderStateShard.LightmapStateShard.class);
            compositeStateBuilderSetOverlayStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setOverlayState", "method_23611", "(Lnet/minecraft/class_4668$class_4679;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110677_", RenderStateShard.OverlayStateShard.class);
            compositeStateBuilderSetLayeringStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLayeringState", "method_23607", "(Lnet/minecraft/class_4668$class_4675;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110669_", RenderStateShard.LayeringStateShard.class);
            compositeStateBuilderSetOutputStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setOutputState", "method_23610", "(Lnet/minecraft/class_4668$class_4678;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110675_", RenderStateShard.OutputStateShard.class);
            compositeStateBuilderSetTexturingStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setTexturingState", "method_23614", "(Lnet/minecraft/class_4668$class_4684;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110683_", RenderStateShard.TexturingStateShard.class);
            compositeStateBuilderSetLineStateMethod = Misc.getMethodReflection(RenderType.CompositeState.CompositeStateBuilder.class, "setLineState", "method_23609", "(Lnet/minecraft/class_4668$class_4677;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110673_", RenderStateShard.LineStateShard.class);
            renderTypeCreateMethod = Misc.getMethodReflection(RenderType.class, "create", "method_24049", "(Ljava/lang/String;IZZLcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/class_1921$class_4688;)Lnet/minecraft/class_1921$class_4687;", "m_173215_", String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, RenderPipeline.class, RenderType.CompositeState.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        RenderPipeline.Snippet MATRICES_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withUniform("DynamicTransforms", UniformType.UNIFORM_BUFFER).withUniform("Projection", UniformType.UNIFORM_BUFFER).buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_TEX_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(MapShaders.POSITION_COLOR_TEX).withFragmentShader(MapShaders.POSITION_COLOR_TEX).withVertexFormat(POSITION_COLOR_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(MapShaders.POSITION_COLOR).withFragmentShader(MapShaders.POSITION_COLOR).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RP_POSITION_COLOR_TEX = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col_tex")).withBlend(TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_TEX_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col_tex_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_TEX_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col_tex_no_cull")).withBlend(TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col")).withBlend(TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col_no_cull")).withBlend(TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_MAP_BRANCH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/map_branch")).withVertexShader(MapShaders.WORLD_MAP_BRANCH).withFragmentShader(MapShaders.WORLD_MAP_BRANCH).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").withoutBlend().withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build();
        GUI = CustomRenderTypes.createRenderType("xaero_wm_gui", 786432, false, false, RP_POSITION_COLOR_TEX_NO_CULL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline POSITION_COLOR_TEX_PREMULTIPLIED_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/pos_col_tex_premultiplied")).withBlend(PREMULTIPLIED_TRANSPARENCY).withCull(false).build();
        GUI_PREMULTIPLIED = CustomRenderTypes.createRenderType("xaero_wm_gui_pre", 786432, false, false, POSITION_COLOR_TEX_PREMULTIPLIED_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline MAP_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/map")).withVertexShader(MapShaders.WORLD_MAP).withFragmentShader(MapShaders.WORLD_MAP).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").withUniform(BuiltInCustomUniforms.BRIGHTNESS.name(), BuiltInCustomUniforms.BRIGHTNESS.type()).withUniform(BuiltInCustomUniforms.WITH_LIGHT.name(), BuiltInCustomUniforms.WITH_LIGHT.type()).withBlend(DEST_TRANSPARENCY).withCull(false).build();
        MAP = CustomRenderTypes.createRenderType("xaero_wm_map_with_light", 786432, false, false, MAP_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        MAP_BRANCH = CustomRenderTypes.createRenderType("xaero_wm_map_branch", 1536, false, false, RP_MAP_BRANCH, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        MAP_COLOR_OVERLAY = CustomRenderTypes.createRenderType("xaero_wm_world_map_overlay", 786432, false, false, RP_POSITION_COLOR_NO_CULL, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline MAP_FRAME_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/map_frame")).withBlend(DEST_TRANSPARENCY).withCull(false).withDepthWrite(false).build();
        MAP_FRAME = CustomRenderTypes.createRenderType("xaero_wm_frame_texture", 1536, false, false, MAP_FRAME_PL, CustomRenderTypes.getStateBuilder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(WorldMap.guiTextures, false)).setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        RenderPipeline COLOR_FILLER_PL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(ResourceLocation.fromNamespaceAndPath((String)"xaeroworldmap", (String)"pipeline/color_filler")).withBlend(TRANSLUCENT_TRANSPARENCY).withDepthWrite(false).build();
        MAP_COLOR_FILLER = CustomRenderTypes.createRenderType("xaero_wm_world_map_filler", 1536, false, false, COLOR_FILLER_PL, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
        MAP_ELEMENT_TEXT_BG = CustomRenderTypes.createRenderType("xaero_wm_world_map_waypoint_name_bg", 786432, false, false, RP_POSITION_COLOR, CustomRenderTypes.getStateBuilder().setOutputState(RenderStateShard.MAIN_TARGET), RenderType.OutlineProperty.NONE);
    }

    private static final class CustomStateBuilder {
        private final RenderType.CompositeState.CompositeStateBuilder original;
        private RenderStateShard.OutputStateShard outputState = RenderStateShard.MAIN_TARGET;

        private CustomStateBuilder(RenderType.CompositeState.CompositeStateBuilder original) {
            this.original = original;
        }

        private CustomStateBuilder setTextureState(RenderStateShard.EmptyTextureStateShard textureState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetTextureStateMethod, textureState);
            return this;
        }

        private CustomStateBuilder setLightmapState(RenderStateShard.LightmapStateShard lightmapState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetLightmapStateMethod, lightmapState);
            return this;
        }

        private CustomStateBuilder setOverlayState(RenderStateShard.OverlayStateShard overlayState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetOverlayStateMethod, overlayState);
            return this;
        }

        private CustomStateBuilder setLayeringState(RenderStateShard.LayeringStateShard layeringState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetLayeringStateMethod, layeringState);
            return this;
        }

        private CustomStateBuilder setOutputState(RenderStateShard.OutputStateShard outputState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetOutputStateMethod, outputState);
            this.outputState = outputState;
            return this;
        }

        private CustomStateBuilder setTexturingState(RenderStateShard.TexturingStateShard texturingState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetTexturingStateMethod, texturingState);
            return this;
        }

        private CustomStateBuilder setLineState(RenderStateShard.LineStateShard lineState) {
            Misc.getReflectMethodValue(this.original, compositeStateBuilderSetLineStateMethod, lineState);
            return this;
        }

        public RenderStateShard.OutputStateShard getOutputState() {
            return this.outputState;
        }

        private RenderType.CompositeState createCompositeState(RenderType.OutlineProperty outlineProperty) {
            return (RenderType.CompositeState)Misc.getReflectMethodValue(this.original, compositeStateBuilderCreateCompositeStateMethod, outlineProperty);
        }
    }
}

