/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.ConfigSettingEntry;
import xaero.map.gui.ISettingEntry;
import xaero.map.gui.MyTinyButton;
import xaero.map.gui.ScreenBase;
import xaero.map.misc.KeySortableByOther;
import xaero.map.misc.Misc;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

public abstract class GuiSettings
extends ScreenBase {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected Component screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    private EditBox searchField;
    protected boolean canSearch = true;
    protected boolean shouldAddBackButton = true;
    private boolean shouldRefocusSearch;

    public GuiSettings(Component title, Screen backScreen, Screen escScreen) {
        super(backScreen, escScreen, title);
    }

    @Override
    public void init() {
        int verticalOffset;
        super.init();
        this.screenTitle = this.title;
        if (this.shouldAddBackButton) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.xaero_back", (Object[])new Object[0]), b -> this.goBack()).bounds(this.width / 2 - 100, this.height / 6 + 168, 200, 20).build());
        }
        int n = verticalOffset = this.canSearch ? 24 : 0;
        if (this.entries != null) {
            boolean canEditIngameSettings = ModSettings.canEditIngameSettings();
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    AbstractWidget optionWidget = entry.createWidget(this.width / 2 - 205 + i % 2 * 210, this.height / 7 + verticalOffset + 24 * (i >> 1), 200, canEditIngameSettings);
                    this.addRenderableWidget((GuiEventListener)optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.plainCopy().append(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.width / 2 + 131, this.height / 7 + 144 + verticalOffset, (Component)Component.translatable((String)"gui.xaero_wm_next", (Object[])new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.width / 2 - 205, this.height / 7 + 144 + verticalOffset, (Component)Component.translatable((String)"gui.xaero_wm_previous", (Object[])new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.addRenderableWidget((GuiEventListener)this.nextButton);
            this.addRenderableWidget((GuiEventListener)this.prevButton);
            this.nextButton.active = this.page < this.maxPage;
            boolean bl = this.prevButton.active = this.page > 0;
        }
        if (this.canSearch) {
            boolean shouldFocusSearch = this.shouldRefocusSearch;
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.getCursorPosition();
            }
            this.searchField = new EditBox(this.font, this.width / 2 - 100, this.height / 7, 200, 20, (Component)Component.translatable((String)"gui.xaero_wm_settings_search"));
            this.searchField.setValue(this.entryFilter);
            if (shouldFocusSearch) {
                this.setFocused((GuiEventListener)this.searchField);
                this.searchField.setCursorPosition(cursorPos);
                this.searchField.setHighlightPos(cursorPos);
            }
            this.searchField.setResponder(s -> {
                if (this.canSearch) {
                    this.updateSearch();
                }
            });
            this.addWidget(this.searchField);
        }
    }

    protected void setInitialFocus() {
        if (this.canSearch && this.shouldRefocusSearch) {
            this.shouldRefocusSearch = false;
            return;
        }
        super.setInitialFocus();
    }

    public void tick() {
        super.tick();
        if (this.canSearch) {
            // empty if block
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderBackground(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.minecraft.font, this.screenTitle, this.width / 2, 5, -1);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        super.render(guiGraphics, par1, par2, par3);
        if (this.canSearch) {
            if (!this.foundSomething) {
                guiGraphics.drawCenteredString(this.minecraft.font, I18n.get((String)"gui.xaero_wm_settings_not_found", (Object[])new Object[0]), this.width / 2, this.height / 7 + 29, -1);
            }
            if (!this.searchField.isFocused() && this.searchField.getValue().isEmpty()) {
                Misc.setFieldText(this.searchField, I18n.get((String)"gui.xaero_wm_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.moveCursorTo(0, false);
            }
            this.searchField.render(guiGraphics, par1, par2, par3);
            if (!this.searchField.isFocused()) {
                Misc.setFieldText(this.searchField, this.entryFilter);
            }
        }
        this.renderTooltips(guiGraphics, par1, par2, par3);
    }

    public void restoreFocus(int index) {
        if (index != -1) {
            try {
                GuiEventListener child = (GuiEventListener)this.children().get(index);
                this.setFocused(child);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int getIndex(GuiEventListener child) {
        for (int i = 0; i < this.children().size(); ++i) {
            if (this.children().get(i) != child) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void onExit(Screen screen) {
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        super.onExit(screen);
    }

    public boolean keyPressed(KeyEvent event) {
        int par1 = event.key();
        int par2 = event.scancode();
        if (!(super.keyPressed(event) || this.getFocused() instanceof EditBox && ((EditBox)this.getFocused()).isFocused())) {
            if (Misc.inputMatchesKeyBinding(par1 != -1 ? InputConstants.Type.KEYSYM : InputConstants.Type.SCANCODE, par1 != -1 ? par1 : par2, ControlsRegister.keyOpenSettings, 0)) {
                this.onClose();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean charTyped(CharacterEvent event) {
        boolean result = super.charTyped(event);
        return result;
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (!super.mouseClicked(event, doubleClick)) {
            if (Misc.inputMatchesKeyBinding(InputConstants.Type.MOUSE, event.button(), ControlsRegister.keyOpenSettings, 0)) {
                this.goBack();
                return true;
            }
            return false;
        }
        return true;
    }

    protected void onNextButton() {
        ++this.page;
        this.init(this.minecraft, this.width, this.height);
    }

    protected void onPrevButton() {
        --this.page;
        this.init(this.minecraft, this.width, this.height);
    }

    protected static ISettingEntry[] entriesFromOptions(ModOptions[] options) {
        ISettingEntry[] result = new ISettingEntry[options.length];
        for (int i = 0; i < options.length; ++i) {
            result[i] = new ConfigSettingEntry(options[i]);
        }
        return result;
    }

    protected void resetConfirmResult(boolean result, Screen parent, Screen escScreen) {
        if (result) {
            WorldMapSession minimapSession = WorldMapSession.getCurrentSession();
            if (minimapSession != null) {
                // empty if block
            }
            try {
                WorldMap.settings = new ModSettings();
                WorldMap.settings.saveSettings();
            }
            catch (IOException e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            WorldMap.settings.updateRegionCacheHashCode();
        }
        Minecraft.getInstance().setScreen(parent);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.isFocused() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.getValue()))) {
            this.entryFilter = this.searchField.getValue();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.init(this.minecraft, this.width, this.height);
        }
    }
}

