/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.platform.services;

import java.nio.file.Path;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import xaero.map.controls.IKeyBindingHelper;
import xaero.map.controls.KeyBindingHelperNeoForge;
import xaero.map.misc.IObfuscatedReflection;
import xaero.map.misc.ObfuscatedReflectionNeoForge;
import xaero.map.platform.services.IPlatformHelper;
import xaero.map.render.util.IPlatformRenderDeviceUtil;
import xaero.map.render.util.IPlatformRenderUtil;
import xaero.map.render.util.NeoforgeRenderDeviceUtil;
import xaero.map.render.util.NeoforgeRenderUtil;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    private final ObfuscatedReflectionNeoForge obfuscatedReflectionNeoForge = new ObfuscatedReflectionNeoForge();
    private final KeyBindingHelperNeoForge keyBindingHelperNeoForge = new KeyBindingHelperNeoForge();
    private final NeoforgeRenderUtil neoforgeRenderUtil = new NeoforgeRenderUtil();
    private final NeoforgeRenderDeviceUtil neoforgeRenderDeviceUtil = new NeoforgeRenderDeviceUtil();

    @Override
    public String getPlatformName() {
        return "NeoForge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean checkModForMixin(String modId) {
        return FMLLoader.getCurrent().getLoadingModList().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLEnvironment.isProduction();
    }

    @Override
    public IObfuscatedReflection getObfuscatedFieldReflection() {
        return this.obfuscatedReflectionNeoForge;
    }

    @Override
    public IKeyBindingHelper getKeyBindingHelper() {
        return this.keyBindingHelperNeoForge;
    }

    @Override
    public IPlatformRenderUtil getPlatformRenderUtil() {
        return this.neoforgeRenderUtil;
    }

    @Override
    public IPlatformRenderDeviceUtil getPlatformRenderDeviceUtil() {
        return this.neoforgeRenderDeviceUtil;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLEnvironment.getDist() == Dist.DEDICATED_SERVER;
    }

    @Override
    public Path getGameDir() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }
}

