/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.action.ConnectingToRealmsAction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.lib.patreon.Patreon;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;

public class ClientEvents {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                ConnectingToRealmsAction realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = ReflectionUtils.getFieldReflection(RealmsLongRunningMcoTaskScreen.class, (String)"task", (String)"", (String)"", (String)"field_224248_l");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = ReflectionUtils.getFieldReflection(ConnectingToRealmsAction.class, (String)"server", (String)"", (String)"", (String)"field_238116_c_");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getGui())) instanceof ConnectingToRealmsAction && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (ConnectingToRealmsAction)task)) != null && (this.latestRealm == null || realm.field_230582_a_ != this.latestRealm.field_230582_a_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    public boolean handleRenderTick(boolean start) {
        WorldMapSession worldmapSession;
        if (!WorldMap.loaded) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!start) {
            WorldMap.glObjectDeleter.work();
        }
        boolean shouldCancelGameRender = false;
        if (mc.field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (!start) {
                mapProcessor.onRenderProcess(mc);
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else {
                if (!SupportMods.vivecraft && MapProcessor.shouldSkipWorldRender()) {
                    Misc.setShaderProgram(0);
                    RenderSystem.enableDepthTest();
                    mc.field_71441_e.func_72863_F().func_212863_j_().func_215575_a(Integer.MAX_VALUE, true, true);
                    shouldCancelGameRender = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
        return shouldCancelGameRender;
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        if (event.phase == TickEvent.Phase.END) {
            this.handleRenderTick(false);
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!Patreon.needsNotification() && WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    public void spawnSet(World world, BlockPos spawn) {
        WorldMapSession worldmapSession;
        if (world instanceof ClientWorld && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(spawn, (ClientWorld)world);
        }
    }

    @SubscribeEvent
    public void worldCapabilities(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof ServerWorld) {
            ServerWorldCapabilities capabilityProvider = new ServerWorldCapabilities();
            event.addCapability(new ResourceLocation("xaeroworldmap", "server_world_caps"), (ICapabilityProvider)capabilityProvider);
            event.addListener(capabilityProvider::invalidateCaps);
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.func_71410_x().field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.getWorld() == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld sw = (ServerWorld)event.getWorld();
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            String crosshairMessage;
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
            String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
            if (crosshairMessage != null) {
                int messageWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(crosshairMessage);
                RenderSystem.disableBlend();
                MainWindow window = Minecraft.func_71410_x().func_228018_at_();
                Minecraft.func_71410_x().field_71466_p.func_238405_a_(event.getMatrixStack(), crosshairMessage, (float)(window.func_198107_o() / 2 - messageWidth / 2), (float)(window.func_198087_p() / 2 + 60), -1);
                RenderSystem.enableBlend();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            }
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        WorldMapSession worldmapSession;
        if (e.getMessage() == null) {
            return;
        }
        ITextComponent text = e.getMessage();
        String textString = text.getString();
        if (e.getType() == ChatType.SYSTEM && e.getSenderUUID().equals(Util.field_240973_b_) && textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlayMessage(false);
        }
        if (e.getType() == ChatType.SYSTEM && e.getSenderUUID().equals(Util.field_240973_b_) && textString.contains("\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlayMessage(true);
        }
        if (e.getType() == ChatType.SYSTEM && e.getSenderUUID().equals(Util.field_240973_b_) && textString.contains("\u00a7f\u00a7a\u00a7i\u00a7r\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setFairplayMessageReceived(true);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) throws Exception {
        WorldMapSession worldmapSession;
        if (event.side == LogicalSide.CLIENT && event.player == Minecraft.func_71410_x().field_71439_g && event.phase == TickEvent.Phase.START && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            worldmapSession.getControlsHandler().handleKeyEvents();
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) throws Exception {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71439_g != null) {
            if (!WorldMap.loaded) {
                return;
            }
            WorldMap.crashHandler.checkForCrashes();
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession != null) {
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                mapProcessor.onClientTickStart();
            }
        }
    }

    public void handleClientRunTickStart() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            if (!WorldMap.loaded) {
                return;
            }
            WorldMap.crashHandler.checkForCrashes();
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession != null) {
                worldmapSession.getMapProcessor().getWorldDataHandler().handleRenderExecutor();
            }
        }
    }
}

