/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.config.util;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.profile.ConfigProfile;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.mcworld.WorldMapClientWorldData;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;
import xaero.map.mods.SupportMods;

public class WorldMapClientConfigUtils {
    public static boolean isFairPlay() {
        WorldMapSession worldmapSession;
        boolean defaultValue = false;
        if (SupportMods.minimap() && SupportMods.xaeroMinimap.isFairPlay()) {
            defaultValue = true;
        }
        if ((worldmapSession = WorldMapSession.getCurrentSession()) == null) {
            return defaultValue;
        }
        if (!worldmapSession.getMapProcessor().fairplayMessageWasReceived()) {
            return defaultValue;
        }
        return !worldmapSession.getMapProcessor().isConsideringNetherFairPlay() || worldmapSession.getMapProcessor().getMapWorld().getCurrentDimensionId() != Level.f_46429_;
    }

    public static boolean isCaveModeDisabledLegacy() {
        if (WorldMap.INSTANCE.getConfigs().getClientConfigManager().getServerSynced().isChannelPresentOnServer()) {
            return false;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return false;
        }
        WorldMapClientWorldData clientData = WorldMapClientWorldDataHelper.getCurrentWorldData();
        return !clientData.getSyncedRules().allowCaveModeOnServer && Minecraft.m_91087_().f_91073_.m_46472_() != Level.f_46429_ || !clientData.getSyncedRules().allowNetherCaveModeOnServer && Minecraft.m_91087_().f_91073_.m_46472_() == Level.f_46429_;
    }

    public static boolean getEffectiveCaveModeAllowed() {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        if (!((Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED)).booleanValue()) {
            return false;
        }
        if (Minecraft.m_91087_().f_91073_ == null) {
            return true;
        }
        ResourceLocation currentDimension = Minecraft.m_91087_().f_91073_.m_46472_().m_135782_();
        Set localCaveModeDimensions = (Set)configManager.getCurrentProfile().get(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        if (!localCaveModeDimensions.isEmpty() && !localCaveModeDimensions.contains(currentDimension)) {
            return false;
        }
        Set serverCaveModeDimensions = (Set)configManager.getCurrentProfile().get(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS);
        if (serverCaveModeDimensions == null || serverCaveModeDimensions.isEmpty()) {
            return true;
        }
        return serverCaveModeDimensions.contains(currentDimension);
    }

    public static boolean getDebug() {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        return (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DEBUG);
    }

    public static void togglePrimaryOption(ConfigOption<Boolean> option) {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        primaryConfigManager.getConfig().set(option, (Object)((Boolean)primaryConfigManager.getConfig().get(option) == false ? 1 : 0));
        WorldMap.INSTANCE.getConfigs().getPrimaryClientConfigManagerIO().save();
    }

    public static void tryTogglingCurrentProfileOption(ConfigOption<Boolean> option) {
        ConfigProfile currentProfile;
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        if (configManager.getServerSynced().getEffective(option) != null) {
            return;
        }
        currentProfile.set(option, (Object)((Boolean)(currentProfile = configManager.getCurrentProfile()).get(option) == false ? 1 : 0));
        WorldMap.INSTANCE.getConfigs().getClientConfigProfileIO().save(currentProfile);
    }

    public static boolean isOptionServerEnforced(ConfigOption<Boolean> option) {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return configManager.getServerSynced().getEffective(option) != null;
    }
}

