/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import xaero.map.WorldMap;
import xaero.map.cache.placeholder.PlaceholderBlockGetter;

public class BlockStateShortShapeCache {
    private Map<BlockState, Boolean> shortBlockStates = new HashMap<BlockState, Boolean>();
    private BlockState lastShortChecked = null;
    private boolean lastShortCheckedResult = false;
    private PlaceholderBlockGetter placeholderBlockGetter = new PlaceholderBlockGetter();
    private CompletableFuture<Boolean> ioThreadWaitingFor;
    private Supplier<Boolean> ioThreadWaitingForSupplier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShort(BlockState state) {
        Boolean cached;
        if (state == null || state.getBlock() instanceof AirBlock || state.getBlock() instanceof LiquidBlock) {
            return false;
        }
        Map<BlockState, Boolean> map = this.shortBlockStates;
        synchronized (map) {
            if (state == this.lastShortChecked) {
                return this.lastShortCheckedResult;
            }
            cached = this.shortBlockStates.get(state);
        }
        if (cached == null) {
            if (!Minecraft.getInstance().isSameThread()) {
                boolean isIOThread;
                Supplier<Boolean> supplier = () -> this.isShort(state);
                CompletableFuture future = Minecraft.getInstance().submit(supplier);
                boolean bl = isIOThread = Thread.currentThread() == WorldMap.mapRunnerThread;
                if (isIOThread) {
                    this.ioThreadWaitingForSupplier = supplier;
                    this.ioThreadWaitingFor = future;
                }
                Boolean result = (Boolean)future.join();
                if (isIOThread) {
                    this.ioThreadWaitingForSupplier = null;
                    this.ioThreadWaitingFor = null;
                }
                return result;
            }
            try {
                this.placeholderBlockGetter.setPlaceholderState(state);
                VoxelShape shape = state.getShape((BlockGetter)this.placeholderBlockGetter, BlockPos.ZERO);
                cached = shape.max(Direction.Axis.Y) < 0.25;
            }
            catch (Throwable t) {
                WorldMap.LOGGER.info("Defaulting world-dependent block state shape to not short: " + state);
                cached = false;
            }
            map = this.shortBlockStates;
            synchronized (map) {
                this.shortBlockStates.put(state, cached);
                this.lastShortChecked = state;
                this.lastShortCheckedResult = cached;
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<BlockState, Boolean> map = this.shortBlockStates;
        synchronized (map) {
            this.shortBlockStates.clear();
            this.lastShortChecked = null;
            this.lastShortCheckedResult = false;
        }
    }

    public void supplyForIOThread() {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new RuntimeException(new IllegalAccessException("Supplying from the wrong thread!"));
        }
        CompletableFuture<Boolean> waitingFor = this.ioThreadWaitingFor;
        if (waitingFor != null && !waitingFor.isDone()) {
            waitingFor.complete(this.ioThreadWaitingForSupplier.get());
        }
    }
}

