/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.minimap.highlight.DimensionHighlighterHandler;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.hud.controls.key.KeyMappingController;
import xaero.hud.controls.key.function.KeyMappingFunction;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.common.config.MinimapConfigConstants;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.controls.key.MinimapKeyMappings;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.render.element.RadarRenderer;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.waypoint.WaypointTeleport;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapDimensionHelper;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.minimap.world.state.MinimapWorldState;
import xaero.hud.minimap.world.state.MinimapWorldStateUpdater;
import xaero.hud.path.XaeroPath;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.lib.common.util.KeySortableByOther;
import xaero.map.WorldMap;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementGraphics;
import xaero.map.gui.GuiMap;
import xaero.map.misc.Misc;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointMenuRenderer;
import xaero.map.mods.gui.WaypointRenderer;
import xaero.map.mods.minimap.element.MinimapElementGraphicsWrapper;
import xaero.map.mods.minimap.element.RadarRendererWrapperHelper;
import xaero.map.mods.minimap.tracker.system.MinimapSyncedPlayerTrackerSystem;
import xaero.map.radar.tracker.system.IPlayerTrackerSystem;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class SupportXaeroMinimap {
    HudMod modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private MinimapWorld waypointWorld;
    private MinimapWorld mapWaypointWorld;
    private ResourceKey<Level> mapDimId;
    private double dimDiv;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsSorted;
    private WaypointMenuRenderer waypointMenuRenderer;
    private final WaypointRenderer waypointRenderer;
    private IPlayerTrackerSystem<?> minimapSyncedPlayerTrackerSystem;
    private MinimapWorld mouseBlockWaypointWorld;
    private MinimapWorld rightClickWaypointWorld;
    private MinimapElementGraphicsWrapper elementGraphicsWrapper;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = HudMod.INSTANCE;
            WorldMap.LOGGER.info("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = HudMod.INSTANCE;
                WorldMap.LOGGER.info("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
            this.elementGraphicsWrapper = new MinimapElementGraphicsWrapper();
        }
        this.waypointRenderer = WaypointRenderer.Builder.begin().setMinimap(this).setSymbolCreator(WorldMap.waypointSymbolCreator).build();
    }

    public void register() {
        WorldMap.playerTrackerSystemManager.register("minimap_synced", this.getMinimapSyncedPlayerTrackerSystem());
    }

    public ArrayList<Waypoint> convertWaypoints(double dimDiv) {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result, dimDiv);
        } else {
            for (WaypointSet set : this.waypointWorld.getIterableWaypointSets()) {
                this.convertSet(set, result, dimDiv);
            }
        }
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        this.deathpoints = (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.DEATHPOINTS);
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result, double dimDiv) {
        String setName = set.getName();
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean showingDisabled = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        for (xaero.common.minimap.waypoints.Waypoint w : set.getWaypoints()) {
            if (!showingDisabled && w.isDisabled()) continue;
            result.add(this.convertWaypoint(w, true, setName, dimDiv));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable, String setName, double dimDiv) {
        int waypointType = w.getWaypointType();
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), MinimapConfigConstants.COLORS[w.getColor()], waypointType, editable, setName, w.isYIncluded(), dimDiv);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        converted.setTemporary(w.isTemporary());
        converted.setGlobal(w.isGlobal());
        return converted;
    }

    public void openWaypoint(GuiMap parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        ArrayList<xaero.common.minimap.waypoints.Waypoint> waypointsEdited = new ArrayList<xaero.common.minimap.waypoints.Waypoint>();
        waypointsEdited.add((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        GuiAddWaypoint addScreen = new GuiAddWaypoint(this.modMain, minimapSession, (Screen)parent, (Screen)parent, waypointsEdited, this.waypointWorld.getContainer().getRoot().getPath(), this.waypointWorld, waypoint.getSetName(), false);
        Minecraft.getInstance().setScreen((Screen)addScreen);
    }

    public void createWaypoint(GuiMap parent, int x, int y, int z, double coordDimensionScale, boolean rightClick) {
        if (this.waypointWorld == null) {
            return;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorld coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        GuiAddWaypoint addScreen = new GuiAddWaypoint(this.modMain, minimapSession, (Screen)parent, (Screen)parent, new ArrayList(), this.waypointWorld.getContainer().getRoot().getPath(), this.waypointWorld, this.waypointWorld.getCurrentWaypointSetId(), true, true, x, y, z, coordDimensionScale, coordSourceWaypointWorld);
        Minecraft.getInstance().setScreen((Screen)addScreen);
    }

    public void createTempWaypoint(int x, int y, int z, double mapDimensionScale, boolean rightClick) {
        if (this.waypointWorld == null) {
            return;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorld coordSourceWaypointWorld = rightClick ? this.rightClickWaypointWorld : this.mouseBlockWaypointWorld;
        minimapSession.getWaypointSession().getTemporaryHandler().createTemporaryWaypoint(this.waypointWorld, x, y, z, y != Short.MAX_VALUE && coordSourceWaypointWorld == this.waypointWorld, mapDimensionScale);
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport(MinimapWorld world) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        WaypointSession waypointSession = minimapSession.getWaypointSession();
        WaypointTeleport waypointTeleport = waypointSession.getTeleport();
        return world != null && waypointTeleport.canTeleport(waypointTeleport.isWorldTeleportable(world), world);
    }

    public void teleportToWaypoint(Screen screen, Waypoint w) {
        this.teleportToWaypoint(screen, w, this.waypointWorld);
    }

    public void teleportToWaypoint(Screen screen, Waypoint w, MinimapWorld world) {
        if (world == null) {
            return;
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        WaypointSession waypointSession = minimapSession.getWaypointSession();
        WaypointTeleport waypointTeleport = waypointSession.getTeleport();
        waypointTeleport.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), world, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        try {
            minimapSession.getWorldManagerIO().saveWorld(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            for (WaypointSet set : this.waypointWorld.getIterableWaypointSets()) {
                set.remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
            }
        }
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        try {
            minimapSession.getWorldManagerIO().saveWorld(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.waypoints.remove(waypoint);
        this.waypointsSorted.remove(waypoint);
        this.waypointMenuRenderer.updateFilteredList();
    }

    public void checkWaypoints(boolean multiplayer, ResourceKey<Level> dimId, String multiworldId, int width, int height, GuiMap screen, MapWorld mapWorld, Registry<DimensionType> dimensionTypes) {
        ClientConfigManager minimapConfigManager;
        boolean renderAllSetsConfig;
        WaypointSet checkingSet;
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager worldManager = minimapSession.getWorldManager();
        MinimapWorldState worldState = minimapSession.getWorldState();
        MinimapWorldStateUpdater worldStateUpdater = minimapSession.getWorldStateUpdater();
        MinimapDimensionHelper dimensionHelper = minimapSession.getDimensionHelper();
        XaeroPath containerPath = worldState.getAutoRootContainerPath().resolve(dimensionHelper.getDimensionDirectoryName(dimId));
        XaeroPath mapBasedWorldPath = containerPath.resolve(!multiplayer ? "waypoints" : multiworldId);
        this.mapWaypointWorld = worldManager.getWorld(mapBasedWorldPath);
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        MinimapWorld checkingWaypointWorld = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS) != false ? this.mapWaypointWorld : worldManager.getCurrentWorld();
        Minecraft mc = Minecraft.getInstance();
        if (Misc.hasEffect((Player)mc.player, (Holder<MobEffect>)Effects.NO_WAYPOINTS) || Misc.hasEffect((Player)mc.player, (Holder<MobEffect>)Effects.NO_WAYPOINTS_HARMFUL)) {
            checkingWaypointWorld = null;
        }
        boolean shouldRefresh = this.refreshWaypoints;
        if (dimId != this.mapDimId) {
            shouldRefresh = true;
            this.mapDimId = dimId;
        }
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            screen.closeRightClick();
            if (screen.waypointMenu) {
                screen.init(Minecraft.getInstance(), width, height);
            }
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentWaypointSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != (renderAllSetsConfig = ((Boolean)(minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager()).getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ALL_SETS)).booleanValue())) {
            this.allSets = renderAllSetsConfig;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.dimDiv = this.waypointWorld == null ? 1.0 : this.getDimensionDivision(mapWorld, dimensionTypes, dimensionHelper, this.waypointWorld.getContainer().getPath(), dimId);
            this.waypoints = this.convertWaypoints(this.dimDiv);
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
                this.waypointsSorted = new ArrayList();
                ArrayList<KeySortableByOther> sortingList = new ArrayList<KeySortableByOther>();
                for (Waypoint w : this.waypoints) {
                    sortingList.add(new KeySortableByOther((Object)w, new Comparable[]{w.getComparisonName(), w.getName()}));
                }
                Collections.sort(sortingList);
                for (KeySortableByOther e : sortingList) {
                    this.waypointsSorted.add((Waypoint)e.getKey());
                }
            } else {
                this.waypointsSorted = null;
            }
            this.waypointMenuRenderer.updateFilteredList();
        }
        this.refreshWaypoints = false;
    }

    private double getDimensionDivision(MapWorld mapWorld, Registry<DimensionType> dimensionTypes, MinimapDimensionHelper dimensionHelper, XaeroPath worldContainerID, ResourceKey<Level> mapDimId) {
        if (worldContainerID == null || Minecraft.getInstance().level == null) {
            return 1.0;
        }
        String dimPart = worldContainerID.getLastNode();
        ResourceKey waypointDimId = dimensionHelper.getDimensionKeyForDirectoryName(dimPart);
        MapDimension waypointMapDimension = mapWorld.getDimension((ResourceKey<Level>)waypointDimId);
        MapDimension mapDimension = mapWorld.getDimension(mapDimId);
        DimensionType waypointDimType = MapDimension.getDimensionType(waypointMapDimension, (ResourceKey<Level>)waypointDimId, dimensionTypes);
        DimensionType mapDimType = MapDimension.getDimensionType(mapDimension, mapDimId, dimensionTypes);
        double waypointDimScale = waypointDimType == null ? 1.0 : waypointDimType.coordinateScale();
        double mapDimScale = mapDimType == null ? 1.0 : mapDimType.coordinateScale();
        return mapDimScale / waypointDimScale;
    }

    public HoveredMapElementHolder<?, ?> renderWaypointsMenu(GuiGraphics guiGraphics, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> hovered, Minecraft mc) {
        return this.waypointMenuRenderer.renderMenu(guiGraphics, gui, scale, width, height, mouseX, mouseY, leftMousePressed, leftMouseClicked, hovered, mc);
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public KeyMapping getWaypointKeyBinding() {
        return MinimapKeyMappings.ADD_WAYPOINT;
    }

    public KeyMapping getTempWaypointKeyBinding() {
        return MinimapKeyMappings.TEMPORARY_WAYPOINT;
    }

    public KeyMapping getTempWaypointsMenuKeyBinding() {
        return MinimapKeyMappings.WAYPOINT_MENU;
    }

    public void onMapKeyPressed(InputConstants.Type type, int code, GuiMap screen) {
        KeyMapping listPlayerAlternative;
        KeyMapping minimapSettingsKB;
        KeyMapping kb = null;
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)this.getToggleRadarKey(), (int)0)) {
            screen.onRadarButton(screen.getRadarButton());
        }
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)MinimapKeyMappings.TOGGLE_MAP_WAYPOINTS, (int)0)) {
            this.getWaypointMenuRenderer().onRenderWaypointsButton(screen, screen.width, screen.height);
        }
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)MinimapKeyMappings.REVERSE_ENTITY_RADAR, (int)0)) {
            MinimapKeyMappings.REVERSE_ENTITY_RADAR.setDown(true);
        }
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)MinimapKeyMappings.SWITCH_WAYPOINT_SET, (int)0)) {
            kb = MinimapKeyMappings.SWITCH_WAYPOINT_SET;
        }
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)MinimapKeyMappings.RENDER_ALL_SETS, (int)0)) {
            kb = MinimapKeyMappings.RENDER_ALL_SETS;
        }
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)MinimapKeyMappings.WAYPOINT_MENU, (int)0)) {
            kb = MinimapKeyMappings.WAYPOINT_MENU;
        }
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)(minimapSettingsKB = (KeyMapping)this.modMain.getSettingsKey()), (int)0)) {
            kb = minimapSettingsKB;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)listPlayerAlternative, (int)0)) {
            listPlayerAlternative.setDown(true);
        }
        Minecraft mc = Minecraft.getInstance();
        if (kb != null) {
            if (kb == MinimapKeyMappings.WAYPOINT_MENU) {
                this.openWaypointsMenu(mc, screen);
                return;
            }
            if (minimapSettingsKB != null && kb == minimapSettingsKB) {
                mc.setScreen(this.getSettingsScreen((Screen)screen));
                return;
            }
            this.handleMinimapKeyBinding(kb, screen);
        }
    }

    public boolean onMapKeyReleased(InputConstants.Type type, int code, GuiMap screen) {
        KeyMapping listPlayerAlternative;
        boolean result = false;
        if (KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)MinimapKeyMappings.REVERSE_ENTITY_RADAR, (int)0)) {
            MinimapKeyMappings.REVERSE_ENTITY_RADAR.setDown(false);
            result = true;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && KeyMappingUtils.inputMatches((InputConstants.Type)type, (int)code, (KeyMapping)listPlayerAlternative, (int)0)) {
            listPlayerAlternative.setDown(false);
            result = true;
        }
        return result;
    }

    public void handleMinimapKeyBinding(KeyMapping kb, GuiMap screen) {
        KeyMappingController controller = this.modMain.getKeyMappingControllers().getController(kb);
        for (KeyMappingFunction keyFunction : controller) {
            if (keyFunction.isHeld()) continue;
            keyFunction.onPress();
        }
        for (KeyMappingFunction keyFunction : controller) {
            if (keyFunction.isHeld()) continue;
            keyFunction.onRelease();
        }
        if ((kb == MinimapKeyMappings.SWITCH_WAYPOINT_SET || kb == MinimapKeyMappings.RENDER_ALL_SETS) && screen.waypointMenu) {
            screen.init(Minecraft.getInstance(), screen.width, screen.height);
        }
    }

    public void drawSetChange(GuiGraphics guiGraphics) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        this.modMain.getMinimap().getWaypointMapRenderer().drawSetChange(minimapSession, guiGraphics, Minecraft.getInstance().getWindow());
    }

    public Screen getSettingsScreen(Screen current) {
        return this.modMain.getGuiHelper().getMinimapSettingsFromScreen(current);
    }

    public String getControlsTooltip() {
        return I18n.get((String)"gui.xaero_box_controls_minimap", (Object[])new Object[]{KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.ADD_WAYPOINT), KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.TEMPORARY_WAYPOINT), KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.SWITCH_WAYPOINT_SET), KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.RENDER_ALL_SETS), KeyMappingUtils.getKeyName((KeyMapping)MinimapKeyMappings.WAYPOINT_MENU)});
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.waypointMenuRenderer.onMapMouseRelease(par1, par2, par3);
    }

    public void onMapConstruct() {
        this.waypointMenuRenderer = new WaypointMenuRenderer(new WaypointMenuRenderContext(), new WaypointMenuRenderProvider(this), this.waypointRenderer);
    }

    public void onMapInit(GuiMap mapScreen, Minecraft mc, int width, int height) {
        this.waypointMenuRenderer.onMapInit(mapScreen, mc, width, height, this.waypointWorld, (IXaeroMinimap)this.modMain, (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession());
    }

    public ArrayList<Waypoint> getWaypointsSorted() {
        return this.waypointsSorted;
    }

    public boolean waypointExists(Waypoint w) {
        return this.waypoints != null && this.waypoints.contains(w);
    }

    public void toggleTemporaryWaypoint(Waypoint waypoint) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setTemporary(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
        try {
            minimapSession.getWorldManagerIO().saveWorld(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void openWaypointsMenu(Minecraft mc, GuiMap screen) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        mc.setScreen((Screen)new GuiWaypoints(this.modMain, minimapSession, (Screen)screen, (Screen)screen));
    }

    public boolean hidingWaypointCoordinates() {
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        return (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.HIDE_WAYPOINT_COORDINATES);
    }

    public void shareWaypoint(Waypoint waypoint, GuiMap screen, MinimapWorld world) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        minimapSession.getWaypointSession().getSharing().shareWaypoint((Screen)screen, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), world);
    }

    public void shareLocation(GuiMap guiMap, int rightClickX, int rightClickY, int rightClickZ) {
        int wpColor = (int)((double)MinimapConfigConstants.COLORS.length * Math.random());
        xaero.common.minimap.waypoints.Waypoint minimapLocationWaypoint = new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY == Short.MAX_VALUE ? 0 : rightClickY, rightClickZ, "Shared Location", "S", wpColor, 0, false, rightClickY != Short.MAX_VALUE);
        Waypoint locationWaypoint = this.convertWaypoint(minimapLocationWaypoint, false, "", 1.0);
        this.shareWaypoint(locationWaypoint, guiMap, this.rightClickWaypointWorld);
    }

    public MinimapWorld getMapWaypointWorld() {
        return this.mapWaypointWorld;
    }

    public MinimapWorld getWaypointWorld() {
        return this.waypointWorld;
    }

    public double getDimDiv() {
        return this.dimDiv;
    }

    public int getArrowColorIndex() {
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        return (Integer)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ARROW_COLOR);
    }

    public float[] getArrowColor() {
        int arrowColour = this.getArrowColorIndex();
        if (arrowColour < 0 || arrowColour >= MinimapConfigConstants.ARROW_COLORS.length) {
            return null;
        }
        return MinimapConfigConstants.ARROW_COLORS[arrowColour];
    }

    public String getSubWorldNameToRender() {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean onlyCurrentMapWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        if (onlyCurrentMapWaypoints || this.waypointWorld == null) {
            return null;
        }
        if (this.waypointWorld != this.mapWaypointWorld) {
            return I18n.get((String)"gui.xaero_wm_using_custom_subworld", (Object[])new Object[]{this.waypointWorld.getContainer().getSubName()});
        }
        return null;
    }

    public void registerMinimapHighlighters(Object highlighterRegistry) {
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public boolean getDeathpoints() {
        return this.deathpoints;
    }

    public WaypointRenderer getWaypointRenderer() {
        return this.waypointRenderer;
    }

    public WaypointMenuRenderer getWaypointMenuRenderer() {
        return this.waypointMenuRenderer;
    }

    public void onClearHighlightHash(int regionX, int regionZ) {
        DimensionHighlighterHandler highlightHandler;
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null && (highlightHandler = minimapSession.getProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh(regionX, regionZ);
        }
    }

    public void createRadarRendererWrapper(Object radarRenderer) {
        new RadarRendererWrapperHelper().createWrapper((IXaeroMinimap)this.modMain, (RadarRenderer)radarRenderer);
    }

    public KeyMapping getToggleRadarKey() {
        return MinimapKeyMappings.TOGGLE_RADAR;
    }

    public void onClearHighlightHashes() {
        DimensionHighlighterHandler highlightHandler;
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null && (highlightHandler = minimapSession.getProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh();
        }
    }

    public KeyMapping getToggleAllyPlayersKey() {
        return MinimapKeyMappings.TOGGLE_TRACKED_PLAYERS_MAP;
    }

    public KeyMapping getToggleClaimsKey() {
        return MinimapKeyMappings.TOGGLE_OPAC_CLAIMS;
    }

    public void onSessionFinalized() {
        this.waypointWorld = null;
        this.mapWaypointWorld = null;
    }

    public void openWaypointWorldTeleportCommandScreen(Screen parent, Screen escape) {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        XaeroPath containerId = minimapSession.getWorldState().getAutoRootContainerPath();
        MinimapWorldRootContainer container = minimapSession.getWorldManager().getWorldContainerNullable(containerId).getRoot();
        if (container != null) {
            Minecraft.getInstance().setScreen((Screen)new GuiWorldTpCommand((IXaeroMinimap)this.modMain, parent, escape, container));
        }
    }

    public KeyMapping getMinimapListPlayersAlternative() {
        return MinimapKeyMappings.ALTERNATIVE_LIST_PLAYERS;
    }

    public int getCaveStart(int defaultWorldMapStart, boolean isMapScreen) {
        if (!this.modMain.getSettings().getMinimap()) {
            return defaultWorldMapStart;
        }
        if (!MinimapConfigClientUtils.getEffectiveCaveModeAllowed()) {
            return isMapScreen ? defaultWorldMapStart : Integer.MAX_VALUE;
        }
        int usedCaving = this.getUsedCaving();
        if (usedCaving == Integer.MAX_VALUE) {
            ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
            SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
            return (Integer)primaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START);
        }
        return usedCaving;
    }

    public int getUsedCaving() {
        MinimapSession minimapSession = (MinimapSession)BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null) {
            return minimapSession.getProcessor().getMinimapWriter().getLoadedCaving();
        }
        return Integer.MAX_VALUE;
    }

    public boolean isFairPlay() {
        return this.modMain.isFairPlay();
    }

    public IPlayerTrackerSystem<?> getMinimapSyncedPlayerTrackerSystem() {
        if (this.minimapSyncedPlayerTrackerSystem == null) {
            this.minimapSyncedPlayerTrackerSystem = new MinimapSyncedPlayerTrackerSystem(this);
        }
        return this.minimapSyncedPlayerTrackerSystem;
    }

    public void onBlockHover() {
        this.mouseBlockWaypointWorld = this.mapWaypointWorld;
    }

    public void onRightClick() {
        this.rightClickWaypointWorld = this.mouseBlockWaypointWorld;
    }

    public MinimapElementGraphicsWrapper wrapElementGraphics(MapElementGraphics graphics) {
        return this.elementGraphicsWrapper.setGraphics(graphics);
    }
}

