/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import org.lwjgl.opengl.GL11;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO = new ImprovedFramebuffer(64, 64, false);
    private int glEmptyTexture = this.renderFBO.getFramebufferTexture();

    public BranchTextureRenderer(class_276 defaultFramebuffer) {
        this.renderFBO.method_1235(true);
        class_4493.method_22012();
        class_4493.method_22053();
        class_4493.method_21943((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        class_4493.method_21965((int)16384, (boolean)class_310.field_1703);
        class_4493.method_22021();
        class_4493.method_22056();
        this.renderFBO.method_1240();
        ImprovedFramebuffer.beginWrite(this.renderFBO.getType(), 36160, defaultFramebuffer.field_1476);
        class_4493.method_22025((int)0, (int)0, (int)defaultFramebuffer.field_1480, (int)defaultFramebuffer.field_1477);
    }

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, class_276 defaultFramebuffer, boolean justAllocated) {
        class_4493.method_22081((int)0);
        this.renderFBO.bindAsMainTarget(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        class_4493.method_21926();
        class_4493.method_21924();
        class_4493.method_21907((int)5889);
        class_4493.method_21924();
        class_4493.method_21939((double)0.0, (double)64.0, (double)64.0, (double)0.0, (double)-1.0, (double)1.0);
        class_4493.method_21907((int)5888);
        class_4493.method_22012();
        class_4493.method_22053();
        if (justAllocated) {
            class_4493.method_21943((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            class_4493.method_21965((int)16384, (boolean)class_310.field_1703);
        }
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1);
        }
        OpenGLException.checkGLError(false, "updating a map branch texture");
        class_4493.method_22021();
        class_4493.method_22056();
        class_4493.method_22081((int)0);
        class_4493.method_21928();
        class_4493.method_21907((int)5889);
        class_310 mc = class_310.method_1551();
        Misc.minecraftOrtho(mc, false);
        class_4493.method_21907((int)5888);
        this.renderFBO.method_1240();
        ImprovedFramebuffer.bindDefaultFramebuffer(this.renderFBO.getType(), 36160, mc);
        class_4493.method_22025((int)0, (int)0, (int)mc.method_22683().method_4489(), (int)mc.method_22683().method_4506());
        OpenGLException.checkGLError();
    }

    private void renderCorner(Integer srcTexture, int cornerX, int cornerY) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        class_4493.method_22081((int)(srcTexture != -1 ? srcTexture : this.glEmptyTexture));
        MapRenderHelper.renderTexturedModalRect(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f);
    }
}

