/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.minimap.element;

import java.util.function.Supplier;
import net.minecraft.class_1060;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.element.render.MinimapElementRenderLocation;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.map.MapProcessor;
import xaero.map.WorldMapSession;
import xaero.map.element.MapElementRenderer;
import xaero.map.element.render.ElementRenderInfo;
import xaero.map.element.render.ElementRenderLocation;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.mods.SupportMods;
import xaero.map.mods.minimap.element.MinimapElementReaderWrapper;
import xaero.map.mods.minimap.element.MinimapElementRenderProviderWrapper;
import xaero.map.world.MapDimension;

public final class MinimapElementRendererWrapper<E, C>
extends MapElementRenderer<E, C, MinimapElementRendererWrapper<E, C>> {
    private final int order;
    private final IXaeroMinimap modMain;
    private final MinimapElementRenderer<E, C> renderer;
    private final Supplier<Boolean> shouldRenderSupplier;
    private ElementRenderInfo compatibleRenderInfo;

    private MinimapElementRendererWrapper(IXaeroMinimap modMain, C context, MinimapElementRenderProviderWrapper<E, C> provider, MinimapElementReaderWrapper<E, C> reader, MinimapElementRenderer<E, C> renderer, Supplier<Boolean> shouldRenderSupplier, int order) {
        super(context, provider, reader);
        this.order = order;
        this.renderer = renderer;
        this.modMain = modMain;
        this.shouldRenderSupplier = shouldRenderSupplier;
    }

    @Override
    @Deprecated
    public void beforeRender(int location, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        ElementRenderInfo renderInfo = this.getFakeRenderInfo(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, fontRenderer, vanillaBufferSource, rendererProvider, pre);
        this.preRender(renderInfo, vanillaBufferSource, rendererProvider, pre);
    }

    @Override
    @Deprecated
    public void afterRender(int location, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        if (this.compatibleRenderInfo == null) {
            this.compatibleRenderInfo = this.getFakeRenderInfo(location, mc, matrixStack, cameraX, cameraZ, mouseX, mouseZ, brightness, scale, screenSizeBasedScale, textureManager, fontRenderer, vanillaBufferSource, rendererProvider, pre);
        }
        this.postRender(this.compatibleRenderInfo, vanillaBufferSource, rendererProvider, pre);
        this.compatibleRenderInfo = null;
    }

    private ElementRenderInfo getFakeRenderInfo(int location, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        MapProcessor mapProcessor = WorldMapSession.getCurrentSession().getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        double mapDimScale = mapDimension.calculateDimScale(mapProcessor.getWorldDimensionTypeRegistry());
        return new ElementRenderInfo(ElementRenderLocation.fromIndex(location), mc.method_1560(), (class_1657)mc.field_1724, new class_243(cameraX, -1.0, cameraZ), mouseX, mouseZ, scale, false, 1.0f, brightness, screenSizeBasedScale, null, mapDimScale, mapDimension.getDimId());
    }

    @Override
    @Deprecated
    public boolean renderElement(int location, E element, boolean hovered, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
        if (this.compatibleRenderInfo == null) {
            MapProcessor mapProcessor = WorldMapSession.getCurrentSession().getMapProcessor();
            MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
            double mapDimScale = mapDimension.calculateDimScale(mapProcessor.getWorldDimensionTypeRegistry());
            this.compatibleRenderInfo = new ElementRenderInfo(ElementRenderLocation.fromIndex(location), mc.method_1560(), (class_1657)mc.field_1724, new class_243(cameraX, -1.0, cameraZ), mouseX, mouseZ, scale, cave, partialTicks, brightness, screenSizeBasedScale, null, mapDimScale, mapDimension.getDimId());
        }
        return this.renderElement(element, hovered, optionalDepth, optionalScale, partialX, partialY, this.compatibleRenderInfo, matrixStack, vanillaBufferSource, rendererProvider);
    }

    @Override
    public void preRender(ElementRenderInfo renderInfo, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean shadow) {
        class_4597.class_4598 renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider minimapMultiTextureRender = minimapSession.getMultiTextureRenderTypeRenderers();
        this.renderer.preRender(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), renderInfo.renderEntity, renderInfo.player, renderInfo.renderPos.field_1352, renderInfo.renderPos.field_1351, renderInfo.renderPos.field_1350, this.modMain, renderTypeBuffers, minimapMultiTextureRender);
    }

    @Override
    public void postRender(ElementRenderInfo renderInfo, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, boolean shadow) {
        class_4597.class_4598 renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider minimapMultiTextureRender = minimapSession.getMultiTextureRenderTypeRenderers();
        this.renderer.postRender(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), renderInfo.renderEntity, renderInfo.player, renderInfo.renderPos.field_1352, renderInfo.renderPos.field_1351, renderInfo.renderPos.field_1350, this.modMain, renderTypeBuffers, minimapMultiTextureRender);
    }

    @Override
    public boolean renderElement(E element, boolean hovered, double optionalDepth, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo, class_4587 matrixStack, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
        class_4597.class_4598 renderTypeBuffers = this.modMain.getInterfaceRenderer().getCustomVertexConsumers().getBetterPVPRenderTypeBuffers();
        class_310 mc = class_310.method_1551();
        MinimapRendererHelper helper = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().getHelper();
        if (SupportMods.xaeroMinimap.compatibilityVersion >= 12) {
            return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), hovered, false, matrixStack, renderTypeBuffers, mc.field_1772, renderInfo.framebuffer, helper, mc.method_1560(), (class_1657)mc.field_1724, renderInfo.renderPos.field_1352, renderInfo.renderPos.field_1351, renderInfo.renderPos.field_1350, 0, optionalDepth, optionalScale, element, partialX, partialY, renderInfo.cave, renderInfo.partialTicks);
        }
        return this.renderer.renderElement(MinimapElementRenderLocation.fromWorldMap((int)renderInfo.location.getIndex()), hovered, matrixStack, renderTypeBuffers, mc.field_1772, renderInfo.framebuffer, helper, mc.method_1560(), (class_1657)mc.field_1724, renderInfo.renderPos.field_1352, renderInfo.renderPos.field_1351, renderInfo.renderPos.field_1350, 0, optionalDepth, optionalScale, element, partialX, partialY, renderInfo.cave, renderInfo.partialTicks);
    }

    @Override
    @Deprecated
    public void renderElementPre(int location, E element, boolean hovered, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, class_1060 textureManager, class_327 fontRenderer, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
    }

    @Override
    public void renderElementShadow(E element, boolean hovered, float optionalScale, double partialX, double partialY, ElementRenderInfo renderInfo, class_4587 matrixStack, class_4597.class_4598 vanillaBufferSource, MultiTextureRenderTypeRendererProvider rendererProvider) {
    }

    @Override
    public boolean shouldRender(int location, boolean shadow) {
        return !shadow && this.shouldRenderSupplier.get() != false && this.renderer.shouldRender(location);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public static final class Builder<E, C> {
        private final MinimapElementRenderer<E, C> renderer;
        private Supplier<Boolean> shouldRenderSupplier;
        private IXaeroMinimap modMain;
        private int order;

        private Builder(MinimapElementRenderer<E, C> renderer) {
            this.renderer = renderer;
        }

        private Builder<E, C> setDefault() {
            this.setModMain(null);
            this.setShouldRenderSupplier(() -> true);
            this.setOrder(0);
            return this;
        }

        public Builder<E, C> setModMain(IXaeroMinimap modMain) {
            this.modMain = modMain;
            return this;
        }

        public Builder<E, C> setShouldRenderSupplier(Supplier<Boolean> shouldRenderSupplier) {
            this.shouldRenderSupplier = shouldRenderSupplier;
            return this;
        }

        public Builder<E, C> setOrder(int order) {
            this.order = order;
            return this;
        }

        public MinimapElementRendererWrapper<E, C> build() {
            if (this.modMain == null || this.shouldRenderSupplier == null) {
                throw new IllegalStateException();
            }
            MinimapElementRenderProviderWrapper providerWrapper = new MinimapElementRenderProviderWrapper(this.renderer.getProvider());
            MinimapElementReaderWrapper readerWrapper = new MinimapElementReaderWrapper(this.renderer.getElementReader());
            Object context = this.renderer.getContext();
            return new MinimapElementRendererWrapper(this.modMain, context, providerWrapper, readerWrapper, this.renderer, this.shouldRenderSupplier, this.order);
        }

        public static <E, C> Builder<E, C> begin(MinimapElementRenderer<E, C> renderer) {
            return super.setDefault();
        }
    }
}

