/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.capabilities.ServerWorldLoaded;
import xaero.map.executor.Executor;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;
import xaero.map.world.MapDimensionTypeInfo;
import xaero.map.world.MapWorld;

public class WorldDataHandler {
    private final Executor renderExecutor;
    private WorldDataReader reader;
    private MapDimensionTypeInfo dimType;
    private WorldServer worldServer;
    private File worldDir;

    public WorldDataHandler(WorldDataReader reader, Executor renderExecutor) {
        this.reader = reader;
        this.renderExecutor = renderExecutor;
    }

    public void handleRenderExecutor() {
        this.renderExecutor.drainTasks();
    }

    public void prepareSingleplayer(World world, MapProcessor mapProcessor) {
        MapWorld mapWorld = mapProcessor.getMapWorld();
        if (world != null && mapWorld.getCurrentDimension().isUsingWorldSave()) {
            Integer dimId = mapWorld.getCurrentDimensionId();
            this.dimType = mapWorld.getCurrentDimension().getDimensionType();
            this.worldServer = DimensionManager.getWorld((int)dimId, (boolean)false);
            if (this.worldServer != null) {
                this.worldDir = this.worldServer.getChunkSaveLocation();
            } else {
                Path rootSaveLocation;
                WorldServer overworldWorld = DimensionManager.getWorld((int)0);
                Path path = rootSaveLocation = overworldWorld == null ? null : overworldWorld.getChunkSaveLocation().toPath();
                this.worldDir = rootSaveLocation != null && this.dimType != null ? rootSaveLocation.resolve(this.dimType.getSavePath()).toFile() : null;
            }
        } else {
            this.worldDir = null;
        }
    }

    public Result buildRegion(World world, MapRegion region, boolean loading, int[] chunkCountDest) throws IOException {
        if (this.worldDir == null) {
            WorldMap.LOGGER.info("Tried loading a region for a null world dir!");
            return Result.CANCEL;
        }
        ServerWorldLoaded loadedCap = this.worldServer == null ? null : (ServerWorldLoaded)this.worldServer.getCapability(ServerWorldCapabilities.LOADED_CAP, null);
        boolean buildResult = this.reader.buildRegion(world, loadedCap == null || !loadedCap.loaded ? null : this.worldServer, this.dimType, region, this.worldDir, loading, chunkCountDest, this.renderExecutor);
        return buildResult ? Result.SUCCESS : Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerWorldUnload(WorldServer sw) {
        ServerWorldLoaded loadedCap = (ServerWorldLoaded)sw.getCapability(ServerWorldCapabilities.LOADED_CAP, null);
        if (loadedCap != null) {
            ServerWorldLoaded serverWorldLoaded = loadedCap;
            synchronized (serverWorldLoaded) {
                loadedCap.loaded = false;
            }
        }
    }

    public WorldDataReader getWorldDataReader() {
        return this.reader;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    Executor getWorldDataRenderExecutor() {
        return this.renderExecutor;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

