/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.reflection.util.ReflectionUtils;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.WriterBiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.gui.GuiMap;
import xaero.map.misc.CachedFunction;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapBlock;
import xaero.map.region.MapLayer;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.MapUpdateFastConfig;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter {
    public static final int MAX_TRANSPARENCY_BLEND_DEPTH = 5;
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private int caveStart;
    private int writingLayer = Integer.MAX_VALUE;
    private int writtenCaveStart = Integer.MAX_VALUE;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private final BlockPos.MutableBlockPos mutableLocalPos;
    private final BlockPos.MutableBlockPos mutableGlobalPos;
    private int[] biomeBuffer;
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private BlockStateColorTypeCache colorTypeCache;
    private MapProcessor mapProcessor;
    private ArrayList<IBlockState> buggedStates;
    private WriterBiomeInfoSupplier writerBiomeInfoSupplier;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private int topH;
    private final CachedFunction<IBlockState, Boolean> transparentCache;
    private int firstTransparentStateY;
    private final BlockPos.MutableBlockPos mutableBlockPos3;
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private MapTileChunk rightChunk = null;
    private MapTileChunk bottomRightChunk = null;
    private HashMap<String, Integer> textureColours;
    private HashMap<Integer, Integer> blockColours;
    private final Object2IntMap<IBlockState> blockTintIndices;
    private long lastLayerSwitch;
    private OtherLayerNotifier otherLayerNotifier;
    private int lastBlockStateForTextureColor = -1;
    private int lastBlockStateForTextureColorResult = -1;

    public MapWriter(OverlayManager overlayManager, BlockStateColorTypeCache colorTypeCache, BlockStateShortShapeCache blockStateShortShapeCache) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.MutableBlockPos();
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
        this.biomeBuffer = new int[3];
        this.colorTypeCache = colorTypeCache;
        this.buggedStates = new ArrayList();
        this.writerBiomeInfoSupplier = new WriterBiomeInfoSupplier((BlockPos)this.mutableGlobalPos);
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.transparentCache = new CachedFunction<IBlockState, Boolean>(new Function<IBlockState, Boolean>(){

            @Override
            public Boolean apply(IBlockState state) {
                return MapWriter.this.shouldOverlay(state);
            }
        });
        this.mutableBlockPos3 = new BlockPos.MutableBlockPos();
        this.otherLayerNotifier = new OtherLayerNotifier();
        this.blockTintIndices = new Object2IntOpenHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager) {
        block36: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block36;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
                        boolean loadChunksConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.LOAD_NEW_CHUNKS);
                        boolean updateChunksConfig = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.UPDATE_CHUNKS);
                        if (this.mapProcessor.getWorld() == null || this.mapProcessor.isCurrentMapLocked() || this.mapProcessor.getMapWorld().isCacheOnlyMode()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((World)this.mapProcessor.getWorld()) && (updateChunksConfig || loadChunksConfig || this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave())) {
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                if (this.mapProcessor.getMapWorld().getCurrentDimensionId() == null || this.mapProcessor.getWorld().field_73011_w.getDimension() != this.mapProcessor.getMapWorld().getCurrentDimensionId().intValue()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    boolean loadChunks = loadChunksConfig || this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave();
                                    boolean updateChunks = updateChunksConfig || this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave();
                                    boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
                                    boolean flowers = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS);
                                    boolean detailedDebug = WorldMap.detailed_debug;
                                    int caveDepth = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH);
                                    BlockPos.MutableBlockPos mutableBlockPos3 = this.mutableBlockPos3;
                                    MapUpdateFastConfig config = new MapUpdateFastConfig();
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        if (this.writeMap((World)this.mapProcessor.getWorld(), playerX, playerY, playerZ, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, caveDepth, config)) {
                                            --i;
                                        }
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                            int startRegionX = this.startTileChunkX >> 3;
                            int startRegionZ = this.startTileChunkZ >> 3;
                            int endRegionX = this.endTileChunkX >> 3;
                            int endRegionZ = this.endTileChunkZ >> 3;
                            boolean shouldRequestLoading = false;
                            LeveledRegion<?> nextToLoad = this.mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                            shouldRequestLoading = nextToLoad != null ? nextToLoad.shouldAllowAnotherRegionToLoad() : true;
                            this.regionBuffer.clear();
                            int comparisonChunkX = this.playerChunkX - 16;
                            int comparisonChunkZ = this.playerChunkZ - 16;
                            LeveledRegion.setComparison(comparisonChunkX, comparisonChunkZ, 0, comparisonChunkX, comparisonChunkZ);
                            for (int visitRegionX = startRegionX; visitRegionX <= endRegionX; ++visitRegionX) {
                                for (int visitRegionZ = startRegionZ; visitRegionZ <= endRegionZ; ++visitRegionZ) {
                                    MapRegion visitRegion = this.mapProcessor.getLeafMapRegion(this.writingLayer, visitRegionX, visitRegionZ, true);
                                    if (visitRegion != null && visitRegion.getLoadState() == 2) {
                                        visitRegion.registerVisit();
                                    }
                                    MapRegion i = visitRegion;
                                    synchronized (i) {
                                        if (visitRegion.isResting() && shouldRequestLoading && visitRegion.canRequestReload_unsynced() && visitRegion.getLoadState() != 2) {
                                            visitRegion.calculateSortingChunkDistance();
                                            Misc.addToListOfSmallest(10, this.regionBuffer, visitRegion);
                                        }
                                        continue;
                                    }
                                }
                            }
                            int toRequest = 1;
                            int counter = 0;
                            for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                                MapRegion region = this.regionBuffer.get(i);
                                if (region == nextToLoad && this.regionBuffer.size() > 1) continue;
                                MapRegion mapRegion = region;
                                synchronized (mapRegion) {
                                    if (!region.canRequestReload_unsynced() || region.getLoadState() == 2) {
                                        continue;
                                    }
                                    region.setBeingWritten(true);
                                    this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                                    if (counter == 0) {
                                        this.mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion<?>)region);
                                    }
                                    ++counter;
                                    if (region.getLoadState() == 4) {
                                        break;
                                    }
                                    continue;
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    private int getWriteDistance() {
        int limit;
        int n = limit = this.mapProcessor.getMapWorld().getCurrentDimension().isUsingWorldSave() ? Integer.MAX_VALUE : (Integer)WorldMap.INSTANCE.getConfigs().getClientConfigManager().getEffective((ConfigOption)WorldMapProfiledConfigOptions.WRITING_DISTANCE);
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        return Math.min(limit, Math.min(32, Minecraft.func_71410_x().field_71474_y.field_151451_c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMap(World world, double playerX, double playerY, double playerZ, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, int caveDepth, MapUpdateFastConfig config) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        World world2 = world;
        synchronized (world2) {
            if (this.insideX == 0 && this.insideZ == 0) {
                if (this.X == 0 && this.Z == 0) {
                    this.writtenCaveStart = this.caveStart;
                }
                this.mapProcessor.updateCaveStart();
                int newWritingLayer = this.mapProcessor.getCurrentCaveLayer();
                if (this.writingLayer != newWritingLayer && System.currentTimeMillis() - this.lastLayerSwitch > 300L) {
                    this.writingLayer = newWritingLayer;
                    this.lastLayerSwitch = System.currentTimeMillis();
                }
                this.loadDistance = this.getWriteDistance();
                if (this.writingLayer != Integer.MAX_VALUE && !(Minecraft.func_71410_x().field_71462_r instanceof GuiMap)) {
                    this.loadDistance = Math.min(16, this.loadDistance);
                }
                this.caveStart = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(this.writingLayer).getCaveStart();
                if (this.caveStart != this.writtenCaveStart) {
                    this.loadDistance = Math.min(4, this.loadDistance);
                }
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl25 : MonitorExitStatement: MONITOREXIT : var19_16
            int tileChunkX = this.startTileChunkX + this.X;
            int tileChunkZ = this.startTileChunkZ + this.Z;
            int tileChunkLocalX = tileChunkX & 7;
            int tileChunkLocalZ = tileChunkZ & 7;
            int chunkX = tileChunkX * 4 + this.insideX;
            int chunkZ = tileChunkZ * 4 + this.insideZ;
            boolean wasSkipped = this.writeChunk(world, this.loadDistance, onlyLoad, biomeColorCalculator, overlayManager, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug, mutableBlockPos3, caveDepth, this.caveStart, this.writingLayer, tileChunkX, tileChunkZ, tileChunkLocalX, tileChunkLocalZ, chunkX, chunkZ, config);
            return wasSkipped && (Math.abs(chunkX - this.playerChunkX) > 8 || Math.abs(chunkZ - this.playerChunkZ) > 8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeChunk(World world, int distance, boolean onlyLoad, BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, int caveDepth, int caveStart, int layerToWrite, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ, MapUpdateFastConfig updateConfig) {
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapTileChunk tileChunk = null;
        this.rightChunk = null;
        MapTileChunk bottomChunk = null;
        this.bottomRightChunk = null;
        MapRegion region = this.mapProcessor.getLeafMapRegion(layerToWrite, regionX, regionZ, true);
        boolean wasSkipped = true;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                boolean isProperLoadState;
                boolean createdTileChunk = false;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = isProperLoadState = region.getLoadState() == 2;
                    if (isProperLoadState) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (isProperLoadState && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                            region.setAllCachePrepared(false);
                            createdTileChunk = true;
                        }
                        if (!region.isNormalMapData()) {
                            region.getDim().getLayeredMapRegions().applyToEachLoadedLayer(this.otherLayerNotifier.get(region));
                        }
                    }
                }
                if (regionIsResting && isProperLoadState) {
                    if (tileChunk != null && tileChunk.getLoadState() == 2) {
                        if (!tileChunk.getLeafTexture().shouldUpload()) {
                            boolean cave = caveStart != Integer.MAX_VALUE;
                            boolean fullCave = caveStart == Integer.MIN_VALUE;
                            int lowH = 0;
                            if (cave && !fullCave && (lowH = caveStart + 1 - caveDepth) < 0) {
                                lowH = 0;
                            }
                            if (chunkX >= this.playerChunkX - distance && chunkX <= this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ <= this.playerChunkZ + distance) {
                                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                                MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                                boolean chunkUpdated = false;
                                try {
                                    chunkUpdated = chunk != null && (mapTile == null || mapTile.getWrittenCaveStart() != caveStart || mapTile.getWrittenCaveDepth() != caveDepth || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                                }
                                catch (IllegalAccessException | IllegalArgumentException e) {
                                    throw new RuntimeException(e);
                                }
                                if (chunkUpdated && chunk.func_177410_o()) {
                                    boolean connectedToOthers = false;
                                    block8: for (int i = -1; i < 2; ++i) {
                                        for (int j = -1; j < 2; ++j) {
                                            Chunk neighbor;
                                            if (i == 0 && j == 0 || (neighbor = world.func_72964_e(chunkX + i, chunkZ + j)) == null || !neighbor.func_177410_o()) continue;
                                            connectedToOthers = true;
                                            break block8;
                                        }
                                    }
                                    if (connectedToOthers && (mapTile == null && loadChunks || mapTile != null && updateChunks && (!onlyLoad || mapTile.getWrittenCaveStart() != caveStart || mapTile.getWrittenCaveDepth() != caveDepth))) {
                                        wasSkipped = false;
                                        if (mapTile == null) {
                                            mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                            tileChunk.setChanged(true);
                                        }
                                        MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                        int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                        MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                        MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                        boolean triedFetchingBottomChunk = false;
                                        boolean triedFetchingRightChunk = false;
                                        for (int x = 0; x < 16; ++x) {
                                            for (int z = 0; z < 16; ++z) {
                                                boolean xEdge;
                                                int mappedHeight = chunk.func_76611_b(x, z);
                                                int startHeight = cave && !fullCave ? caveStart : (ignoreHeightmaps || mappedHeight == -1 ? sectionBasedHeight : mappedHeight);
                                                MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                                this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, lowH, cave, fullCave, mappedHeight, mapTile.wasWrittenOnce(), ignoreHeightmaps, flowers, mutableBlockPos3);
                                                this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getEffectiveHeight(this.blockStateShortShapeCache, updateConfig), true, this.blockStateShortShapeCache, updateConfig);
                                                boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                                boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                                if (fullyEqual) continue;
                                                MapBlock loadedBlock = this.loadingObject;
                                                mapTile.setBlock(x, z, loadedBlock);
                                                this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                                if (equalsSlopesExcluded) continue;
                                                tileChunk.setChanged(true);
                                                boolean zEdge = z == 15;
                                                boolean bl = xEdge = x == 15;
                                                if (!zEdge && !xEdge || currentPixel != null && currentPixel.getEffectiveHeight(this.blockStateShortShapeCache, updateConfig) == loadedBlock.getEffectiveHeight(this.blockStateShortShapeCache, updateConfig)) continue;
                                                if (zEdge) {
                                                    if (!triedFetchingBottomChunk && bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                        bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                                                        triedFetchingBottomChunk = true;
                                                        MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                        if (bottomTile != null) {
                                                            bottomChunk.setChanged(true);
                                                        }
                                                    }
                                                    if (bottomTile != null && bottomTile.isLoaded()) {
                                                        bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                        if (!xEdge) {
                                                            bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                        }
                                                    }
                                                    if (!xEdge) continue;
                                                    this.updateBottomRightTile(region, tileChunk, bottomChunk, tileChunkLocalX, tileChunkLocalZ);
                                                    continue;
                                                }
                                                if (!xEdge) continue;
                                                if (!triedFetchingRightChunk && rightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                    this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                    triedFetchingRightChunk = true;
                                                    MapTile mapTile3 = rightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ) : null;
                                                    if (rightTile != null) {
                                                        this.rightChunk.setChanged(true);
                                                    }
                                                }
                                                if (rightTile == null || !rightTile.isLoaded()) continue;
                                                rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                            }
                                        }
                                        mapTile.setWorldInterpretationVersion(1);
                                        if (mapTile.getWrittenCaveStart() != caveStart) {
                                            tileChunk.setChanged(true);
                                        }
                                        mapTile.setWrittenCave(caveStart, caveDepth);
                                        tileChunk.setTile(this.insideX, this.insideZ, mapTile, this.blockStateShortShapeCache);
                                        mapTile.setWrittenOnce(true);
                                        mapTile.setLoaded(true);
                                        ReflectionUtils.setReflectFieldValue((Object)chunk, (Field)XaeroWorldMapCore.chunkCleanField, (Object)true);
                                    }
                                }
                            }
                        }
                        if (createdTileChunk) {
                            if (tileChunk.includeInSave()) {
                                tileChunk.setHasHadTerrain();
                            }
                            this.mapProcessor.getMapRegionHighlightsPreparer().prepare(region, tileChunkLocalX, tileChunkLocalZ, false);
                            if (!tileChunk.includeInSave() && !tileChunk.hasHighlightsIfUndiscovered()) {
                                region.setChunk(tileChunkLocalX, tileChunkLocalZ, null);
                                tileChunk = null;
                            }
                        }
                    }
                    if (tileChunk != null && this.insideX == 3 && this.insideZ == 3 && tileChunk.wasChanged()) {
                        tileChunk.updateBuffers(this.mapProcessor, biomeColorCalculator, overlayManager, detailedDebug, this.blockStateShortShapeCache, updateConfig);
                        if (bottomChunk == null && tileChunkLocalZ < 7) {
                            bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                        }
                        if (this.rightChunk == null && tileChunkLocalX < 7) {
                            this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                        }
                        if (this.bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                            this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                        }
                        if (bottomChunk != null && bottomChunk.wasChanged()) {
                            bottomChunk.updateBuffers(this.mapProcessor, biomeColorCalculator, overlayManager, detailedDebug, this.blockStateShortShapeCache, updateConfig);
                            bottomChunk.setChanged(false);
                        }
                        if (this.rightChunk != null && this.rightChunk.wasChanged()) {
                            this.rightChunk.setToUpdateBuffers(true);
                            this.rightChunk.setChanged(false);
                        }
                        if (this.bottomRightChunk != null && this.bottomRightChunk.wasChanged()) {
                            this.bottomRightChunk.setToUpdateBuffers(true);
                            this.bottomRightChunk.setChanged(false);
                        }
                        tileChunk.setChanged(false);
                    }
                }
            } else {
                this.insideX = 3;
                this.insideZ = 3;
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
        return wasSkipped;
    }

    public void updateBottomRightTile(MapRegion region, MapTileChunk tileChunk, MapTileChunk bottomChunk, int tileChunkLocalX, int tileChunkLocalZ) {
        MapTile bottomRightTile;
        MapTile mapTile = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
        if (bottomRightTile == null) {
            if (this.insideX == 3 && tileChunkLocalX < 7) {
                if (this.insideZ == 3) {
                    if (tileChunkLocalZ < 7) {
                        this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                    }
                    MapTile mapTile2 = bottomRightTile = this.bottomRightChunk != null ? this.bottomRightChunk.getTile(0, 0) : null;
                    if (bottomRightTile != null) {
                        this.bottomRightChunk.setChanged(true);
                    }
                } else {
                    if (this.rightChunk == null) {
                        this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                    }
                    MapTile mapTile3 = bottomRightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ + 1) : null;
                    if (bottomRightTile != null) {
                        this.rightChunk.setChanged(true);
                    }
                }
            } else if (this.insideX != 3 && this.insideZ == 3 && tileChunkLocalZ < 7) {
                MapTile mapTile4 = bottomRightTile = bottomChunk != null ? bottomChunk.getTile(this.insideX + 1, 0) : null;
                if (bottomRightTile != null) {
                    bottomChunk.setChanged(true);
                }
            }
        }
        if (bottomRightTile != null && bottomRightTile.isLoaded()) {
            bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
        }
    }

    public int getSectionBasedHeight(Chunk bchunk, int startY) {
        ExtendedBlockStorage searchedSection;
        int i;
        ExtendedBlockStorage[] sections = bchunk.func_76587_i();
        int playerSection = startY >> 4;
        int result = -1;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection == Chunk.field_186036_a) continue;
            result = (i << 4) + 15;
        }
        if (playerSection > 0 && result == -1) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection == Chunk.field_186036_a) continue;
                result = (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public boolean isGlowing(IBlockState state) {
        return (double)state.func_185906_d() >= 0.5;
    }

    private boolean shouldOverlayCached(IBlockState state) {
        return this.transparentCache.apply(state);
    }

    public boolean shouldOverlay(IBlockState state) {
        IBlockState blockState = state;
        if (blockState.func_177230_c() instanceof BlockAir || blockState.func_177230_c() instanceof BlockGlass || state.func_177230_c().func_180664_k() == BlockRenderLayer.TRANSLUCENT) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockLiquid) {
            int lightOpacity = state.getLightOpacity((IBlockAccess)this.mapProcessor.getWorld(), BlockPos.field_177992_a);
            return lightOpacity != 255 && lightOpacity != 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(IBlockState state, Block b, boolean flowers) {
        if (state.func_185901_i() == EnumBlockRenderType.INVISIBLE) {
            return true;
        }
        if (b == Blocks.field_150478_aa) {
            return true;
        }
        if (b == Blocks.field_150329_H) {
            return true;
        }
        if (b == Blocks.field_150359_w || b == Blocks.field_150410_aZ) {
            return true;
        }
        if (b == Blocks.field_150398_cm) {
            return true;
        }
        if ((b instanceof BlockFlower || b instanceof BlockDoublePlant) && !flowers) {
            return true;
        }
        ArrayList<IBlockState> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasVanillaColor(IBlockState state, World world, BlockPos pos) {
        MapColor materialColor = null;
        try {
            materialColor = state.func_185909_g((IBlockAccess)world, pos);
        }
        catch (Throwable t) {
            ArrayList<IBlockState> arrayList = this.buggedStates;
            synchronized (arrayList) {
                this.buggedStates.add(state);
            }
            WorldMap.LOGGER.info("Broken vanilla map color definition found: " + state.func_177230_c().getRegistryName());
        }
        return materialColor != null && materialColor.field_76291_p != 0;
    }

    private IBlockState unpackFramedBlocks(IBlockState original, World world, BlockPos globalPos) {
        TileEntity tileEntity;
        if (original.func_177230_c() instanceof BlockAir) {
            return original;
        }
        IBlockState result = original;
        if (SupportMods.framedBlocks() && SupportMods.supportFramedBlocks.isFrameBlock(null, original) && (tileEntity = world.func_175625_s(globalPos)) != null && ((result = SupportMods.supportFramedBlocks.unpackFramedBlock(null, original, tileEntity)) == null || result.func_177230_c() instanceof BlockAir)) {
            result = original;
        }
        return result;
    }

    public void loadPixel(World world, MapBlock pixel, MapBlock currentPixel, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean fullCave, int mappedHeight, boolean canReuseBiomeColours, boolean ignoreHeightmaps, boolean flowers, BlockPos.MutableBlockPos mutableBlockPos3) {
        IBlockState state;
        pixel.prepareForWriting();
        this.overlayBuilder.startBuilding();
        Object prevOverlay = null;
        boolean underair = !cave || fullCave;
        boolean shouldEnterGround = fullCave;
        IBlockState opaqueState = null;
        byte workingLight = -1;
        boolean worldHasSkyLight = world.field_73011_w.func_191066_m();
        byte workingSkyLight = worldHasSkyLight ? (byte)15 : 0;
        this.topH = lowY;
        this.mutableGlobalPos.func_181079_c((bchunk.func_76632_l().field_77276_a << 4) + insideX, lowY - 1, (bchunk.func_76632_l().field_77275_b << 4) + insideZ);
        boolean shouldExtendTillTheBottom = false;
        int transparentSkipY = 0;
        int h = highY;
        while (h >= lowY) {
            Block b;
            this.mutableLocalPos.func_181079_c(insideX, h, insideZ);
            this.mutableGlobalPos.func_185336_p(h);
            state = bchunk.func_177435_g((BlockPos)this.mutableLocalPos);
            if (state == null) {
                state = Blocks.field_150350_a.func_176223_P();
            }
            state = this.unpackFramedBlocks(state, world, (BlockPos)this.mutableGlobalPos);
            boolean bl = shouldExtendTillTheBottom = !shouldExtendTillTheBottom && !this.overlayBuilder.isEmpty() && this.firstTransparentStateY - h >= 5;
            if (shouldExtendTillTheBottom) {
                for (transparentSkipY = h - 1; transparentSkipY >= lowY; --transparentSkipY) {
                    IBlockState traceState = bchunk.func_177435_g((BlockPos)mutableBlockPos3.func_181079_c(insideX, transparentSkipY, insideZ));
                    if (traceState == null) {
                        traceState = Blocks.field_150350_a.func_176223_P();
                    }
                    if (!this.shouldOverlayCached(traceState)) break;
                }
            }
            if ((b = state.func_177230_c()) instanceof BlockAir) {
                underair = true;
            } else if (underair && !this.isInvisible(state, b, flowers)) {
                if (cave && shouldEnterGround) {
                    if (!(state.func_185904_a().func_76217_h() || state.func_185904_a().func_76222_j() || state.func_185904_a().func_186274_m() == EnumPushReaction.DESTROY || this.shouldOverlayCached(state))) {
                        underair = false;
                        shouldEnterGround = false;
                    }
                } else {
                    this.mutableLocalPos.func_185336_p(Math.min(255, h + 1));
                    workingLight = (byte)bchunk.func_177413_a(EnumSkyBlock.BLOCK, (BlockPos)this.mutableLocalPos);
                    if (cave && workingLight < 15 && worldHasSkyLight) {
                        workingSkyLight = !ignoreHeightmaps && !fullCave && highY >= mappedHeight ? (byte)15 : (byte)((byte)bchunk.func_177413_a(EnumSkyBlock.SKY, (BlockPos)this.mutableLocalPos));
                    }
                    if (this.shouldOverlayCached(state)) {
                        if (h > this.topH) {
                            this.topH = h;
                        }
                        byte overlayLight = workingLight;
                        if (this.overlayBuilder.isEmpty()) {
                            this.firstTransparentStateY = h;
                            if (cave && workingSkyLight > overlayLight) {
                                overlayLight = workingSkyLight;
                            }
                        }
                        if (shouldExtendTillTheBottom) {
                            this.overlayBuilder.getCurrentOverlay().increaseOpacity(Misc.getStateById(this.overlayBuilder.getCurrentOverlay().getState()).getLightOpacity((IBlockAccess)world, (BlockPos)this.mutableGlobalPos) * (h - transparentSkipY));
                        } else {
                            this.writerBiomeInfoSupplier.set(currentPixel, canReuseBiomeColours);
                            int stateId = Block.func_176210_f((IBlockState)state);
                            this.overlayBuilder.build(stateId, this.biomeBuffer, b.getLightOpacity(state, (IBlockAccess)world, (BlockPos)this.mutableGlobalPos), overlayLight, world, this.mapProcessor, (BlockPos)this.mutableGlobalPos, this.overlayBuilder.getOverlayBiome(), this.colorTypeCache, this.writerBiomeInfoSupplier);
                        }
                    } else if (this.hasVanillaColor(state, world, (BlockPos)this.mutableGlobalPos)) {
                        if (h > this.topH) {
                            this.topH = h;
                        }
                        opaqueState = state;
                        break;
                    }
                }
            }
            h = shouldExtendTillTheBottom ? transparentSkipY : h - 1;
        }
        if (h < lowY) {
            h = lowY;
        }
        state = opaqueState == null ? Blocks.field_150350_a.func_176223_P() : opaqueState;
        int stateId = Block.func_176210_f((IBlockState)state);
        this.overlayBuilder.finishBuilding(pixel);
        byte light = 0;
        if (opaqueState != null) {
            light = workingLight;
            if (cave && light < 15 && pixel.getNumberOfOverlays() == 0 && workingSkyLight > light) {
                light = workingSkyLight;
            }
        } else {
            h = 0;
        }
        if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != stateId) {
            this.colorTypeCache.getBlockBiomeColour(world, state, (BlockPos)this.mutableGlobalPos, this.biomeBuffer, -1);
        } else {
            this.biomeBuffer[0] = currentPixel.getColourType();
            this.biomeBuffer[1] = currentPixel.getBiome();
            this.biomeBuffer[2] = currentPixel.getCustomColour();
        }
        if (this.overlayBuilder.getOverlayBiome() != -1) {
            this.biomeBuffer[1] = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(stateId, h, this.topH, this.biomeBuffer, light, glowing, cave);
    }

    public int loadBlockColourFromTexture(int stateId, boolean convert, World world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.blockTintIndices.clear();
            this.lastBlockStateForTextureColor = -1;
            this.lastBlockStateForTextureColorResult = -1;
            this.clearCachedColours = false;
            if (WorldMapClientConfigUtils.getDebug()) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        if (stateId == this.lastBlockStateForTextureColor) {
            return this.lastBlockStateForTextureColorResult;
        }
        Integer c = this.blockColours.get(stateId);
        int red = 0;
        int green = 0;
        int blue = 0;
        int alpha = 0;
        IBlockState state = Misc.getStateById(stateId);
        Block b = state.func_177230_c();
        if (c == null) {
            String name = null;
            int tintIndex = -1;
            try {
                Integer cachedColour;
                TextureAtlasSprite texture;
                ResourceLocation blockResource;
                if (state instanceof IExtendedBlockState && ((blockResource = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)) == null || !blockResource.func_110624_b().equals("minecraft"))) {
                    Collection unlitedPropertyKeys = ((IExtendedBlockState)state).getUnlistedNames();
                    for (IUnlistedProperty p : unlitedPropertyKeys) {
                        if (((IExtendedBlockState)state).getValue(p) != null) continue;
                        throw new SilentException("Didn't pass the unlisted property check.");
                    }
                }
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                if (convert) {
                    upQuads = bms.func_178125_b(state).func_188616_a(state, EnumFacing.UP, 0L);
                }
                if (upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == bms.func_178126_b().func_174952_b().func_174944_f()) {
                    texture = bms.func_178122_a(state);
                    tintIndex = 0;
                } else {
                    texture = ((BakedQuad)upQuads.get(0)).func_187508_a();
                    tintIndex = ((BakedQuad)upQuads.get(0)).func_178211_c();
                }
                if (texture == null) {
                    throw new SilentException("No texture for " + state);
                }
                name = texture.func_94215_i() + ".png";
                if (b instanceof BlockOre && b != Blocks.field_150449_bY) {
                    name = "minecraft:blocks/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
                    if (resource == null) {
                        throw new SilentException("No texture " + location);
                    }
                    InputStream input = resource.func_110527_b();
                    BufferedImage img = TextureUtil.func_177053_a((InputStream)input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        Raster raster = img.getData();
                        int[] colorHolder = null;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb;
                                if (img.getColorModel().getNumComponents() < 3) {
                                    colorHolder = raster.getPixel(i * diff, j * diff, colorHolder);
                                    int sample = colorHolder[0] & 0xFF;
                                    int a = 255;
                                    if (colorHolder.length > 1) {
                                        a = colorHolder[1];
                                    }
                                    rgb = a << 24 | sample << 16 | sample << 8 | sample;
                                } else {
                                    rgb = img.getRGB(i * diff, j * diff);
                                }
                                int a = rgb >> 24 & 0xFF;
                                if (rgb == 0 || a == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                alpha += a;
                                ++total;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    alpha /= total;
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = alpha << 24 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(stateId, false, world, globalPos);
                }
                WorldMap.LOGGER.info("Block file not found: " + Block.field_149771_c.func_177774_c((Object)b));
                c = 0;
                if (state != null && state.func_185909_g((IBlockAccess)world, globalPos) != null) {
                    c = state.func_185909_g((IBlockAccess)world, (BlockPos)globalPos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.info("Exception when loading " + Block.field_149771_c.func_177774_c((Object)b) + " texture, using material colour.");
                c = 0;
                if (state.func_185909_g((IBlockAccess)world, globalPos) != null) {
                    c = state.func_185909_g((IBlockAccess)world, (BlockPos)globalPos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                if (e instanceof SilentException) {
                    WorldMap.LOGGER.info(e.getMessage());
                }
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
            if (c != null) {
                this.blockColours.put(stateId, c);
                this.blockTintIndices.put((Object)state, tintIndex);
            }
        }
        this.lastBlockStateForTextureColor = stateId;
        this.lastBlockStateForTextureColorResult = c;
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public BlockStateColorTypeCache getColorTypeCache() {
        return this.colorTypeCache;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public void setDirtyInWriteDistance(EntityPlayer player, World level) {
        int writeDistance = this.getWriteDistance();
        int playerChunkX = player.func_180425_c().func_177958_n() >> 4;
        int playerChunkZ = player.func_180425_c().func_177952_p() >> 4;
        int startChunkX = playerChunkX - writeDistance;
        int startChunkZ = playerChunkZ - writeDistance;
        int endChunkX = playerChunkX + writeDistance;
        int endChunkZ = playerChunkZ + writeDistance;
        for (int x = startChunkX; x < endChunkX; ++x) {
            for (int z = startChunkZ; z < endChunkZ; ++z) {
                Chunk chunk = level.func_72964_e(x, z);
                if (chunk == null) continue;
                try {
                    XaeroWorldMapCore.chunkCleanField.set(chunk, false);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public int getBlockTintIndex(IBlockState state) {
        return this.blockTintIndices.getInt((Object)state);
    }

    public final class OtherLayerNotifier
    implements BiConsumer<Integer, MapLayer> {
        private MapRegion region;

        public OtherLayerNotifier get(MapRegion region) {
            this.region = region;
            return this;
        }

        @Override
        public void accept(Integer i, MapLayer u) {
            if (i.intValue() != this.region.getCaveLayer()) {
                MapRegion sameRegionAnotherLayer = MapWriter.this.mapProcessor.getLeafMapRegion(i, this.region.getRegionX(), this.region.getRegionZ(), true);
                sameRegionAnotherLayer.setOutdatedWithOtherLayers(true);
                sameRegionAnotherLayer.setHasHadTerrain();
            }
        }
    }
}

