/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.lib.common.util.IOUtils;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.RegionDetection;
import xaero.map.file.export.PNGExportResult;
import xaero.map.file.export.PNGExporter;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.gui.ExportScreen;
import xaero.map.gui.MapTileSelection;
import xaero.map.misc.Misc;
import xaero.map.region.BranchLeveledRegion;
import xaero.map.region.LayeredRegionManager;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapBlock;
import xaero.map.region.MapLayer;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;
import xaero.map.task.MapRunnerTask;
import xaero.map.world.MapDimension;

public class MapSaveLoad {
    private static final int currentSaveMajorVersion = 0;
    private static final int currentSaveMinorVersion = 8;
    private static final int currentSaveVersion = 8;
    public static final int SAVE_TIME = 60000;
    public static final int currentCacheSaveVersion = 24;
    private ArrayList<MapRegion> toSave = new ArrayList();
    private ArrayList<MapRegion> toLoad = new ArrayList();
    private ArrayList<BranchLeveledRegion> toLoadBranchCache = new ArrayList();
    private ArrayList<File> cacheToConvertFromTemp = new ArrayList();
    private LeveledRegion<?> nextToLoadByViewing;
    private boolean regionDetectionComplete;
    private Path lastRealmOwnerPath;
    public boolean loadingFiles;
    private OverlayBuilder overlayBuilder;
    private PNGExporter pngExporter;
    private List<MapDimension> workingDimList;
    public boolean saveAll;
    private MapProcessor mapProcessor;
    public int mainTextureLevel;
    private BiomeInfoSupplier biomeInfoSupplier;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private boolean exporting;

    public MapSaveLoad(OverlayManager overlayManager, PNGExporter pngExporter, BlockStateShortShapeCache blockStateShortShapeCache) {
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.pngExporter = pngExporter;
        this.workingDimList = new ArrayList<MapDimension>();
        this.biomeInfoSupplier = new BiomeInfoSupplier(){

            @Override
            public void getBiomeInfo(BlockStateColorTypeCache colorTypeCache, World world, IBlockState state, BlockPos pos, int[] dest, int biomeId) {
                colorTypeCache.getBlockBiomeColour(world, state, pos, dest, biomeId);
            }
        };
        this.blockStateShortShapeCache = blockStateShortShapeCache;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public boolean exportPNG(final ExportScreen destScreen, final MapTileSelection selection) {
        if (this.exporting) {
            return false;
        }
        this.exporting = true;
        WorldMap.mapRunner.addTask(new MapRunnerTask(){

            @Override
            public void run(final MapProcessor mapProcessor) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PNGExportResult result = MapSaveLoad.this.pngExporter.export(mapProcessor, selection);
                            WorldMap.LOGGER.info(result.getMessage().func_150260_c());
                            if (destScreen != null) {
                                destScreen.onExportDone(result);
                            }
                            if (result.getFolderToOpen() != null && Files.exists(result.getFolderToOpen(), new LinkOption[0])) {
                                Desktop d = Desktop.getDesktop();
                                try {
                                    d.open(result.getFolderToOpen().toFile());
                                }
                                catch (IOException e) {
                                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            WorldMap.LOGGER.error("Failed to export PNG with exception!", e);
                            WorldMap.crashHandler.setCrashedBy(e);
                        }
                        MapSaveLoad.this.exporting = false;
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)destScreen);
                    }
                });
                while (MapSaveLoad.this.exporting) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        return true;
    }

    private File getSecondaryFile(String extension, File realFile) {
        if (realFile == null) {
            return null;
        }
        String p = realFile.getPath();
        if (p.endsWith(".outdated")) {
            p = p.substring(0, p.length() - ".outdated".length());
        }
        return new File(p.substring(0, p.lastIndexOf(".")) + extension);
    }

    public File getTempFile(File realFile) {
        return this.getSecondaryFile(".zip.temp", realFile);
    }

    private Path getCacheFolder(Path subFolder) {
        if (subFolder != null) {
            return subFolder.resolve("cache_" + this.mapProcessor.getGlobalVersion());
        }
        return null;
    }

    public File getCacheFile(MapRegionInfo region, int caveLayer, boolean checkOutdated, boolean requestCache) throws IOException {
        Path outdatedCacheFile;
        Path subFolder = this.getMWSubFolder(region.getWorldId(), region.getDimId(), region.getMwId());
        Path layerFolder = this.getCaveLayerFolder(caveLayer, subFolder);
        Path latestCacheFolder = this.getCacheFolder(layerFolder);
        if (latestCacheFolder == null) {
            return null;
        }
        if (!Files.exists(latestCacheFolder, new LinkOption[0])) {
            Files.createDirectories(latestCacheFolder, new FileAttribute[0]);
        }
        Path cacheFile = latestCacheFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".xwmc");
        if (!checkOutdated || Files.exists(cacheFile, new LinkOption[0])) {
            return cacheFile.toFile();
        }
        if (requestCache) {
            region.setShouldCache(true, "cache file");
        }
        if (Files.exists(outdatedCacheFile = cacheFile.resolveSibling(cacheFile.getFileName().toString() + ".outdated"), new LinkOption[0])) {
            return outdatedCacheFile.toFile();
        }
        return cacheFile.toFile();
    }

    public File getFile(MapRegion region) {
        if (region.getWorldId() == null) {
            return null;
        }
        File detectedFile = region.getRegionFile();
        boolean normalMapData = region.isNormalMapData();
        if (!normalMapData) {
            if (detectedFile != null) {
                return detectedFile;
            }
            return this.mapProcessor.getWorldDataHandler().getWorldDir().toPath().resolve("region").resolve("r." + region.getRegionX() + "." + region.getRegionZ() + ".mca").toFile();
        }
        return this.getNormalFile(region);
    }

    public File getNormalFile(MapRegion region) {
        Path subFolder;
        if (region.getWorldId() == null) {
            return null;
        }
        File detectedFile = region.isNormalMapData() ? region.getRegionFile() : null;
        boolean realms = MapProcessor.isWorldRealms(region.getWorldId());
        String mwId = region.isNormalMapData() ? region.getMwId() : "cm$converted";
        Path mainFolder = this.getMainFolder(region.getWorldId(), region.getDimId());
        Path layerFolder = subFolder = this.getMWSubFolder(region.getWorldId(), mainFolder, mwId);
        if (region.getCaveLayer() != Integer.MAX_VALUE) {
            layerFolder = layerFolder.resolve("caves").resolve("" + region.getCaveLayer());
        }
        try {
            File subFolderFile = layerFolder.toFile();
            if (!subFolderFile.exists()) {
                Path ownerPath;
                Files.createDirectories(subFolderFile.toPath(), new FileAttribute[0]);
                if (realms && WorldMap.events.getLatestRealm() != null && !(ownerPath = mainFolder.resolve(WorldMap.events.getLatestRealm().owner + ".owner")).equals(this.lastRealmOwnerPath)) {
                    if (!Files.exists(ownerPath, new LinkOption[0])) {
                        Files.createFile(ownerPath, new FileAttribute[0]);
                    }
                    this.lastRealmOwnerPath = ownerPath;
                }
            }
        }
        catch (IOException e1) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e1);
        }
        if (detectedFile != null && detectedFile.getName().endsWith(".xaero")) {
            File zipFile = layerFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile();
            if (detectedFile.exists() && !zipFile.exists()) {
                this.xaeroToZip(detectedFile);
            }
            region.setRegionFile(zipFile);
            return zipFile;
        }
        return detectedFile == null ? layerFolder.resolve(region.getRegionX() + "_" + region.getRegionZ() + ".zip").toFile() : detectedFile;
    }

    public static Path getRootFolder(String world) {
        if (world == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(world);
    }

    public Path getMainFolder(String world, String dim) {
        if (world == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(world).resolve(dim);
    }

    Path getMWSubFolder(String world, Path mainFolder, String mw) {
        if (world == null) {
            return null;
        }
        if (mw == null) {
            return mainFolder;
        }
        return mainFolder.resolve(mw);
    }

    public Path getCaveLayerFolder(int caveLayer, Path subFolder) {
        Path layerFolder = subFolder;
        if (caveLayer != Integer.MAX_VALUE) {
            layerFolder = subFolder.resolve("caves").resolve("" + caveLayer);
        }
        return layerFolder;
    }

    public Path getMWSubFolder(String world, String dim, String mw) {
        if (world == null) {
            return null;
        }
        return this.getMWSubFolder(world, this.getMainFolder(world, dim), mw);
    }

    public Path getOldFolder(String oldUnfixedMainId, String dim) {
        if (oldUnfixedMainId == null) {
            return null;
        }
        return WorldMap.saveFolder.toPath().resolve(oldUnfixedMainId + "_" + dim);
    }

    private void xaeroToZip(File xaero) {
        File zipFile = xaero.toPath().getParent().resolve(xaero.getName().substring(0, xaero.getName().lastIndexOf(46)) + ".zip").toFile();
        try {
            int got;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(xaero), 1024);
            ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));
            ZipEntry e = new ZipEntry("region.xaero");
            zipOutput.putNextEntry(e);
            byte[] bytes = new byte[1024];
            while ((got = in.read(bytes)) > 0) {
                zipOutput.write(bytes, 0, got);
            }
            zipOutput.closeEntry();
            zipOutput.flush();
            zipOutput.close();
            in.close();
            Files.deleteIfExists(xaero.toPath());
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            return;
        }
    }

    public void detectRegions(int attempts) {
        final MapDimension mapDimension = this.mapProcessor.getMapWorld().getCurrentDimension();
        mapDimension.preDetection();
        final String worldId = this.mapProcessor.getCurrentWorldId();
        if (worldId == null || this.mapProcessor.isCurrentMapLocked()) {
            return;
        }
        final String dimId = this.mapProcessor.getCurrentDimId();
        final String mwId = this.mapProcessor.getCurrentMWId();
        final boolean usingNormalMapData = !mapDimension.isUsingWorldSave();
        Path mapFolder = this.getMWSubFolder(worldId, dimId, mwId);
        boolean mapFolderExists = mapFolder.toFile().exists();
        String multiplayerMapRegex = "^(-?\\d+)_(-?\\d+)\\.(zip|xaero)$";
        final MapLayer mainLayer = mapDimension.getLayeredMapRegions().getLayer(Integer.MAX_VALUE);
        if (usingNormalMapData) {
            if (mapFolderExists) {
                this.detectRegionsFromFiles(mapDimension, worldId, dimId, mwId, mapFolder, "^(-?\\d+)_(-?\\d+)\\.(zip|xaero)$", 1, 2, 0, 20, new Consumer<RegionDetection>(){

                    @Override
                    public void accept(RegionDetection detect) {
                        mainLayer.addRegionDetection(detect);
                    }
                });
            }
        } else {
            File worldDir = this.mapProcessor.getWorldDataHandler().getWorldDir();
            if (worldDir == null) {
                return;
            }
            Path worldFolder = worldDir.toPath().resolve("region");
            if (!worldFolder.toFile().exists()) {
                return;
            }
            this.detectRegionsFromFiles(mapDimension, worldId, dimId, mwId, worldFolder, "^r\\.(-{0,1}[0-9]+)\\.(-{0,1}[0-9]+)\\.mc[ar]$", 1, 2, 8192, 20, new Consumer<RegionDetection>(){

                @Override
                public void accept(RegionDetection detect) {
                    mapDimension.addWorldSaveRegionDetection(detect);
                }
            });
        }
        if (mapFolderExists) {
            Path cavesFolder = mapFolder.resolve("caves");
            try {
                if (!Files.exists(cavesFolder, new LinkOption[0])) {
                    Files.createDirectories(cavesFolder, new FileAttribute[0]);
                }
                try (Stream<Path> cavesFolderStream = Files.list(cavesFolder);){
                    cavesFolderStream.forEach(new Consumer<Path>(){

                        @Override
                        public void accept(Path layerFolder) {
                            if (!Files.isDirectory(layerFolder, new LinkOption[0])) {
                                return;
                            }
                            String folderName = layerFolder.getFileName().toString();
                            try {
                                int layerInt = Integer.parseInt(folderName);
                                final MapLayer layer = mapDimension.getLayeredMapRegions().getLayer(layerInt);
                                if (usingNormalMapData) {
                                    MapSaveLoad.this.detectRegionsFromFiles(mapDimension, worldId, dimId, mwId, layerFolder, "^(-?\\d+)_(-?\\d+)\\.(zip|xaero)$", 1, 2, 0, 20, new Consumer<RegionDetection>(){

                                        @Override
                                        public void accept(RegionDetection detect) {
                                            layer.addRegionDetection(detect);
                                        }
                                    });
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (IOException e) {
                WorldMap.LOGGER.error("IOException trying to detect map layers!");
                if (attempts > 1) {
                    WorldMap.LOGGER.error("Retrying... " + --attempts);
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.detectRegions(attempts);
                    return;
                }
                throw new RuntimeException("Couldn't detect map layers after multiple attempts.", e);
            }
        }
    }

    public void detectRegionsFromFiles(MapDimension mapDimension, String worldId, String dimId, String mwId, Path folder, String regex, int xIndex, int zIndex, int emptySize, int attempts, Consumer<RegionDetection> detectionConsumer) {
        int total = 0;
        Pattern fileRegexPattern = Pattern.compile(regex);
        long before = System.currentTimeMillis();
        try {
            Stream<Path> files = Files.list(folder);
            Iterator iter = files.iterator();
            int globalVersion = this.mapProcessor.getGlobalVersion();
            while (!this.mapProcessor.isFinalizing() && iter.hasNext()) {
                Path file = (Path)iter.next();
                String regionName = file.getFileName().toString();
                Matcher matcher = fileRegexPattern.matcher(regionName);
                if (!matcher.matches()) continue;
                int x = Integer.parseInt(matcher.group(xIndex));
                int z = Integer.parseInt(matcher.group(zIndex));
                RegionDetection regionDetection = new RegionDetection(worldId, dimId, mwId, x, z, file.toFile(), globalVersion, true);
                detectionConsumer.accept(regionDetection);
                ++total;
            }
            files.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("IOException trying to detect map files!");
            if (attempts > 1) {
                WorldMap.LOGGER.error("Retrying... " + --attempts);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.detectRegionsFromFiles(mapDimension, worldId, dimId, mwId, folder, regex, xIndex, zIndex, emptySize, attempts, detectionConsumer);
                return;
            }
            throw new RuntimeException("Couldn't detect map files after multiple attempts.", e);
        }
        if (WorldMapClientConfigUtils.getDebug()) {
            WorldMap.LOGGER.info(String.format("%d regions detected in %d ms!", total, System.currentTimeMillis() - before));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveRegion(MapRegion region, boolean debugConfig, int extraAttempts) {
        try {
            if (!region.hasHadTerrain()) {
                if (debugConfig) {
                    WorldMap.LOGGER.info("Save not required for highlight-only region: " + region + " " + region.getWorldId() + " " + region.getDimId());
                }
                return region.countChunks() > 0;
            }
            if (!region.isResaving() && !region.isNormalMapData()) {
                if (debugConfig) {
                    WorldMap.LOGGER.info("Save not required for world save map: " + region + " " + region.getWorldId() + " " + region.getDimId());
                }
                return region.countChunks() > 0;
            }
            File permFile = this.getNormalFile(region);
            if (!permFile.toPath().startsWith(WorldMap.saveFolder.toPath())) {
                throw new IllegalArgumentException();
            }
            File file = this.getTempFile(permFile);
            if (file == null) {
                return true;
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            boolean hasAnything = false;
            boolean regionWasSavedEmpty = true;
            try (FilterOutputStream out = null;){
                ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                out = new DataOutputStream(zipOut);
                ZipEntry e = new ZipEntry("region.xaero");
                zipOut.putNextEntry(e);
                ((DataOutputStream)out).write(255);
                ((DataOutputStream)out).writeInt(8);
                for (int o = 0; o < 8; ++o) {
                    for (int p = 0; p < 8; ++p) {
                        BranchLeveledRegion parentRegion;
                        MapTileChunk chunk = region.getChunk(o, p);
                        if (chunk == null) continue;
                        hasAnything = true;
                        if (chunk.includeInSave()) {
                            ((DataOutputStream)out).write(o << 4 | p);
                            boolean chunkIsEmpty = true;
                            for (int i = 0; i < 4; ++i) {
                                for (int j = 0; j < 4; ++j) {
                                    MapTile tile = chunk.getTile(i, j);
                                    if (tile != null && tile.isLoaded()) {
                                        chunkIsEmpty = false;
                                        for (int x = 0; x < 16; ++x) {
                                            MapBlock[] c = tile.getBlockColumn(x);
                                            for (int z = 0; z < 16; ++z) {
                                                this.savePixel(c[z], (DataOutputStream)out);
                                            }
                                        }
                                        ((DataOutputStream)out).write(tile.getWorldInterpretationVersion());
                                        ((DataOutputStream)out).writeInt(tile.getWrittenCaveStart());
                                        ((DataOutputStream)out).write(tile.getWrittenCaveDepth());
                                        continue;
                                    }
                                    ((DataOutputStream)out).writeInt(-1);
                                }
                            }
                            if (chunkIsEmpty) continue;
                            regionWasSavedEmpty = false;
                            continue;
                        }
                        if (!chunk.hasHighlightsIfUndiscovered()) {
                            region.setChunk(o, p, null);
                            MapTileChunk chunkIsEmpty = chunk;
                            synchronized (chunkIsEmpty) {
                                chunk.getLeafTexture().deleteTexturesAndBuffers();
                            }
                        }
                        if ((parentRegion = region.getParent()) == null) continue;
                        parentRegion.setShouldCheckForUpdatesRecursive(true);
                    }
                }
                zipOut.closeEntry();
            }
            if (regionWasSavedEmpty) {
                this.safeDelete(permFile.toPath(), ".zip");
                this.safeDelete(file.toPath(), ".temp");
                if (debugConfig) {
                    WorldMap.LOGGER.info("Save cancelled because the region would be saved empty: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                }
                return hasAnything;
            }
            this.safeMoveAndReplace(file.toPath(), permFile.toPath(), ".temp", ".zip");
            if (debugConfig) {
                WorldMap.LOGGER.info("Region saved: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + this.mapProcessor.getMapWriter().getUpdateCounter());
            }
            return true;
        }
        catch (IOException ioe) {
            WorldMap.LOGGER.error("IO exception while trying to save " + region, (Throwable)ioe);
            if (extraAttempts > 0) {
                WorldMap.LOGGER.info("(World Map) Retrying...");
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.saveRegion(region, debugConfig, extraAttempts - 1);
            }
            return true;
        }
    }

    private Path getBackupFolder(Path filePath, int saveVersion, int backupVersion) {
        return filePath.getParent().resolve(saveVersion + "_backup_" + backupVersion);
    }

    public void backupFile(File file, int saveVersion) throws IOException {
        if (file.getName().endsWith(".mca") || file.getName().endsWith(".mcr")) {
            throw new RuntimeException("World save protected: " + file);
        }
        Path filePath = file.toPath();
        int backupVersion = 0;
        Path backupFolder = this.getBackupFolder(filePath, saveVersion, backupVersion);
        String backupName = filePath.getFileName().toString();
        Path backup = backupFolder.resolve(backupName);
        while (Files.exists(backup, new LinkOption[0])) {
            backupFolder = this.getBackupFolder(filePath, saveVersion, ++backupVersion);
            backup = backupFolder.resolve(backupName);
        }
        if (!Files.exists(backupFolder, new LinkOption[0])) {
            Files.createDirectories(backupFolder, new FileAttribute[0]);
        }
        Files.move(file.toPath(), backup, new CopyOption[0]);
        WorldMap.LOGGER.info("File " + file.getPath() + " backed up to " + backupFolder.toFile().getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean loadRegion(World world, MapRegion region, BlockStateColorTypeCache colourTypeCache, boolean debugConfig, int extraAttempts) {
        boolean multiplayer = region.isNormalMapData();
        int emptySize = multiplayer ? 0 : 8192;
        int saveVersion = -1;
        boolean versionReached = false;
        int[] biomeBuffer = new int[3];
        try {
            boolean result;
            File file = this.getFile(region);
            if (!region.hasHadTerrain() || file == null || !file.exists() || Files.size(file.toPath()) <= (long)emptySize) {
                if (region.getLoadState() == 4 || region.hasHadTerrain()) {
                    region.setSaveExists(null);
                }
                if (region.hasHadTerrain()) {
                    return false;
                }
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    region.setLoadState((byte)1);
                }
                region.restoreBufferUpdateObjects();
                if (debugConfig) {
                    WorldMap.LOGGER.info("Highlight region fake-loaded: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                }
                return true;
            }
            MapRegion mapRegion = region;
            synchronized (mapRegion) {
                region.setLoadState((byte)1);
            }
            region.setSaveExists(true);
            region.restoreBufferUpdateObjects();
            int totalChunks = 0;
            if (multiplayer) {
                try (FilterInputStream in = null;){
                    ZipInputStream zipIn = new ZipInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
                    in = new DataInputStream(zipIn);
                    zipIn.getNextEntry();
                    int firstByte = in.read();
                    if (firstByte == 255) {
                        saveVersion = ((DataInputStream)in).readInt();
                        if (8 < saveVersion) {
                            zipIn.closeEntry();
                            in.close();
                            WorldMap.LOGGER.info("Trying to load a newer region " + region + " save using an older version of Xaero's World Map!");
                            this.backupFile(file, saveVersion);
                            region.setSaveExists(null);
                            boolean bl = false;
                            return bl;
                        }
                        firstByte = -1;
                    }
                    versionReached = true;
                    LeveledRegion leveledRegion = region.getLevel() == 3 ? region : region.getParent();
                    synchronized (leveledRegion) {
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    MapTileChunk chunk = region.getChunk(o, p);
                                    if (chunk == null) continue;
                                    chunk.setLoadState((byte)1);
                                }
                            }
                        }
                    }
                    while (true) {
                        int n;
                        int n2 = n = firstByte == -1 ? in.read() : firstByte;
                        if (n == -1) break;
                        firstByte = -1;
                        int o = n >> 4;
                        int p = n & 0xF;
                        MapTileChunk chunk = region.getChunk(o, p);
                        if (chunk == null) {
                            chunk = new MapTileChunk(region, region.getRegionX() * 8 + o, region.getRegionZ() * 8 + p);
                            region.setChunk(o, p, chunk);
                        } else if (chunk.getLoadState() >= 2) {
                            throw new Exception("Map data for region " + region + " is probably corrupt! Has the same map tile chunk saved twice.");
                        }
                        if (region.isMetaLoaded()) {
                            chunk.getLeafTexture().setBufferedTextureVersion(region.getAndResetCachedTextureVersion(o, p));
                        }
                        chunk.resetHeights();
                        for (int i = 0; i < 4; ++i) {
                            for (int j = 0; j < 4; ++j) {
                                Integer nextTile = ((DataInputStream)in).readInt();
                                if (nextTile == -1) continue;
                                MapTile tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunk.getX() * 4 + i, chunk.getZ() * 4 + j);
                                for (int x = 0; x < 16; ++x) {
                                    MapBlock[] c = tile.getBlockColumn(x);
                                    for (int z = 0; z < 16; ++z) {
                                        if (c[z] == null) {
                                            c[z] = new MapBlock();
                                        } else {
                                            c[z].prepareForWriting();
                                        }
                                        this.loadPixel(nextTile, c[z], (DataInputStream)in, saveVersion, world, biomeBuffer, colourTypeCache);
                                        nextTile = null;
                                    }
                                }
                                if (saveVersion >= 4) {
                                    tile.setWorldInterpretationVersion(in.read());
                                }
                                if (saveVersion >= 6) {
                                    tile.setWrittenCave(((DataInputStream)in).readInt(), saveVersion >= 7 ? in.read() : 32);
                                }
                                chunk.setTile(i, j, tile, this.blockStateShortShapeCache);
                                tile.setLoaded(true);
                            }
                        }
                        if (!chunk.includeInSave()) {
                            if (chunk.hasHighlightsIfUndiscovered()) continue;
                            region.setChunk(o, p, null);
                            chunk.getLeafTexture().deleteTexturesAndBuffers();
                            chunk = null;
                            continue;
                        }
                        region.pushWriterPause();
                        ++totalChunks;
                        chunk.setToUpdateBuffers(true);
                        chunk.setLoadState((byte)2);
                        region.popWriterPause();
                    }
                    zipIn.closeEntry();
                }
                if (totalChunks > 0) {
                    if (debugConfig) {
                        WorldMap.LOGGER.info("Region loaded: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + saveVersion);
                    }
                    return true;
                }
                region.setSaveExists(null);
                this.safeDelete(file.toPath(), ".zip");
                if (debugConfig) {
                    WorldMap.LOGGER.info("Cancelled loading an empty region: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + saveVersion);
                }
                return false;
            }
            int[] chunkCount = new int[1];
            WorldDataHandler.Result buildResult = this.mapProcessor.getWorldDataHandler().buildRegion(world, region, true, chunkCount);
            if (buildResult == WorldDataHandler.Result.CANCEL) {
                if (region.hasHadTerrain()) {
                    RegionDetection restoredDetection = new RegionDetection(region.getWorldId(), region.getDimId(), region.getMwId(), region.getRegionX(), region.getRegionZ(), region.getRegionFile(), this.mapProcessor.getGlobalVersion(), true);
                    restoredDetection.transferInfoFrom(region);
                    region.getDim().getLayeredMapRegions().getLayer(region.getCaveLayer()).addRegionDetection(restoredDetection);
                }
                this.mapProcessor.removeMapRegion(region);
                WorldMap.LOGGER.info("Region cancelled from world save: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                return false;
            }
            region.setRegionFile(file);
            boolean bl = result = buildResult == WorldDataHandler.Result.SUCCESS && chunkCount[0] > 0;
            if (!result) {
                region.setSaveExists(null);
                if (debugConfig) {
                    WorldMap.LOGGER.info("Region failed to load from world save: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
                }
            } else if (debugConfig) {
                WorldMap.LOGGER.info("Region loaded from world save: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId());
            }
            return result;
        }
        catch (IOException ioe) {
            WorldMap.LOGGER.error("IO exception while trying to load " + region, (Throwable)ioe);
            if (extraAttempts > 0) {
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    region.setLoadState((byte)4);
                }
                WorldMap.LOGGER.info("(World Map) Retrying...");
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.loadRegion(world, region, colourTypeCache, debugConfig, extraAttempts - 1);
            }
            region.setSaveExists(null);
            return false;
        }
        catch (Throwable e) {
            region.setSaveExists(null);
            WorldMap.LOGGER.error("Region failed to load: " + region + (versionReached ? " " + saveVersion : ""), e);
            return false;
        }
    }

    public boolean beingSaved(MapDimension dim, int regX, int regZ) {
        for (int i = 0; i < this.toSave.size(); ++i) {
            MapRegion r = this.toSave.get(i);
            if (r == null || r.getDim() != dim || r.getRegionX() != regX || r.getRegionZ() != regZ) continue;
            return true;
        }
        return false;
    }

    public void requestLoad(MapRegion region, String reason) {
        this.requestLoad(region, reason, true);
    }

    public void requestLoad(MapRegion region, String reason, boolean prioritize) {
        this.addToLoad(region, reason, prioritize);
    }

    public void requestBranchCache(BranchLeveledRegion region, String reason) {
        this.requestBranchCache(region, reason, true);
        if (reason == null) {
            return;
        }
        if (WorldMapClientConfigUtils.getDebug()) {
            WorldMap.LOGGER.info("Requesting branch load for: " + region + ", " + reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBranchCache(BranchLeveledRegion region, String reason, boolean prioritize) {
        ArrayList<BranchLeveledRegion> arrayList = this.toLoadBranchCache;
        synchronized (arrayList) {
            if (prioritize) {
                this.toLoadBranchCache.remove(region);
                this.toLoadBranchCache.add(0, region);
            } else if (!this.toLoadBranchCache.contains(region)) {
                this.toLoadBranchCache.add(region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLoad(MapRegion region, String reason, boolean prioritize) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            if (prioritize) {
                region.setReloadHasBeenRequested(true, reason);
                this.toLoad.remove(region);
                this.toLoad.add(0, region);
                if (WorldMapClientConfigUtils.getDebug() && reason != null) {
                    WorldMap.LOGGER.info("Requesting load for: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + reason);
                }
            } else if (!this.loadingFiles && !this.toLoad.contains(region)) {
                region.setReloadHasBeenRequested(true, reason);
                this.toLoad.add(region);
                if (WorldMapClientConfigUtils.getDebug() && reason != null) {
                    WorldMap.LOGGER.info("Requesting load for: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + ", " + reason);
                }
            }
        }
        this.mapProcessor.getMapRegionHighlightsPreparer().prepare(region, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToLoad(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToLoad() {
        ArrayList<LeveledRegion> arrayList = this.toLoad;
        synchronized (arrayList) {
            this.toLoad.clear();
        }
        arrayList = this.toLoadBranchCache;
        synchronized (arrayList) {
            this.toLoadBranchCache.clear();
        }
    }

    public int getSizeOfToLoad() {
        return this.toLoad.size();
    }

    public boolean saveExists(MapRegion region) {
        if (region.getSaveExists() != null) {
            return region.getSaveExists();
        }
        boolean result = true;
        File file = this.getFile(region);
        if (file == null || !file.exists()) {
            result = false;
        }
        region.setSaveExists(result);
        return result;
    }

    public void updateSave(LeveledRegion<?> leveledRegion, long currentTime, int currentLayer) {
        if (leveledRegion.getLevel() == 0) {
            MapRegion region = (MapRegion)leveledRegion;
            int saveTime = 60000;
            if (region.getCaveLayer() != currentLayer) {
                saveTime /= 100;
            }
            if (region.getLoadState() == 2 && region.isBeingWritten() && currentTime - region.getLastSaveTime() >= (long)saveTime && !this.beingSaved(region.getDim(), region.getRegionX(), region.getRegionZ())) {
                this.toSave.add(region);
                region.setSaveExists(true);
                region.setLastSaveTime(currentTime);
            }
        } else {
            BranchLeveledRegion region = (BranchLeveledRegion)leveledRegion;
            if (region.eligibleForSaving(currentTime)) {
                region.startDownloadingTexturesForCache(this.mapProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(World world, BlockStateColorTypeCache colourTypeCache) throws Exception {
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean debugConfig = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DEBUG);
        int globalVersion = this.mapProcessor.getGlobalVersion();
        if (!this.toLoad.isEmpty()) {
            boolean loaded = false;
            this.mapProcessor.pushIsLoading();
            this.loadingFiles = true;
            boolean reloadEverything = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED);
            int limit = this.toLoad.size();
            while (!(limit <= 0 || this.mapProcessor.isWaitingForWorldUpdate() || loaded || this.toLoad.isEmpty())) {
                boolean needsLoading;
                MapRegion region;
                --limit;
                ArrayList<MapRegion> arrayList = this.toLoad;
                synchronized (arrayList) {
                    if (this.toLoad.isEmpty()) {
                        break;
                    }
                    region = this.toLoad.get(0);
                }
                if (region.hasHadTerrain() && region.getCacheFile() == null && !region.hasLookedForCache()) {
                    File potentialCacheFile = this.getCacheFile(region, region.getCaveLayer(), true, true);
                    if (potentialCacheFile.exists()) {
                        region.setCacheFile(potentialCacheFile);
                    }
                    region.setLookedForCache(true);
                }
                int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                int globalReloadVersion = (Integer)primaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION);
                int globalCaveDepth = (Integer)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH);
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = needsLoading = region.getLoadState() == 0 || region.getLoadState() == 4;
                    if (needsLoading) {
                        if (region.hasVersion() && region.getVersion() != globalVersion || !region.hasVersion() && region.getInitialVersion() != globalVersion || region.getLoadState() == 4 && reloadEverything && region.getReloadVersion() != globalReloadVersion || (region.getLoadState() == 4 || region.isMetaLoaded() && this.mainTextureLevel != region.getLevel()) && (globalRegionCacheHashCode != region.getCacheHashCode() || region.caveStartOutdated(region.getUpToDateCaveStart(), globalCaveDepth)) || region.getDim().getFullReloader() != null && region.getDim().getFullReloader().isPartOfReload(region)) {
                            region.setShouldCache(true, "loading");
                        }
                        region.setVersion(globalVersion);
                    }
                }
                if (needsLoading) {
                    BranchLeveledRegion parentRegion;
                    mapRegion = region;
                    synchronized (mapRegion) {
                        region.setAllCachePrepared(false);
                    }
                    boolean cacheOnlyMode = region.getDim().getMapWorld().isCacheOnlyMode();
                    boolean fromNothing = region.getLoadState() == 0;
                    boolean hasSomething = false;
                    boolean justMetaData = false;
                    boolean[] leafShouldAffectBranchesDest = new boolean[1];
                    int targetHighlightsHash = region.getTargetHighlightsHash();
                    boolean[] metaLoadedDest = new boolean[1];
                    boolean[][] textureLoaded = null;
                    if (cacheOnlyMode || region.getLoadState() == 0 && (!region.shouldCache() || !region.isMetaLoaded() || this.mainTextureLevel == region.getLevel()) || !region.shouldCache() && region.getLoadState() == 4) {
                        textureLoaded = new boolean[8][8];
                        justMetaData = region.loadCacheTextures(this.mapProcessor, !region.isMetaLoaded() && this.mainTextureLevel != region.getLevel(), textureLoaded, targetHighlightsHash, leafShouldAffectBranchesDest, metaLoadedDest, 10);
                    }
                    if (justMetaData) {
                        hasSomething = this.cleanupLoadedCache(region, textureLoaded, justMetaData, hasSomething, targetHighlightsHash, metaLoadedDest[0]);
                        if (debugConfig) {
                            WorldMap.LOGGER.info("Loaded meta data for " + region);
                        }
                    } else {
                        boolean shouldLoadProperly;
                        region.setHighlightsHash(targetHighlightsHash);
                        boolean shouldAddToLoaded = region.getLoadState() == 0;
                        MapRegion mapRegion2 = region;
                        synchronized (mapRegion2) {
                            boolean goingToPrepareCache;
                            boolean bl = goingToPrepareCache = region.shouldCache() && (region.isMetaLoaded() && this.mainTextureLevel != region.getLevel() || region.getLoadState() == 4 || region.getCacheFile() == null || !region.getCacheFile().exists());
                            if (!goingToPrepareCache) {
                                goingToPrepareCache = region.getDim().getFullReloader() != null && region.getDim().getFullReloader().isPartOfReload(region);
                            }
                            boolean bl2 = shouldLoadProperly = region.getLoadState() == 4 && region.isBeingWritten() || goingToPrepareCache;
                            if (cacheOnlyMode) {
                                shouldLoadProperly = false;
                            }
                            if (!shouldLoadProperly) {
                                if (leafShouldAffectBranchesDest[0]) {
                                    region.setRecacheHasBeenRequested(true, "cache affects branches");
                                    region.setShouldCache(true, "cache affects branches");
                                }
                                region.setLoadState((byte)3);
                            } else if (region.shouldCache()) {
                                region.setRecacheHasBeenRequested(true, "loading");
                            }
                        }
                        if (!shouldLoadProperly && textureLoaded != null) {
                            hasSomething = this.cleanupLoadedCache(region, textureLoaded, justMetaData, hasSomething, targetHighlightsHash, metaLoadedDest[0]);
                        }
                        this.mapProcessor.addToProcess(region);
                        if (shouldAddToLoaded) {
                            this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().addLoadedRegion(region);
                        }
                        if (shouldLoadProperly) {
                            region.setCacheHashCode(globalRegionCacheHashCode);
                            region.setReloadVersion(globalReloadVersion);
                            loaded = this.loadRegion(world, region, colourTypeCache, debugConfig, 10);
                            hasSomething = false;
                            if (!loaded) {
                                region.setShouldCache(false, "couldn't load");
                                region.setRecacheHasBeenRequested(false, "couldn't load");
                                if (region.getSaveExists() == null) {
                                    mapRegion2 = region;
                                    synchronized (mapRegion2) {
                                        region.setLoadState((byte)4);
                                    }
                                    region.deleteTexturesAndBuffers();
                                    this.mapProcessor.removeMapRegion(region);
                                }
                            } else {
                                for (int i = 0; i < 8; ++i) {
                                    for (int j = 0; j < 8; ++j) {
                                        MapRegion mapRegion3;
                                        MapTileChunk mapTileChunk = region.getChunk(i, j);
                                        if (mapTileChunk != null) {
                                            if (!mapTileChunk.includeInSave()) {
                                                mapTileChunk.getLeafTexture().resetBiomes();
                                                if (!mapTileChunk.hasHighlightsIfUndiscovered()) {
                                                    region.setChunk(i, j, null);
                                                    mapTileChunk.getLeafTexture().deleteTexturesAndBuffers();
                                                    continue;
                                                }
                                                mapTileChunk.setLoadState((byte)2);
                                                mapTileChunk.unsetHasHadTerrain();
                                                mapTileChunk.getLeafTexture().requestHighlightOnlyUpload();
                                                hasSomething = true;
                                                mapRegion3 = region;
                                                synchronized (mapRegion3) {
                                                    region.updateLeafTextureVersion(i, j, targetHighlightsHash);
                                                    continue;
                                                }
                                            }
                                            hasSomething = true;
                                            continue;
                                        }
                                        if (region.leafTextureVersionSum[i][j] == 0) continue;
                                        mapRegion3 = region;
                                        synchronized (mapRegion3) {
                                            region.updateLeafTextureVersion(i, j, 0);
                                            continue;
                                        }
                                    }
                                }
                                if (!hasSomething) {
                                    MapRegion i = region;
                                    synchronized (i) {
                                        if (!region.isBeingWritten() && region.getLoadState() <= 1) {
                                            region.setLoadState((byte)3);
                                        }
                                    }
                                    loaded = false;
                                }
                            }
                            MapRegion i = region;
                            synchronized (i) {
                                if (region.getLoadState() <= 1) {
                                    region.setLoadState((byte)2);
                                }
                                region.setLastSaveTime(region.isResaving() ? -60000L : System.currentTimeMillis());
                            }
                            BranchLeveledRegion parentRegion2 = region.getParent();
                            if (parentRegion2 != null) {
                                parentRegion2.setShouldCheckForUpdatesRecursive(true);
                            }
                        } else if (debugConfig) {
                            WorldMap.LOGGER.info("Loaded from cache only for " + region);
                        }
                        region.loadingNeededForBranchLevel = 0;
                    }
                    if (fromNothing && !hasSomething && (parentRegion = region.getParent()) != null) {
                        parentRegion.setShouldCheckForUpdatesRecursive(true);
                    }
                }
                region.setReloadHasBeenRequested(false, "loading");
                this.removeToLoad(region);
            }
            this.loadingFiles = false;
            this.mapProcessor.popIsLoading();
        }
        int regionsToSave = 3;
        while (!this.toSave.isEmpty() && (this.saveAll || regionsToSave > 0)) {
            boolean regionLoaded;
            MapRegion region;
            MapRegion region2 = region = this.toSave.get(0);
            synchronized (region2) {
                regionLoaded = region.getLoadState() == 2;
            }
            if (regionLoaded) {
                if (!region.isBeingWritten()) {
                    throw new Exception("Saving a weird region: " + region);
                }
                region.pushWriterPause();
                boolean notEmpty = this.saveRegion(region, debugConfig, 20);
                region.setResaving(false);
                if (notEmpty) {
                    if (!region.isAllCachePrepared()) {
                        MapRegion needsLoading = region;
                        synchronized (needsLoading) {
                            if (!region.isAllCachePrepared()) {
                                region.requestRefresh(this.mapProcessor, false);
                            }
                        }
                    }
                    region.setRecacheHasBeenRequested(true, "saving");
                    region.setShouldCache(true, "saving");
                    region.setBeingWritten(false);
                    --regionsToSave;
                } else {
                    this.mapProcessor.removeMapRegion(region);
                }
                region.popWriterPause();
                if (region.getWorldId() == null || !this.mapProcessor.isEqual(region.getWorldId(), region.getDimId(), region.getMwId())) {
                    if (region.getCacheFile() != null) {
                        region.convertCacheToOutdated(this, "is outdated");
                        if (debugConfig) {
                            WorldMap.LOGGER.info(String.format("Converting cache for region %s because it IS outdated.", region));
                        }
                    }
                    region.clearRegion(this.mapProcessor);
                }
            } else if (debugConfig) {
                WorldMap.LOGGER.info("Tried to save a weird region: " + region + " " + region.getWorldId() + " " + region.getDimId() + " " + region.getMwId() + " " + region.getLoadState());
            }
            this.toSave.remove(region);
        }
        this.saveAll = false;
        if (!this.toLoadBranchCache.isEmpty()) {
            int limit = this.toLoadBranchCache.size();
            this.mapProcessor.pushIsLoading();
            if (!this.mapProcessor.isWaitingForWorldUpdate()) {
                while (limit > 0) {
                    BranchLeveledRegion region;
                    --limit;
                    ArrayList<BranchLeveledRegion> notEmpty = this.toLoadBranchCache;
                    synchronized (notEmpty) {
                        if (this.toLoadBranchCache.isEmpty()) {
                            break;
                        }
                        region = this.toLoadBranchCache.get(0);
                    }
                    region.preCacheLoad();
                    LayeredRegionManager regionManager = this.mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions();
                    regionManager.addLoadedRegion(region);
                    region.setCacheFile(region.findCacheFile(this));
                    boolean[] metaLoadedDest = new boolean[1];
                    boolean[][] textureLoaded = new boolean[8][8];
                    region.loadCacheTextures(this.mapProcessor, false, textureLoaded, 0, null, metaLoadedDest, 10);
                    if (metaLoadedDest[0]) {
                        region.confirmMetaLoaded();
                    }
                    this.mapProcessor.addToProcess(region);
                    if (region.getCacheFile() == null) {
                        region.setShouldCheckForUpdatesRecursive(true);
                    } else {
                        region.setShouldCheckForUpdatesSingle(true);
                    }
                    region.setShouldCache(false, "branch loading");
                    region.setLoaded(true);
                    if (debugConfig) {
                        WorldMap.LOGGER.info("Loaded cache for branch region " + region);
                    }
                    region.setReloadHasBeenRequested(false, "loading");
                    ArrayList<BranchLeveledRegion> globalReloadVersion = this.toLoadBranchCache;
                    synchronized (globalReloadVersion) {
                        this.toLoadBranchCache.remove(region);
                    }
                }
            }
            this.mapProcessor.popIsLoading();
        }
        if (this.mapProcessor.getMapWorld().getCurrentDimensionId() != null) {
            this.workingDimList.clear();
            this.mapProcessor.getMapWorld().getDimensions(this.workingDimList);
            for (int d = 0; d < this.workingDimList.size(); ++d) {
                MapDimension dim = this.workingDimList.get(d);
                while (!dim.regionsToCache.isEmpty()) {
                    File permFile;
                    File tempFile;
                    boolean successfullySaved;
                    LeveledRegion<?> region = this.removeToCache(dim, 0);
                    region.preCache();
                    boolean skipCaching = region.skipCaching(globalVersion);
                    if (!region.shouldCache() || !region.recacheHasBeenRequested() || skipCaching) {
                        if (WorldMap.detailed_debug) {
                            WorldMap.LOGGER.info("toCache cancel: " + region + " " + !region.shouldCache() + " " + !region.recacheHasBeenRequested() + " " + !region.isAllCachePrepared() + " " + skipCaching + " " + globalVersion);
                        }
                        if (region.shouldCache()) {
                            region.deleteBuffers();
                        }
                        region.setShouldCache(false, "toCache cancel");
                        region.setRecacheHasBeenRequested(false, "toCache cancel");
                        region.postCache(null, this, false);
                        continue;
                    }
                    if (!region.isAllCachePrepared()) {
                        throw new RuntimeException("Trying to save cache for a region with cache not prepared: " + region + " " + region.getExtraInfo());
                    }
                    if (region.getCacheFile() != null) {
                        this.removeTempCacheRequest(region.getCacheFile());
                    }
                    if (successfullySaved = region.saveCacheTextures(tempFile = this.getSecondaryFile(".xwmc.temp", permFile = region.findCacheFile(this)), debugConfig, 10)) {
                        this.cacheToConvertFromTemp.add(permFile);
                        region.setCacheFile(permFile);
                    }
                    region.setShouldCache(false, "toCache normal");
                    region.setRecacheHasBeenRequested(false, "toCache normal");
                    region.postCache(permFile, this, successfullySaved);
                }
            }
        }
        for (int i = 0; i < this.cacheToConvertFromTemp.size(); ++i) {
            File permFile = this.cacheToConvertFromTemp.get(i);
            File tempFile = this.getSecondaryFile(".xwmc.temp", permFile);
            try {
                if (Files.exists(tempFile.toPath(), new LinkOption[0])) {
                    IOUtils.safeMoveAndReplace((Path)tempFile.toPath(), (Path)permFile.toPath(), (boolean)true);
                }
                this.cacheToConvertFromTemp.remove(i);
                --i;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean removeTempCacheRequest(File file) {
        boolean result = false;
        while (this.cacheToConvertFromTemp.remove(file)) {
            result = true;
        }
        return result;
    }

    public void addTempCacheRequest(File file) {
        this.cacheToConvertFromTemp.add(file);
    }

    private boolean cleanupLoadedCache(MapRegion region, boolean[][] textureLoaded, boolean justMetaData, boolean hasSomething, int targetHighlightsHash, boolean metaLoaded) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                boolean loaded = textureLoaded[i][j];
                if (justMetaData || !loaded) {
                    MapTileChunk mapTileChunk = region.getChunk(i, j);
                    if (mapTileChunk != null) {
                        if (justMetaData || !mapTileChunk.hasHighlightsIfUndiscovered()) {
                            region.setChunk(i, j, null);
                            if (!justMetaData) {
                                mapTileChunk.getLeafTexture().deleteTexturesAndBuffers();
                            }
                        } else {
                            mapTileChunk.getLeafTexture().requestHighlightOnlyUpload();
                            hasSomething = true;
                        }
                        if (loaded || !mapTileChunk.hasHighlightsIfUndiscovered()) continue;
                        region.updateLeafTextureVersion(i, j, targetHighlightsHash);
                        continue;
                    }
                    if (loaded || region.leafTextureVersionSum[i][j] == 0) continue;
                    region.updateLeafTextureVersion(i, j, 0);
                    continue;
                }
                hasSomething = true;
            }
        }
        if (metaLoaded) {
            region.confirmMetaLoaded();
        }
        return hasSomething;
    }

    private void savePixel(MapBlock pixel, DataOutputStream out) throws IOException {
        int biome;
        int parametres = pixel.getParametres();
        out.writeInt(parametres);
        if (!pixel.isGrass()) {
            out.writeInt(pixel.getState());
        }
        if ((parametres & 0x1000000) != 0) {
            out.write(pixel.getTopHeight());
        }
        if (pixel.getNumberOfOverlays() != 0) {
            out.write(pixel.getOverlays().size());
            for (int i = 0; i < pixel.getOverlays().size(); ++i) {
                this.saveOverlay(pixel.getOverlays().get(i), out);
            }
        }
        if (pixel.getColourType() == 3) {
            out.writeInt(pixel.getCustomColour());
        }
        if ((biome = pixel.getBiome()) != -1) {
            if (biome < 255) {
                out.write(pixel.getBiome());
            } else {
                out.write(255);
                out.writeInt(biome);
            }
        }
    }

    private void loadPixel(Integer next, MapBlock pixel, DataInputStream in, int saveVersion, World world, int[] biomeBuffer, BlockStateColorTypeCache colorTypeCache) throws IOException {
        boolean topHeightIsDifferent;
        int parametres = next != null ? next.intValue() : in.readInt();
        if ((parametres & 1) != 0) {
            pixel.setState(in.readInt());
        } else {
            pixel.setState(Block.func_176210_f((IBlockState)Blocks.field_150349_c.func_176223_P()));
        }
        if ((parametres & 0x40) != 0) {
            pixel.setHeight(in.read());
        } else {
            pixel.setHeight(parametres >> 12 & 0xFF);
        }
        boolean bl = saveVersion < 4 ? false : (topHeightIsDifferent = (parametres & 0x1000000) != 0);
        if (topHeightIsDifferent) {
            pixel.setTopHeight(in.read());
        } else {
            pixel.setTopHeight(pixel.getHeight());
        }
        this.overlayBuilder.startBuilding();
        if ((parametres & 2) != 0) {
            int amount = in.read();
            for (int i = 0; i < amount; ++i) {
                this.loadOverlay(pixel, in, saveVersion, world, biomeBuffer, colorTypeCache);
            }
        }
        this.overlayBuilder.finishBuilding(pixel);
        int savedColourType = parametres >> 2 & 3;
        if (savedColourType == 3) {
            pixel.setColourType((byte)3);
            pixel.setCustomColour(in.readInt());
        }
        int biomeKey = -1;
        if (savedColourType != 0 && savedColourType != 3 || (parametres & 0x100000) != 0) {
            int biomeByte = in.read();
            biomeKey = saveVersion < 3 || biomeByte < 255 ? biomeByte : in.readInt();
        }
        if (savedColourType != 3) {
            colorTypeCache.getBlockBiomeColour(world, Misc.getStateById(pixel.getState()), null, biomeBuffer, biomeKey);
            pixel.setColourType((byte)biomeBuffer[0]);
            pixel.setCustomColour(biomeBuffer[2]);
        }
        pixel.setBiome(biomeKey);
        if (pixel.getColourType() == 3 && pixel.getCustomColour() == -1) {
            pixel.setColourType((byte)0);
        }
        pixel.setLight((byte)(parametres >> 8 & 0xF));
        pixel.setGlowing(this.mapProcessor.getMapWriter().isGlowing(Misc.getStateById(pixel.getState())));
    }

    private void saveOverlay(Overlay o, DataOutputStream out) throws IOException {
        out.writeInt(o.getParametres());
        if (!o.isWater()) {
            out.writeInt(o.getState());
        }
        if (o.getColourType() == 3) {
            out.writeInt(o.getCustomColour());
        }
    }

    private void loadOverlay(MapBlock pixel, DataInputStream in, int saveVersion, World world, int[] biomeBuffer, BlockStateColorTypeCache colourTypeCache) throws IOException {
        byte savedColourType;
        int parametres = in.readInt();
        int state = (parametres & 1) != 0 ? in.readInt() : Block.func_176210_f((IBlockState)Blocks.field_150355_j.func_176223_P());
        int opacity = 1;
        if (saveVersion < 1 && (parametres & 2) != 0) {
            in.readInt();
        }
        if ((savedColourType = (byte)(parametres >> 8 & 3)) == 2 || (parametres & 4) != 0) {
            biomeBuffer[0] = 3;
            biomeBuffer[2] = in.readInt();
            if (biomeBuffer[2] == -1) {
                biomeBuffer[0] = 0;
            }
            savedColourType = (byte)biomeBuffer[0];
        }
        if (saveVersion < 8) {
            if ((parametres & 8) != 0) {
                opacity = in.readInt();
            }
        } else {
            opacity = parametres >> 11 & 0xF;
        }
        byte light = (byte)(parametres >> 4 & 0xF);
        this.overlayBuilder.build(state, biomeBuffer, opacity, light, world, this.mapProcessor, null, 0, colourTypeCache, savedColourType == 3 ? null : this.biomeInfoSupplier);
    }

    public boolean isRegionDetectionComplete() {
        return this.regionDetectionComplete;
    }

    public void setRegionDetectionComplete(boolean regionDetectionComplete) {
        this.regionDetectionComplete = regionDetectionComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCache(LeveledRegion<?> region) {
        if (!this.toCacheContains(region)) {
            ArrayList<LeveledRegion<?>> arrayList = region.getDim().regionsToCache;
            synchronized (arrayList) {
                region.getDim().regionsToCache.add(region);
            }
            if (WorldMapClientConfigUtils.getDebug()) {
                WorldMap.LOGGER.info("Requesting cache! " + region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeveledRegion<?> removeToCache(MapDimension mapDim, int index) {
        ArrayList<LeveledRegion<?>> arrayList = mapDim.regionsToCache;
        synchronized (arrayList) {
            return mapDim.regionsToCache.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToCache(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> arrayList = region.getDim().regionsToCache;
        synchronized (arrayList) {
            region.getDim().regionsToCache.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toCacheContains(LeveledRegion<?> region) {
        ArrayList<LeveledRegion<?>> arrayList = region.getDim().regionsToCache;
        synchronized (arrayList) {
            return region.getDim().regionsToCache.contains(region);
        }
    }

    public ArrayList<MapRegion> getToSave() {
        return this.toSave;
    }

    public LeveledRegion<?> getNextToLoadByViewing() {
        return this.nextToLoadByViewing;
    }

    @Deprecated
    public void setNextToLoadByViewing(MapRegion nextToLoadByViewing) {
        this.setNextToLoadByViewing((LeveledRegion<?>)nextToLoadByViewing);
    }

    public void setNextToLoadByViewing(LeveledRegion<?> nextToLoadByViewing) {
        this.nextToLoadByViewing = nextToLoadByViewing;
    }

    public void safeDelete(Path filePath, String extension) throws IOException {
        if (!filePath.getFileName().toString().endsWith(extension)) {
            throw new RuntimeException("Incorrect file extension: " + filePath);
        }
        Files.deleteIfExists(filePath);
    }

    public void safeMoveAndReplace(Path fromPath, Path toPath, String fromExtension, String toExtension) throws IOException {
        if (!toPath.getFileName().toString().endsWith(toExtension) || !fromPath.getFileName().toString().endsWith(fromExtension)) {
            throw new RuntimeException("Incorrect file extension: " + fromPath + " " + toPath);
        }
        IOUtils.safeMoveAndReplace((Path)fromPath, (Path)toPath, (boolean)true);
    }

    public int getSizeOfToLoadBranchCache() {
        return this.toLoadBranchCache.size();
    }
}

