/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.cache.BrokenBlockTintCache;
import xaero.map.region.MapTile;

public class BlockTintProvider
implements IBlockDisplayReader {
    private final MutableRegistry<Biome> biomeRegistry;
    private final BiomeColorCalculator calculator;
    private final BlockPos.Mutable mutablePos;
    private final MapProcessor mapProcessor;
    private final BrokenBlockTintCache brokenBlockTintCache;
    private final MapWriter mapWriter;
    private BlockState state;
    private boolean overlay;
    private MapTile tile;
    private int caveLayer;

    public BlockTintProvider(MutableRegistry<Biome> biomeRegistry, BiomeColorCalculator calculator, MapProcessor mapProcessor, BrokenBlockTintCache brokenBlockTintCache, MapWriter mapWriter) {
        this.biomeRegistry = biomeRegistry;
        this.calculator = calculator;
        this.mutablePos = new BlockPos.Mutable();
        this.mapProcessor = mapProcessor;
        this.brokenBlockTintCache = brokenBlockTintCache;
        this.mapWriter = mapWriter;
    }

    public TileEntity func_175625_s(BlockPos blockPos) {
        return null;
    }

    public BlockState func_180495_p(BlockPos blockPos) {
        return this.state;
    }

    public FluidState func_204610_c(BlockPos blockPos) {
        return this.state == null ? null : this.state.func_204520_s();
    }

    public float func_230487_a_(Direction direction, boolean bl) {
        return 1.0f;
    }

    public WorldLightManager func_225524_e_() {
        return null;
    }

    public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        this.mutablePos.func_189533_g((Vector3i)blockPos);
        return this.calculator.getBiomeColor(colorResolver, this.overlay, this.mutablePos, this.tile, this.caveLayer, this.biomeRegistry, this.mapProcessor);
    }

    public int getBiomeColor(BlockPos blockPos, BlockState state, boolean overlay, MapTile tile, int caveLayer) {
        if (this.brokenBlockTintCache.isBroken(state)) {
            return -1;
        }
        this.mutablePos.func_189533_g((Vector3i)blockPos);
        this.state = state;
        this.overlay = overlay;
        this.tile = tile;
        this.caveLayer = caveLayer;
        try {
            return Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (IBlockDisplayReader)this, blockPos, this.mapWriter.getBlockTintIndex(state));
        }
        catch (Throwable t) {
            this.brokenBlockTintCache.setBroken(state);
            WorldMap.LOGGER.error("Error calculating block tint for block state " + state + "! Total: " + this.brokenBlockTintCache.getSize(), t);
            return -1;
        }
    }
}

