/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.controls;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.config.context.BuiltInEditConfigScreenContexts;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.controls.ControlsRegister;
import xaero.map.controls.KeyEvent;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;

public class ControlsHandler {
    private MapProcessor mapProcessor;
    private ArrayList<KeyEvent> keyEvents = new ArrayList();
    private ArrayList<KeyEvent> oldKeyEvents = new ArrayList();

    public ControlsHandler(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    private boolean eventExists(KeyBinding kb) {
        for (KeyEvent o : this.keyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return this.oldEventExists(kb);
    }

    private boolean oldEventExists(KeyBinding kb) {
        for (KeyEvent o : this.oldKeyEvents) {
            if (o.getKb() != kb) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyRepeat(KeyBinding kb) {
        return kb != ControlsRegister.keyOpenMap && kb != ControlsRegister.keyOpenSettings && kb != ControlsRegister.keyOpenServerSettings && kb != ControlsRegister.keyToggleDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyDown(KeyBinding kb, boolean tickEnd, boolean isRepeat) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!tickEnd) {
            if (kb == ControlsRegister.keyOpenMap) {
                mc.func_147108_a((Screen)new GuiMap(null, null, this.mapProcessor, mc.func_175606_aa()));
            } else if (kb == ControlsRegister.keyOpenSettings) {
                mc.func_147108_a((Screen)new GuiWorldMapSettings(BuiltInEditConfigScreenContexts.CLIENT));
            } else if (kb == ControlsRegister.keyOpenServerSettings) {
                mc.func_147108_a((Screen)new GuiWorldMapSettings(BuiltInEditConfigScreenContexts.SERVER));
            } else if (kb == ControlsRegister.keyQuickConfirm) {
                WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = worldmapSession.getMapProcessor();
                Object object = mapProcessor.uiPauseSync;
                synchronized (object) {
                    if (!mapProcessor.isUIPaused()) {
                        mapProcessor.quickConfirmMultiworld();
                    }
                }
            } else if (kb == ControlsRegister.keyToggleDimension) {
                this.mapProcessor.getMapWorld().toggleDimension(!Screen.func_231173_s_());
                String messageType = this.mapProcessor.getMapWorld().getCustomDimensionId() == null ? "gui.xaero_switched_to_current_dimension" : "gui.xaero_switched_to_dimension";
                ResourceLocation messageDimLoc = this.mapProcessor.getMapWorld().getFutureDimensionId() == null ? null : this.mapProcessor.getMapWorld().getFutureDimensionId().func_240901_a_();
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent(messageType, new Object[]{messageDimLoc}));
            }
        }
    }

    public void keyUp(KeyBinding kb, boolean tickEnd) {
        if (!tickEnd) {
            // empty if block
        }
    }

    public void handleKeyEvents() {
        KeyEvent ke;
        int i;
        Minecraft mc = Minecraft.func_71410_x();
        this.onKeyInput(mc);
        for (i = 0; i < this.keyEvents.size(); ++i) {
            ke = this.keyEvents.get(i);
            if (mc.field_71462_r == null) {
                this.keyDown(ke.getKb(), ke.isTickEnd(), ke.isRepeat());
            }
            if (!ke.isRepeat()) {
                if (!this.oldEventExists(ke.getKb())) {
                    this.oldKeyEvents.add(ke);
                }
                this.keyEvents.remove(i);
                --i;
                continue;
            }
            if (KeyMappingUtils.isPhysicallyDown((KeyBinding)ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.keyEvents.remove(i);
            --i;
        }
        for (i = 0; i < this.oldKeyEvents.size(); ++i) {
            ke = this.oldKeyEvents.get(i);
            if (KeyMappingUtils.isPhysicallyDown((KeyBinding)ke.getKb())) continue;
            this.keyUp(ke.getKb(), ke.isTickEnd());
            this.oldKeyEvents.remove(i);
            --i;
        }
    }

    public void onKeyInput(Minecraft mc) {
        List<KeyBinding> kbs = WorldMap.controlsRegister.keybindings;
        for (int i = 0; i < kbs.size(); ++i) {
            KeyBinding kb = kbs.get(i);
            try {
                boolean pressed = kb.func_151468_f();
                while (kb.func_151468_f()) {
                }
                if (mc.field_71462_r != null || this.eventExists(kb) || !pressed) continue;
                this.keyEvents.add(new KeyEvent(kb, false, ControlsHandler.isKeyRepeat(kb), true));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

